/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.deamon;

import com.yqbsoft.laser.service.monitor.deamon.DeamonThread;
import com.yqbsoft.laser.service.monitor.service.AnalyseService;
import com.yqbsoft.laser.service.monitor.support.ApiTree;
import com.yqbsoft.laser.service.monitor.support.MsgStore;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyseThread
implements DeamonThread {
    private static final Logger logger = LoggerFactory.getLogger(AnalyseThread.class);
    private static final int THREAD_SIZE = 50;
    private ExecutorService executor = Executors.newFixedThreadPool(50);
    private AnalyseService analyseService;

    @Override
    @PostConstruct
    public void start() {
        int i = 0;
        while (i < 50) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ApiTree obj = null;
                        while ((obj = MsgStore.analyseQueue.take()) != null) {
                            AnalyseThread.this.analyseService.submit(obj, true);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                }
            });
            ++i;
        }
        logger.info("[AnalyseThread]process thread start!");
    }

    public void setAnalyseService(AnalyseService analyseService) {
        this.analyseService = analyseService;
    }
}

