/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.deamon;

import com.yqbsoft.laser.service.monitor.deamon.DeamonThread;
import com.yqbsoft.laser.service.monitor.service.WarnProcessor;
import com.yqbsoft.laser.service.monitor.support.Entry;
import com.yqbsoft.laser.service.monitor.support.MsgStore;
import com.yqbsoft.laser.service.monitor.support.Point;
import com.yqbsoft.laser.service.monitor.support.ProcessorContext;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarnProcessThread
implements DeamonThread {
    private static final Logger logger = LoggerFactory.getLogger(WarnProcessThread.class);
    private static final int THREAD_SIZE = 50;
    private WarnProcessor warnProcessor;
    private ExecutorService executor = Executors.newFixedThreadPool(50);

    @Override
    @PostConstruct
    public void start() {
        int i = 0;
        while (i < 50) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Entry<Point, ProcessorContext> entry = null;
                        while ((entry = MsgStore.warnQueue.take()) != null) {
                            WarnProcessThread.this.warnProcessor.process(entry.getK(), entry.getV());
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                }
            });
            ++i;
        }
        logger.info("[WarnProcessThread]process thread start!");
    }

    public WarnProcessor getWarnProcessor() {
        return this.warnProcessor;
    }

    public void setWarnProcessor(WarnProcessor warnProcessor) {
        this.warnProcessor = warnProcessor;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }
}

