/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.repository;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.monitor.IvkReject;
import com.yqbsoft.laser.service.esb.core.monitor.IvkRejectFact;
import com.yqbsoft.laser.service.esb.core.monitor.MonitorCache;
import com.yqbsoft.laser.service.monitor.domain.AmmMIvkRejectDomain;
import com.yqbsoft.laser.service.monitor.enums.FactorType;
import com.yqbsoft.laser.service.monitor.model.AmmMIvkReject;
import com.yqbsoft.laser.service.monitor.repository.EventRepositoryImpl;
import com.yqbsoft.laser.service.monitor.repository.RejectRepository;
import com.yqbsoft.laser.service.monitor.service.AmmMIvkRejectService;
import com.yqbsoft.laser.service.monitor.support.Point;
import com.yqbsoft.laser.service.monitor.support.ProcessorContext;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.TokenUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class RejectRepositoryImpl
implements RejectRepository {
    private static final Logger logger;
    private AmmMIvkRejectService ammMIvkRejectService;
    private static final String API_KEY = "apiKey";
    private static final List<Field> rejectFds;
    private static final Map<String, Field> rejectFdMap;

    static {
        Field field;
        logger = LoggerFactory.getLogger(EventRepositoryImpl.class);
        rejectFds = new LinkedList<Field>();
        rejectFdMap = new HashMap<String, Field>();
        HashMap<String, Field> map = new HashMap<String, Field>();
        Field[] fieldArray = IvkReject.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            field = fieldArray[n2];
            map.put(field.getName(), field);
            ++n2;
        }
        fieldArray = IvkRejectFact.class.getDeclaredFields();
        n = fieldArray.length;
        n2 = 0;
        while (n2 < n) {
            field = fieldArray[n2];
            Field fd = (Field)map.get(field.getName());
            if (fd != null) {
                fd.setAccessible(true);
                rejectFdMap.put(field.getName(), fd);
                if (!API_KEY.equals(field.getName())) {
                    rejectFds.add(fd);
                }
            }
            ++n2;
        }
    }

    @Override
    public void storeAndUpdateCache(Point point, ProcessorContext context) throws Exception {
        logger.info("[RejectRepository]store:" + context.getResult());
        FactorType type = FactorType.getEnum(point.getFactorType());
        if (type == null) {
            return;
        }
        String apiKey = TokenUtil.genToken((Object[])new Object[]{point.getApiCode(), point.getApiVersion()});
        Map apiFact2IdMap = (Map)ObjectUtils.defaultIfNull((Object)MonitorCache.getFact2IvkRejectIdsMap(), new HashMap());
        Map fact2IdMap = MapUtil.getSubMap((Map)apiFact2IdMap, (Object)apiKey);
        Map ivkMap = (Map)ObjectUtils.defaultIfNull((Object)MonitorCache.getIvkRejectMap(), new HashMap());
        IvkReject existRej = null;
        boolean isAll = FactorType.ALL == type;
        existRej = isAll ? this.findExistIvkReject(fact2IdMap, rejectFds.get(0).getName(), null, false) : this.findExistIvkReject(fact2IdMap, type.getFactPropName(), point.getFactorNo(), true);
        if (existRej != null) {
            return;
        }
        existRej = this.makeReject(point, type, apiKey);
        AmmMIvkReject mIvkReject = this.ammMIvkRejectService.saveMIvkReject(this.makeDomain(existRej));
        existRej.setIvkRejectId(mIvkReject.getIvkRejectId());
        ivkMap.put(existRej.getIvkRejectId(), existRej);
        MapUtil.getList((Map)fact2IdMap, (Object)TokenUtil.genToken((Object[])new Object[]{API_KEY, apiKey})).add(existRej.getIvkRejectId());
        if (isAll) {
            for (Field field : rejectFds) {
                MapUtil.getList((Map)fact2IdMap, (Object)TokenUtil.genToken((Object[])new Object[]{field.getName(), null})).add(existRej.getIvkRejectId());
            }
        } else {
            for (Field field : rejectFds) {
                String value = field.getName().equals(type.getFactPropName()) ? point.getFactorNo() : null;
                MapUtil.getList((Map)fact2IdMap, (Object)TokenUtil.genToken((Object[])new Object[]{field.getName(), value})).add(existRej.getIvkRejectId());
            }
        }
        DisUtil.setJsonVer((String)"factInvokeReject", (Object)apiFact2IdMap);
        MonitorCache.setFact2IvkRejectIdsMap((Map)apiFact2IdMap);
        DisUtil.setJsonVer((String)"invokeReject", (Object)ivkMap);
        MonitorCache.setIvkRejectMap((Map)ivkMap);
    }

    private IvkReject findExistIvkReject(Map<String, List<Integer>> fact2IdMap, String propName, String propValue, boolean ignoreCurrentPropValue) throws IllegalArgumentException, IllegalAccessException {
        IvkReject existRej = null;
        Map ivkMap = MonitorCache.getIvkRejectMap();
        List ids = MapUtil.getList(fact2IdMap, (Object)TokenUtil.genToken((Object[])new Object[]{propName, propValue}));
        for (Integer id : ids) {
            IvkReject rej = (IvkReject)ivkMap.get(id);
            if (rej == null) continue;
            int i = 0;
            for (Field field : rejectFds) {
                if (ignoreCurrentPropValue && field.getName().equals(propName)) {
                    ++i;
                    continue;
                }
                if (field.get(rej) != null) break;
                ++i;
            }
            if (i < rejectFds.size()) continue;
            existRej = rej;
            break;
        }
        return existRej;
    }

    private IvkReject makeReject(Point point, FactorType type, String apiKey) throws IllegalArgumentException, IllegalAccessException {
        Field field;
        IvkReject existRej = new IvkReject();
        existRej.setApiKey(apiKey);
        if (FactorType.ALL != type && (field = rejectFdMap.get(type.getFactPropName())) != null) {
            field.set(existRej, point.getFactorNo());
        }
        return existRej;
    }

    private AmmMIvkRejectDomain makeDomain(IvkReject ivkReject) {
        AmmMIvkRejectDomain mIvkReject = new AmmMIvkRejectDomain();
        try {
            BeanUtils.copyProperties((Object)ivkReject, (Object)mIvkReject);
        }
        catch (Exception e) {
            return null;
        }
        return mIvkReject;
    }

    public void setAmmMIvkRejectService(AmmMIvkRejectService ammMIvkRejectService) {
        this.ammMIvkRejectService = ammMIvkRejectService;
    }
}

