/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.rules;

import com.yqbsoft.laser.service.monitor.domain.AmmMStatOutReDomain;
import com.yqbsoft.laser.service.monitor.rules.AbstractExecuteRule;
import com.yqbsoft.laser.service.monitor.rules.result.CountAndTimeResult;
import com.yqbsoft.laser.service.monitor.rules.support.SlidingWindowCounter;
import com.yqbsoft.laser.service.monitor.support.ApiNode;
import com.yqbsoft.laser.service.monitor.support.Entry;
import com.yqbsoft.laser.service.monitor.support.MsgStore;
import com.yqbsoft.laser.service.monitor.support.Point;
import com.yqbsoft.laser.service.monitor.support.PointCache;
import com.yqbsoft.laser.service.monitor.support.ProcessorContext;
import com.yqbsoft.laser.service.monitor.support.ValidateResult;
import com.yqbsoft.laser.service.monitor.support.ValidateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeanUtils;

public class StatCountAndTimeRule
extends AbstractExecuteRule {
    private static final int THREAD_SIZE = 50;
    private ExecutorService executor = Executors.newFixedThreadPool(50);
    private SlidingWindowCounter<Integer, CountAndTimeResult, ApiNode> counter = new SlidingWindowCounter(CountAndTimeResult.class, 3);

    @Override
    @PostConstruct
    public void start() {
        int i = 0;
        while (i < 50) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        Entry entry = null;
                        try {
                            entry = (Entry)StatCountAndTimeRule.this.queue.take();
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                        }
                        StatCountAndTimeRule.this.stat((ApiNode)entry.getK(), (Point)entry.getV());
                        StatCountAndTimeRule.this.checkValve((ApiNode)entry.getK(), (Point)entry.getV());
                    }
                }
            });
            ++i;
        }
        this.logger.info("[StatCountAndTimeRule]started!");
    }

    private void stat(ApiNode node, Point point) {
        this.counter.incrementCount(point.getPointId(), node);
    }

    private void checkValve(ApiNode node, Point point) {
        ValidateResult res;
        CountAndTimeResult result = this.getResult(point.getPointId());
        if (result != null && !(res = ValidateUtil.checkValve(point, JsonUtil.buildNormalBinder().toJson((Object)result))).isSuccess()) {
            try {
                MsgStore.warnQueue.put(new Entry<Point, ProcessorContext>(point, new ProcessorContext(res, node.getOuter())));
            }
            catch (Exception e) {
                Thread.interrupted();
            }
        }
    }

    @Override
    public boolean doSchedule(Date time, Integer pointId) {
        Point point = PointCache.getId2PointMap().get(pointId);
        if (point == null) {
            return false;
        }
        CountAndTimeResult result = this.counter.advanceWindowThenGetPeriodCount(pointId);
        if (result == null) {
            return true;
        }
        AmmMStatOutReDomain domain = new AmmMStatOutReDomain();
        BeanUtils.copyProperties((Object)point, (Object)domain);
        domain.setApiKey(point.getApiCode());
        domain.setOutValues(JsonUtil.buildNonNullBinder().toJson((Object)result));
        domain.setGmtCreate(new Date());
        domain.setStatTime(time);
        try {
            MsgStore.outStoreQueue.put(domain);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        return true;
    }

    @Override
    public CountAndTimeResult getResult(Integer pointId) {
        return this.counter.getCurrentCount(pointId);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public SlidingWindowCounter<Integer, CountAndTimeResult, ApiNode> getCounter() {
        return this.counter;
    }

    public void setCounter(SlidingWindowCounter<Integer, CountAndTimeResult, ApiNode> counter) {
        this.counter = counter;
    }
}

