/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.rules.result;

import com.yqbsoft.laser.service.monitor.domain.AmmMEvtInfoDomain;
import com.yqbsoft.laser.service.monitor.rules.result.StatResult;
import com.yqbsoft.laser.service.monitor.support.ApiNode;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class CountAndTimeResult
implements StatResult<ApiNode> {
    private AtomicInteger totalCount = new AtomicInteger();
    private AtomicInteger succCount = new AtomicInteger();
    private AtomicInteger bizExCount = new AtomicInteger();
    private AtomicInteger sysExCount = new AtomicInteger();
    private AtomicLong totalTime = new AtomicLong();
    private AtomicLong succTotalTime = new AtomicLong();
    private AtomicLong bizExTotalTime = new AtomicLong();
    private AtomicLong sysExTotalTime = new AtomicLong();
    private long succAvgTime;
    private int validCount;
    private int failCount;
    private double failRate;
    private double bizExRate;
    private double sysExRate;

    @Override
    public void incrementCount(ApiNode t) {
        AmmMEvtInfoDomain evt = t.getOuter();
        this.totalCount.incrementAndGet();
        this.totalTime.addAndGet(evt.getEndTime() - evt.getStartTime());
        if ("OK".equals(evt.getResultType())) {
            this.succCount.incrementAndGet();
            this.succTotalTime.incrementAndGet();
        } else if ("BERROR".equals(evt.getResultType())) {
            this.bizExCount.incrementAndGet();
            this.bizExTotalTime.incrementAndGet();
        } else if ("SERROR".equals(evt.getResultType())) {
            this.sysExCount.incrementAndGet();
            this.sysExTotalTime.incrementAndGet();
        }
    }

    @Override
    public void calcInferCount() {
        this.getValidCount();
        this.getSuccAvgTime();
        this.getFailRate();
        this.getSysExRate();
        this.getBizExRate();
        this.getFailCount();
    }

    @Override
    public long getStatCount() {
        return this.totalCount.longValue();
    }

    @Override
    public void reset() {
        this.totalCount.set(0);
        this.bizExCount.set(0);
        this.sysExCount.set(0);
        this.succTotalTime.set(0L);
        this.bizExTotalTime.set(0L);
        this.sysExTotalTime.set(0L);
        this.calcInferCount();
    }

    public int getValidCount() {
        this.validCount = this.bizExCount.intValue() + this.succCount.intValue();
        return this.validCount;
    }

    public long getSuccAvgTime() {
        this.succAvgTime = this.succCount.intValue() > 0 ? this.succTotalTime.intValue() / this.succCount.intValue() : 0;
        return this.succAvgTime;
    }

    public double getFailRate() {
        this.failRate = this.totalCount.intValue() > 0 ? (this.bizExCount.intValue() + this.sysExCount.intValue()) / this.totalCount.intValue() : 0;
        return this.failRate;
    }

    public double getSysExRate() {
        this.sysExRate = this.totalCount.intValue() > 0 ? this.sysExCount.intValue() / this.totalCount.intValue() : 0;
        return this.sysExRate;
    }

    public double getBizExRate() {
        this.bizExRate = this.totalCount.intValue() > 0 ? this.bizExCount.intValue() / this.totalCount.intValue() : 0;
        return this.bizExRate;
    }

    public int getFailCount() {
        this.failCount = this.bizExCount.intValue() + this.sysExCount.intValue();
        return this.failCount;
    }

    public void setFailCount(int failCount) {
        this.failCount = failCount;
    }

    public AtomicInteger getSuccCount() {
        return this.succCount;
    }

    public void setSuccCount(AtomicInteger succCount) {
        this.succCount = succCount;
    }

    public AtomicInteger getBizExCount() {
        return this.bizExCount;
    }

    public void setBizExCount(AtomicInteger bizExCount) {
        this.bizExCount = bizExCount;
    }

    public AtomicInteger getSysExCount() {
        return this.sysExCount;
    }

    public void setSysExCount(AtomicInteger sysExCount) {
        this.sysExCount = sysExCount;
    }

    public AtomicLong getSuccTotalTime() {
        return this.succTotalTime;
    }

    public void setSuccTotalTime(AtomicLong succTotalTime) {
        this.succTotalTime = succTotalTime;
    }

    public AtomicLong getBizExTotalTime() {
        return this.bizExTotalTime;
    }

    public void setBizExTotalTime(AtomicLong bizExTotalTime) {
        this.bizExTotalTime = bizExTotalTime;
    }

    public AtomicLong getSysExTotalTime() {
        return this.sysExTotalTime;
    }

    public void setSysExTotalTime(AtomicLong sysExTotalTime) {
        this.sysExTotalTime = sysExTotalTime;
    }

    public void setValidCount(int validCount) {
        this.validCount = validCount;
    }

    public void setFailRate(double failRate) {
        this.failRate = failRate;
    }

    public void setBizExRate(double bizExRate) {
        this.bizExRate = bizExRate;
    }

    public void setSysExRate(double sysExRate) {
        this.sysExRate = sysExRate;
    }

    public AtomicInteger getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(AtomicInteger totalCount) {
        this.totalCount = totalCount;
    }

    public AtomicLong getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(AtomicLong totalTime) {
        this.totalTime = totalTime;
    }

    public void setSuccAvgTime(long succAvgTime) {
        this.succAvgTime = succAvgTime;
    }
}

