/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.monitor.dao.AmmMAlarmMapper;
import com.yqbsoft.laser.service.monitor.domain.AmmMAlarmDomain;
import com.yqbsoft.laser.service.monitor.model.AmmMAlarm;
import com.yqbsoft.laser.service.monitor.service.AmmMAlarmService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AmmMAlarmServiceImpl
extends BaseServiceImpl
implements AmmMAlarmService {
    public static final String SYS_CODE = "amm.MConstants.AmmMAlarmServiceImpl";
    private AmmMAlarmMapper ammMAlarmMapper;

    public void setAmmMAlarmMapper(AmmMAlarmMapper ammMAlarmMapper) {
        this.ammMAlarmMapper = ammMAlarmMapper;
    }

    private Date getSysDate() {
        try {
            return this.ammMAlarmMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMAlarmServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMAlarm(AmmMAlarmDomain ammMAlarmDomain) {
        if (ammMAlarmDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setMAlarmDefault(AmmMAlarm ammMAlarm) {
        if (ammMAlarm == null) {
            return;
        }
        if (ammMAlarm.getDataState() == null) {
            ammMAlarm.setDataState(0);
        }
        if (ammMAlarm.getGmtCreate() == null) {
            ammMAlarm.setGmtCreate(this.getSysDate());
        }
        ammMAlarm.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.ammMAlarmMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMAlarmServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMAlarmUpdataDefault(AmmMAlarm ammMAlarm) {
        if (ammMAlarm == null) {
            return;
        }
        ammMAlarm.setGmtModified(this.getSysDate());
    }

    private void saveMAlarmModel(AmmMAlarm ammMAlarm) throws ApiException {
        if (ammMAlarm == null) {
            return;
        }
        try {
            this.ammMAlarmMapper.insert(ammMAlarm);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMAlarmServiceImpl.saveMAlarmModel.ex", (Throwable)e);
        }
    }

    private AmmMAlarm getMAlarmModelById(Integer alarmId) {
        if (alarmId == null) {
            return null;
        }
        try {
            return this.ammMAlarmMapper.selectByPrimaryKey(alarmId);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMAlarmServiceImpl.getMAlarmModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteMAlarmModel(Integer alarmId) throws ApiException {
        if (alarmId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.ammMAlarmMapper.deleteByPrimaryKey(alarmId);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMAlarmServiceImpl.deleteMAlarmModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("amm.MConstants.AmmMAlarmServiceImpl.deleteMAlarmModel.num");
        }
    }

    private void updateMAlarmModel(AmmMAlarm ammMAlarm) throws ApiException {
        if (ammMAlarm == null) {
            return;
        }
        try {
            this.ammMAlarmMapper.updateByPrimaryKeySelective(ammMAlarm);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMAlarmServiceImpl.updateMAlarmModel.ex", (Throwable)e);
        }
    }

    private void updateStateMAlarmModel(Integer alarmId, Integer dataState, Integer oldDataState) throws ApiException {
        if (alarmId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alarmId", alarmId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ammMAlarmMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMAlarmServiceImpl.updateStateMAlarmModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("amm.MConstants.AmmMAlarmServiceImpl.updateStateMAlarmModel.null");
        }
    }

    private AmmMAlarm makeMAlarm(AmmMAlarmDomain ammMAlarmDomain, AmmMAlarm ammMAlarm) {
        if (ammMAlarmDomain == null) {
            return null;
        }
        if (ammMAlarm == null) {
            ammMAlarm = new AmmMAlarm();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ammMAlarm, (Object)ammMAlarmDomain);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMAlarmServiceImpl.makeMAlarm", (Throwable)e);
        }
        return ammMAlarm;
    }

    private List<AmmMAlarm> queryMAlarmModelPage(Map<String, Object> parammap) {
        try {
            return this.ammMAlarmMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMAlarmServiceImpl.queryMAlarmModel", (Throwable)e);
            return null;
        }
    }

    private int countMAlarm(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ammMAlarmMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMAlarmServiceImpl.countMAlarm", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveMAlarm(AmmMAlarmDomain ammMAlarmDomain) throws ApiException {
        String msg = this.checkMAlarm(ammMAlarmDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("amm.MConstants.AmmMAlarmServiceImpl.saveMAlarm.checkMAlarm", msg);
        }
        AmmMAlarm ammMAlarm = this.makeMAlarm(ammMAlarmDomain, null);
        this.setMAlarmDefault(ammMAlarm);
        this.saveMAlarmModel(ammMAlarm);
    }

    @Override
    public void updateMAlarmState(Integer alarmId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMAlarmModel(alarmId, dataState, oldDataState);
    }

    @Override
    public void updateMAlarm(AmmMAlarmDomain ammMAlarmDomain) throws ApiException {
        String msg = this.checkMAlarm(ammMAlarmDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("amm.MConstants.AmmMAlarmServiceImpl.updateMAlarm.checkMAlarm", msg);
        }
        AmmMAlarm oldAmmMAlarm = this.getMAlarmModelById(ammMAlarmDomain.getAlarmId());
        if (oldAmmMAlarm == null) {
            throw new ApiException("amm.MConstants.AmmMAlarmServiceImpl.updateMAlarm.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmmMAlarm ammMAlarm = this.makeMAlarm(ammMAlarmDomain, oldAmmMAlarm);
        this.setMAlarmUpdataDefault(ammMAlarm);
        this.updateMAlarmModel(ammMAlarm);
    }

    @Override
    public AmmMAlarm getMAlarm(Integer alarmId) {
        return this.getMAlarmModelById(alarmId);
    }

    @Override
    public void deleteMAlarm(Integer alarmId) throws ApiException {
        this.deleteMAlarmModel(alarmId);
    }

    @Override
    public QueryResult<AmmMAlarm> queryMAlarmPage(Map<String, Object> map) {
        List<AmmMAlarm> ammMAlarmList = this.queryMAlarmModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMAlarm(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ammMAlarmList);
        return queryResult;
    }
}

