/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.monitor.dao.AmmMPointMapper;
import com.yqbsoft.laser.service.monitor.domain.AmmMPointDomain;
import com.yqbsoft.laser.service.monitor.model.AmmMPoint;
import com.yqbsoft.laser.service.monitor.service.AmmMPointService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AmmMPointServiceImpl
extends BaseServiceImpl
implements AmmMPointService {
    public static final String SYS_CODE = "amm.MConstants.AmmMPointServiceImpl";
    private AmmMPointMapper ammMPointMapper;

    public void setAmmMPointMapper(AmmMPointMapper ammMPointMapper) {
        this.ammMPointMapper = ammMPointMapper;
    }

    private Date getSysDate() {
        try {
            return this.ammMPointMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMPointServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMPoint(AmmMPointDomain ammMPointDomain) {
        if (ammMPointDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setMPointDefault(AmmMPoint ammMPoint) {
        if (ammMPoint == null) {
            return;
        }
        if (ammMPoint.getDataState() == null) {
            ammMPoint.setDataState(0);
        }
        if (ammMPoint.getGmtCreate() == null) {
            ammMPoint.setGmtCreate(this.getSysDate());
        }
        ammMPoint.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.ammMPointMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMPointServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMPointUpdataDefault(AmmMPoint ammMPoint) {
        if (ammMPoint == null) {
            return;
        }
        ammMPoint.setGmtModified(this.getSysDate());
    }

    private void saveMPointModel(AmmMPoint ammMPoint) throws ApiException {
        if (ammMPoint == null) {
            return;
        }
        try {
            this.ammMPointMapper.insert(ammMPoint);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMPointServiceImpl.saveMPointModel.ex", (Throwable)e);
        }
    }

    private AmmMPoint getMPointModelById(Integer pointId) {
        if (pointId == null) {
            return null;
        }
        try {
            return this.ammMPointMapper.selectByPrimaryKey(pointId);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMPointServiceImpl.getMPointModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteMPointModel(Integer pointId) throws ApiException {
        if (pointId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.ammMPointMapper.deleteByPrimaryKey(pointId);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMPointServiceImpl.deleteMPointModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("amm.MConstants.AmmMPointServiceImpl.deleteMPointModel.num");
        }
    }

    private void updateMPointModel(AmmMPoint ammMPoint) throws ApiException {
        if (ammMPoint == null) {
            return;
        }
        try {
            this.ammMPointMapper.updateByPrimaryKeySelective(ammMPoint);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMPointServiceImpl.updateMPointModel.ex", (Throwable)e);
        }
    }

    private void updateStateMPointModel(Integer pointId, Integer dataState, Integer oldDataState) throws ApiException {
        if (pointId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointId", pointId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ammMPointMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMPointServiceImpl.updateStateMPointModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("amm.MConstants.AmmMPointServiceImpl.updateStateMPointModel.null");
        }
    }

    private AmmMPoint makeMPoint(AmmMPointDomain ammMPointDomain, AmmMPoint ammMPoint) {
        if (ammMPointDomain == null) {
            return null;
        }
        if (ammMPoint == null) {
            ammMPoint = new AmmMPoint();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ammMPoint, (Object)ammMPointDomain);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMPointServiceImpl.makeMPoint", (Throwable)e);
        }
        return ammMPoint;
    }

    private List<AmmMPoint> queryMPointModelPage(Map<String, Object> parammap) {
        try {
            return this.ammMPointMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMPointServiceImpl.queryMPointModel", (Throwable)e);
            return null;
        }
    }

    private int countMPoint(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ammMPointMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMPointServiceImpl.countMPoint", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveMPoint(AmmMPointDomain ammMPointDomain) throws ApiException {
        String msg = this.checkMPoint(ammMPointDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("amm.MConstants.AmmMPointServiceImpl.saveMPoint.checkMPoint", msg);
        }
        AmmMPoint ammMPoint = this.makeMPoint(ammMPointDomain, null);
        this.setMPointDefault(ammMPoint);
        this.saveMPointModel(ammMPoint);
    }

    @Override
    public void updateMPointState(Integer pointId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMPointModel(pointId, dataState, oldDataState);
    }

    @Override
    public void updateMPoint(AmmMPointDomain ammMPointDomain) throws ApiException {
        String msg = this.checkMPoint(ammMPointDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("amm.MConstants.AmmMPointServiceImpl.updateMPoint.checkMPoint", msg);
        }
        AmmMPoint oldAmmMPoint = this.getMPointModelById(ammMPointDomain.getPointId());
        if (oldAmmMPoint == null) {
            throw new ApiException("amm.MConstants.AmmMPointServiceImpl.updateMPoint.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmmMPoint ammMPoint = this.makeMPoint(ammMPointDomain, oldAmmMPoint);
        this.setMPointUpdataDefault(ammMPoint);
        this.updateMPointModel(ammMPoint);
    }

    @Override
    public AmmMPoint getMPoint(Integer pointId) {
        return this.getMPointModelById(pointId);
    }

    @Override
    public void deleteMPoint(Integer pointId) throws ApiException {
        this.deleteMPointModel(pointId);
    }

    @Override
    public QueryResult<AmmMPoint> queryMPointPage(Map<String, Object> map) {
        List<AmmMPoint> ammMPointList = this.queryMPointModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMPoint(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ammMPointList);
        return queryResult;
    }
}

