/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.monitor.dao.AmmMStatOutMapper;
import com.yqbsoft.laser.service.monitor.domain.AmmMStatOutDomain;
import com.yqbsoft.laser.service.monitor.model.AmmMStatOut;
import com.yqbsoft.laser.service.monitor.service.AmmMStatOutService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AmmMStatOutServiceImpl
extends BaseServiceImpl
implements AmmMStatOutService {
    public static final String SYS_CODE = "amm.MConstants.AmmMStatOutServiceImpl";
    private AmmMStatOutMapper ammMStatOutMapper;

    public void setAmmMStatOutMapper(AmmMStatOutMapper ammMStatOutMapper) {
        this.ammMStatOutMapper = ammMStatOutMapper;
    }

    private Date getSysDate() {
        try {
            return this.ammMStatOutMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMStatOutServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMStatOut(AmmMStatOutDomain ammMStatOutDomain) {
        if (ammMStatOutDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setMStatOutDefault(AmmMStatOut ammMStatOut) {
        if (ammMStatOut == null) {
            return;
        }
        if (ammMStatOut.getDataState() == null) {
            ammMStatOut.setDataState(0);
        }
        if (ammMStatOut.getGmtCreate() == null) {
            ammMStatOut.setGmtCreate(this.getSysDate());
        }
        ammMStatOut.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.ammMStatOutMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMStatOutServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMStatOutUpdataDefault(AmmMStatOut ammMStatOut) {
        if (ammMStatOut == null) {
            return;
        }
        ammMStatOut.setGmtModified(this.getSysDate());
    }

    private void saveMStatOutModel(AmmMStatOut ammMStatOut) throws ApiException {
        if (ammMStatOut == null) {
            return;
        }
        try {
            this.ammMStatOutMapper.insert(ammMStatOut);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMStatOutServiceImpl.saveMStatOutModel.ex", (Throwable)e);
        }
    }

    private AmmMStatOut getMStatOutModelById(Integer statOutId) {
        if (statOutId == null) {
            return null;
        }
        try {
            return this.ammMStatOutMapper.selectByPrimaryKey(statOutId);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMStatOutServiceImpl.getMStatOutModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteMStatOutModel(Integer statOutId) throws ApiException {
        if (statOutId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.ammMStatOutMapper.deleteByPrimaryKey(statOutId);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMStatOutServiceImpl.deleteMStatOutModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("amm.MConstants.AmmMStatOutServiceImpl.deleteMStatOutModel.num");
        }
    }

    private void updateMStatOutModel(AmmMStatOut ammMStatOut) throws ApiException {
        if (ammMStatOut == null) {
            return;
        }
        try {
            this.ammMStatOutMapper.updateByPrimaryKeySelective(ammMStatOut);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMStatOutServiceImpl.updateMStatOutModel.ex", (Throwable)e);
        }
    }

    private void updateStateMStatOutModel(Integer statOutId, Integer dataState, Integer oldDataState) throws ApiException {
        if (statOutId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("statOutId", statOutId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ammMStatOutMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMStatOutServiceImpl.updateStateMStatOutModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("amm.MConstants.AmmMStatOutServiceImpl.updateStateMStatOutModel.null");
        }
    }

    private AmmMStatOut makeMStatOut(AmmMStatOutDomain ammMStatOutDomain, AmmMStatOut ammMStatOut) {
        if (ammMStatOutDomain == null) {
            return null;
        }
        if (ammMStatOut == null) {
            ammMStatOut = new AmmMStatOut();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ammMStatOut, (Object)ammMStatOutDomain);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMStatOutServiceImpl.makeMStatOut", (Throwable)e);
        }
        return ammMStatOut;
    }

    private List<AmmMStatOut> queryMStatOutModelPage(Map<String, Object> parammap) {
        try {
            return this.ammMStatOutMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMStatOutServiceImpl.queryMStatOutModel", (Throwable)e);
            return null;
        }
    }

    private int countMStatOut(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ammMStatOutMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMStatOutServiceImpl.countMStatOut", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveMStatOut(AmmMStatOutDomain ammMStatOutDomain) throws ApiException {
        String msg = this.checkMStatOut(ammMStatOutDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("amm.MConstants.AmmMStatOutServiceImpl.saveMStatOut.checkMStatOut", msg);
        }
        AmmMStatOut ammMStatOut = this.makeMStatOut(ammMStatOutDomain, null);
        this.setMStatOutDefault(ammMStatOut);
        this.saveMStatOutModel(ammMStatOut);
    }

    @Override
    public void updateMStatOutState(Integer statOutId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMStatOutModel(statOutId, dataState, oldDataState);
    }

    @Override
    public void updateMStatOut(AmmMStatOutDomain ammMStatOutDomain) throws ApiException {
        String msg = this.checkMStatOut(ammMStatOutDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("amm.MConstants.AmmMStatOutServiceImpl.updateMStatOut.checkMStatOut", msg);
        }
        AmmMStatOut oldAmmMStatOut = this.getMStatOutModelById(ammMStatOutDomain.getStatOutId());
        if (oldAmmMStatOut == null) {
            throw new ApiException("amm.MConstants.AmmMStatOutServiceImpl.updateMStatOut.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmmMStatOut ammMStatOut = this.makeMStatOut(ammMStatOutDomain, oldAmmMStatOut);
        this.setMStatOutUpdataDefault(ammMStatOut);
        this.updateMStatOutModel(ammMStatOut);
    }

    @Override
    public AmmMStatOut getMStatOut(Integer statOutId) {
        return this.getMStatOutModelById(statOutId);
    }

    @Override
    public void deleteMStatOut(Integer statOutId) throws ApiException {
        this.deleteMStatOutModel(statOutId);
    }

    @Override
    public QueryResult<AmmMStatOut> queryMStatOutPage(Map<String, Object> map) {
        List<AmmMStatOut> ammMStatOutList = this.queryMStatOutModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMStatOut(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ammMStatOutList);
        return queryResult;
    }
}

