/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.service.impl;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.monitor.EvtCtrl;
import com.yqbsoft.laser.service.esb.core.monitor.IvkReject;
import com.yqbsoft.laser.service.esb.core.monitor.MEventUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.monitor.model.AmmMEvtCtrl;
import com.yqbsoft.laser.service.monitor.model.AmmMField;
import com.yqbsoft.laser.service.monitor.model.AmmMIvkReject;
import com.yqbsoft.laser.service.monitor.model.AmmMPoint;
import com.yqbsoft.laser.service.monitor.service.AmmMEvtCtrlService;
import com.yqbsoft.laser.service.monitor.service.AmmMFieldService;
import com.yqbsoft.laser.service.monitor.service.AmmMIvkRejectService;
import com.yqbsoft.laser.service.monitor.service.AmmMPointService;
import com.yqbsoft.laser.service.monitor.service.CacheLoadService;
import com.yqbsoft.laser.service.monitor.support.Field;
import com.yqbsoft.laser.service.monitor.support.Point;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CacheLoadServiceImpl
extends BaseServiceImpl
implements CacheLoadService {
    public static final String SYS_CODE = "amm.MConstants.CacheLoadServiceImpl";
    private AmmMEvtCtrlService ammMEvtCtrlService;
    private AmmMIvkRejectService ammMIvkRejectService;
    private AmmMPointService ammMPointService;
    private AmmMFieldService ammMFieldService;

    public AmmMFieldService getAmmMFieldService() {
        return this.ammMFieldService;
    }

    public void setAmmMFieldService(AmmMFieldService ammMFieldService) {
        this.ammMFieldService = ammMFieldService;
    }

    public AmmMPointService getAmmMPointService() {
        return this.ammMPointService;
    }

    public void setAmmMPointService(AmmMPointService ammMPointService) {
        this.ammMPointService = ammMPointService;
    }

    public AmmMEvtCtrlService getAmmMEvtCtrlService() {
        return this.ammMEvtCtrlService;
    }

    public void setAmmMEvtCtrlService(AmmMEvtCtrlService ammMEvtCtrlService) {
        this.ammMEvtCtrlService = ammMEvtCtrlService;
    }

    public AmmMIvkRejectService getAmmMIvkRejectService() {
        return this.ammMIvkRejectService;
    }

    public void setAmmMIvkRejectService(AmmMIvkRejectService ammMIvkRejectService) {
        this.ammMIvkRejectService = ammMIvkRejectService;
    }

    @Override
    public void loadMonitorCache() throws Exception {
        this.addToEventCtrlMap();
        this.addToIvkRejectMap();
    }

    private void addToIvkRejectMap() throws Exception {
        this.info("amm.MConstants.CacheLoadServiceImpl.addToIvkRejectMap", "=======addToIvkRejectMap\u8c03\u5ea6start=======");
        HashMap<Integer, IvkReject> ivkRejectMap = new HashMap<Integer, IvkReject>();
        HashMap apiFact2IvkRejectIdsMap = new HashMap();
        HashMap fact2IvkRejectIdsMap = null;
        List<AmmMIvkReject> list = this.queryIvkRejectList();
        if (list == null) {
            DisUtil.del((String)"invokeReject");
            DisUtil.del((String)"factInvokeReject");
            this.info("amm.MConstants.CacheLoadServiceImpl.addToIvkRejectMap", "=======addToIvkRejectMap\u8c03\u5ea6end-del=======");
        }
        for (AmmMIvkReject ammMIvkReject : list) {
            fact2IvkRejectIdsMap = new HashMap();
            IvkReject bean = new IvkReject();
            BeanUtils.copyAllPropertys((Object)bean, (Object)ammMIvkReject);
            ivkRejectMap.put(bean.getIvkRejectId(), bean);
            MEventUtil.addPropNameValueEntry((Object)bean, fact2IvkRejectIdsMap);
            apiFact2IvkRejectIdsMap.put(ammMIvkReject.getApiKey(), fact2IvkRejectIdsMap);
        }
        DisUtil.setVer((String)"invokeReject", (String)JsonUtil.buildNormalBinder().toJson(ivkRejectMap));
        DisUtil.setVer((String)"factInvokeReject", (String)JsonUtil.buildNormalBinder().toJson(apiFact2IvkRejectIdsMap));
        this.info("amm.MConstants.CacheLoadServiceImpl.addToIvkRejectMap", "=======addToIvkRejectMap\u8c03\u5ea6end=======");
    }

    private void addToEventCtrlMap() throws Exception {
        this.info("amm.MConstants.CacheLoadServiceImpl.addToEventCtrlMap", "=======addToEventCtrlMap\u8c03\u5ea6start=======");
        try {
            HashMap<Integer, EvtCtrl> eventCtrlMap = new HashMap<Integer, EvtCtrl>();
            HashMap fact2EvtCtrlIdsMap = new HashMap();
            List<AmmMEvtCtrl> list = this.queryEvtCtrlList();
            if (list == null) {
                DisUtil.del((String)"eventCtrl");
                DisUtil.del((String)"factEventCtrl");
                this.info("amm.MConstants.CacheLoadServiceImpl.addToEventCtrlMap", "=======addToEventCtrlMap\u8c03\u5ea6end-del=======");
            }
            for (AmmMEvtCtrl ammMEvtCtrl : list) {
                EvtCtrl bean = new EvtCtrl();
                BeanUtils.copyAllPropertys((Object)bean, (Object)ammMEvtCtrl);
                bean.setEvtCtrlId(ammMEvtCtrl.getEvtctrlId());
                eventCtrlMap.put(bean.getEvtCtrlId(), bean);
                MEventUtil.addPropNameValueEntry((Object)bean, fact2EvtCtrlIdsMap);
            }
            DisUtil.setVer((String)"eventCtrl", (String)JsonUtil.buildNormalBinder().toJson(eventCtrlMap));
            DisUtil.setVer((String)"factEventCtrl", (String)JsonUtil.buildNormalBinder().toJson(fact2EvtCtrlIdsMap));
            this.info("amm.MConstants.CacheLoadServiceImpl.addToEventCtrlMap", "=======addToEventCtrlMap\u8c03\u5ea6end=======");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<AmmMEvtCtrl> queryEvtCtrlList() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataState", 1);
        QueryResult<AmmMEvtCtrl> queryResult = this.ammMEvtCtrlService.queryMEvtCtrlPage(params);
        return queryResult.getList();
    }

    private List<AmmMIvkReject> queryIvkRejectList() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataState", 1);
        QueryResult<AmmMIvkReject> queryResult = this.ammMIvkRejectService.queryMIvkRejectPage(params);
        return queryResult.getList();
    }

    @Override
    public void loadPointCache() throws Exception {
        this.addToApi2PointsMap();
    }

    private void addToApi2PointsMap() throws Exception {
        this.info("amm.MConstants.CacheLoadServiceImpl.addToApi2PointsMap", "=======addToApi2PointsMap\u8c03\u5ea6start=======");
        HashMap<Integer, Point> id2PointMap = new HashMap<Integer, Point>();
        HashMap api2PointsMap = new HashMap();
        List<AmmMPoint> list = this.queryAmmMPointList();
        Map<Integer, List<AmmMField>> fieldMap = this.queryAmmMFieldMap();
        if (list == null) {
            DisUtil.del((String)"ID2POINT");
            DisUtil.del((String)"API2POINT");
            this.info("amm.MConstants.CacheLoadServiceImpl.addToApi2PointsMap", "=======addToApi2PointsMap\u8c03\u5ea6end-del=======");
        }
        for (AmmMPoint ammMPoint : list) {
            String factKey;
            ArrayList<Integer> tmpList;
            Point bean = new Point();
            BeanUtils.copyAllPropertys((Object)bean, (Object)ammMPoint);
            Integer pointId = bean.getPointId();
            if (pointId == null) continue;
            List<AmmMField> children = fieldMap.get(pointId);
            if (children != null) {
                for (AmmMField ammMField : children) {
                    Field field = new Field();
                    BeanUtils.copyAllPropertys((Object)field, (Object)ammMField);
                    bean.addField(field);
                }
            }
            id2PointMap.put(bean.getPointId(), bean);
            String apiKey = String.valueOf(bean.getApiCode()) + "-" + bean.getApiVersion();
            HashMap<String, ArrayList<Integer>> tmpMap = (HashMap<String, ArrayList<Integer>>)api2PointsMap.get(apiKey);
            if (tmpMap == null) {
                tmpMap = new HashMap<String, ArrayList<Integer>>();
            }
            if ((tmpList = (ArrayList<Integer>)tmpMap.get(factKey = String.valueOf(bean.getFactorType()) + "-" + bean.getFactorNo())) == null) {
                tmpList = new ArrayList<Integer>();
            }
            tmpList.add(bean.getPointId());
            tmpMap.put(factKey, tmpList);
            api2PointsMap.put(apiKey, tmpMap);
        }
        DisUtil.setVer((String)"ID2POINT", (String)JsonUtil.buildNormalBinder().toJson(id2PointMap));
        DisUtil.setVer((String)"API2POINT", (String)JsonUtil.buildNormalBinder().toJson(api2PointsMap));
        this.info("amm.MConstants.CacheLoadServiceImpl.addToApi2PointsMap", "=======addToApi2PointsMap\u8c03\u5ea6end=======");
    }

    private Map<Integer, List<AmmMField>> queryAmmMFieldMap() {
        HashMap<Integer, List<AmmMField>> result = new HashMap<Integer, List<AmmMField>>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataState", 1);
        QueryResult<AmmMField> re = this.ammMFieldService.queryMFieldPage(params);
        List list = re.getList();
        for (AmmMField ammMField : list) {
            Integer pointId = ammMField.getPointId();
            if (pointId == null) continue;
            ArrayList<AmmMField> tmp = (ArrayList<AmmMField>)result.get(pointId);
            if (tmp == null) {
                tmp = new ArrayList<AmmMField>();
            }
            tmp.add(ammMField);
            result.put(pointId, tmp);
        }
        return result;
    }

    private List<AmmMPoint> queryAmmMPointList() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataState", 1);
        QueryResult<AmmMPoint> result = this.ammMPointService.queryMPointPage(params);
        List list = result.getList();
        return list;
    }

    @Override
    public void loadCache() throws Exception {
        this.loadMonitorCache();
        this.loadPointCache();
    }
}

