/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.support;

import com.fasterxml.jackson.core.type.TypeReference;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.monitor.support.Point;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PointCache {
    private static final Long SYNC_TIME = 30000L;
    public static final String API_2_POINTS = "API2POINT";
    public static final String ID_2_POINT = "ID2POINT";
    private static Map<String, Map<String, List<Integer>>> api2PointsMap;
    private static Map<Integer, Point> id2PointMap;
    private static Map<String, String> versionMap;
    private static Map<String, Long> timeMap;

    static {
        versionMap = new ConcurrentHashMap<String, String>();
        timeMap = new ConcurrentHashMap<String, Long>();
    }

    public static Map<String, Map<String, List<Integer>>> getApi2PointsMap() {
        if (api2PointsMap == null) {
            PointCache.setApi2PointsMap((Map)DisUtil.getObject((String)API_2_POINTS, (TypeReference)new TypeReference<Map<String, Map<String, List<Integer>>>>(){}));
        } else if (PointCache.exesync(API_2_POINTS) && !PointCache.getVersionMap().get(API_2_POINTS).equals(DisUtil.get((String)"API2POINT-ver"))) {
            PointCache.setApi2PointsMap((Map)DisUtil.getObject((String)API_2_POINTS, (TypeReference)new TypeReference<Map<String, Map<String, List<Integer>>>>(){}));
        }
        return api2PointsMap;
    }

    public static void setApi2PointsMap(Map<String, Map<String, List<Integer>>> api2PointsMap) {
        PointCache.syncVersionNo(API_2_POINTS);
        PointCache.api2PointsMap = api2PointsMap;
    }

    public static Map<Integer, Point> getId2PointMap() {
        if (id2PointMap == null) {
            PointCache.setId2PointMap(DisUtil.getConcMapJson((String)ID_2_POINT, Integer.class, Point.class));
        } else if (PointCache.exesync(ID_2_POINT) && !PointCache.getVersionMap().get(ID_2_POINT).equals(DisUtil.get((String)"ID2POINT-ver"))) {
            PointCache.setId2PointMap(DisUtil.getConcMapJson((String)ID_2_POINT, Integer.class, Point.class));
        }
        return id2PointMap;
    }

    public static void setId2PointMap(Map<Integer, Point> id2PointMap) {
        PointCache.syncVersionNo(ID_2_POINT);
        PointCache.id2PointMap = id2PointMap;
    }

    private static void syncVersionNo(String cacheKey) {
        if (cacheKey == null) {
            return;
        }
        String versionNum = DisUtil.get((String)(String.valueOf(cacheKey) + "-ver"));
        if (versionNum == null) {
            return;
        }
        PointCache.getVersionMap().put(cacheKey, versionNum);
    }

    private static boolean exesync(String key) {
        boolean sync = false;
        Long vtime = PointCache.getTimeMap().get(key);
        Long ctime = System.currentTimeMillis();
        if (vtime == null || ctime - vtime >= SYNC_TIME) {
            PointCache.getTimeMap().put(key, ctime);
            sync = true;
        }
        return sync;
    }

    public static Map<String, String> getVersionMap() {
        return versionMap;
    }

    public static void setVersionMap(Map<String, String> versionMap) {
        PointCache.versionMap = versionMap;
    }

    public static Map<String, Long> getTimeMap() {
        return timeMap;
    }

    public static void setTimeMap(Map<String, Long> timeMap) {
        PointCache.timeMap = timeMap;
    }
}

