/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.auth.OauthRights;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.oauthserver.dao.OsOAuthRightsMapper;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthRightsReDomainBean;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthRights;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthRightsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OsOAuthRightsServiceImpl
extends BaseServiceImpl
implements OsOAuthRightsService {
    public static final String SYS_CODE = "os.OAUTHSERVER.OsOAuthRightsServiceImpl";
    private OsOAuthRightsMapper osOAuthRightsMapper;

    public void setOsOAuthRightsMapper(OsOAuthRightsMapper osOAuthRightsMapper) {
        this.osOAuthRightsMapper = osOAuthRightsMapper;
    }

    private Date getSysDate() {
        try {
            return this.osOAuthRightsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthRightsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOAuthRights(OsOAuthRightsReDomainBean osOAuthRightsReDomainBean) {
        if (null == osOAuthRightsReDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setOAuthRightsDefault(OsOAuthRights osOAuthRights) {
        if (null == osOAuthRights) {
            return;
        }
        if (null == osOAuthRights.getDataState()) {
            osOAuthRights.setDataState(0);
        }
        if (null == osOAuthRights.getGmtCreate()) {
            osOAuthRights.setGmtCreate(this.getSysDate());
        }
        osOAuthRights.setGmtModified(this.getSysDate());
    }

    private void setOAuthRightsUpdataDefault(OsOAuthRights osOAuthRights) {
        if (null == osOAuthRights) {
            return;
        }
        osOAuthRights.setGmtModified(this.getSysDate());
    }

    private Integer saveOAuthRightsModel(OsOAuthRights osOAuthRights) throws ApiException {
        if (null == osOAuthRights) {
            return null;
        }
        try {
            this.osOAuthRightsMapper.insert(osOAuthRights);
            this.refreshCache(osOAuthRights, 1);
            return osOAuthRights.getOauthRightsId();
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthRightsServiceImpl.saveFtpserverModel.ex");
        }
    }

    private OsOAuthRights getOAuthRightsModelById(Integer oauthRightsId) {
        if (null == oauthRightsId) {
            return null;
        }
        try {
            return this.osOAuthRightsMapper.selectByPrimaryKey(oauthRightsId);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthRightsServiceImpl.getOAuthRightsModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteOAuthRightsModel(Integer oauthRightsId) throws ApiException {
        if (null == oauthRightsId) {
            return;
        }
        int i = 0;
        try {
            OsOAuthRights osOAuthRights = this.getOAuthRights(oauthRightsId);
            i = this.osOAuthRightsMapper.deleteByPrimaryKey(oauthRightsId);
            if (i > 0) {
                this.refreshCache(osOAuthRights, 1);
            }
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthRightsServiceImpl.deleteOAuthRightsModel.ex");
        }
        if (1 != i) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthRightsServiceImpl.deleteOAuthRightsModel.num");
        }
    }

    private void updateOAuthRightsModel(OsOAuthRights osOAuthRights) throws ApiException {
        if (null == osOAuthRights) {
            return;
        }
        try {
            this.osOAuthRightsMapper.updateByPrimaryKeySelective(osOAuthRights);
            if (osOAuthRights.getDataState() == 0) {
                this.refreshCache(osOAuthRights, 0);
            }
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthRightsServiceImpl.updateOAuthRightsModel.ex");
        }
    }

    private void updateStateOAuthRightsModel(Integer oauthRightsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == oauthRightsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("oauthRightsId", oauthRightsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.osOAuthRightsMapper.updateStateByPrimaryKey(map);
            if (i > 0 && oldDataState != 0 && dataState == 0) {
                this.refreshCache(this.getOAuthRights(oauthRightsId), 0);
            }
            if (i > 0 && oldDataState == 0 && dataState != 0) {
                this.refreshCache(this.getOAuthRights(oauthRightsId), 1);
            }
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthRightsServiceImpl.updateStateOAuthRightsModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthRightsServiceImpl.updateStateOAuthRightsModel.null");
        }
    }

    private OsOAuthRights makeOAuthRights(OsOAuthRightsReDomainBean osOAuthRightsReDomainBean, OsOAuthRights osOAuthRights) {
        if (null == osOAuthRightsReDomainBean) {
            return null;
        }
        if (null == osOAuthRights) {
            osOAuthRights = new OsOAuthRights();
        }
        try {
            BeanUtils.copyAllPropertys((Object)osOAuthRights, (Object)osOAuthRightsReDomainBean);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthRightsServiceImpl.makeOAuthRights", (Throwable)e);
        }
        return osOAuthRights;
    }

    private List<OsOAuthRights> queryOAuthRightsModelPage(Map<String, Object> parammap) {
        try {
            return this.osOAuthRightsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthRightsServiceImpl.queryOAuthRightsModel", (Throwable)e);
            return null;
        }
    }

    private int countOAuthRights(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.osOAuthRightsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthRightsServiceImpl.countOAuthRights", (Throwable)e);
        }
        return i;
    }

    @Override
    public Integer saveOAuthRights(OsOAuthRightsReDomainBean osOAuthRightsReDomainBean) throws ApiException {
        String msg = this.checkOAuthRights(osOAuthRightsReDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthRightsServiceImpl.saveOAuthRights.checkOAuthRights", msg);
        }
        OsOAuthRights osOAuthRights = this.makeOAuthRights(osOAuthRightsReDomainBean, null);
        this.setOAuthRightsDefault(osOAuthRights);
        return this.saveOAuthRightsModel(osOAuthRights);
    }

    @Override
    public void updateOAuthRightsState(Integer oauthRightsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateOAuthRightsModel(oauthRightsId, dataState, oldDataState);
    }

    @Override
    public void updateOAuthRights(OsOAuthRightsReDomainBean osOAuthRightsReDomainBean) throws ApiException {
        String msg = this.checkOAuthRights(osOAuthRightsReDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthRightsServiceImpl.updateOAuthRights.checkOAuthRights", msg);
        }
        OsOAuthRights oldOsOAuthRights = this.getOAuthRightsModelById(osOAuthRightsReDomainBean.getOauthRightsId());
        if (null == oldOsOAuthRights) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthRightsServiceImpl.updateOAuthRights.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OsOAuthRights osOAuthRights = this.makeOAuthRights(osOAuthRightsReDomainBean, oldOsOAuthRights);
        this.setOAuthRightsUpdataDefault(osOAuthRights);
        this.updateOAuthRightsModel(osOAuthRights);
    }

    @Override
    public OsOAuthRights getOAuthRights(Integer oauthRightsId) {
        return this.getOAuthRightsModelById(oauthRightsId);
    }

    @Override
    public void deleteOAuthRights(Integer oauthRightsId) throws ApiException {
        this.deleteOAuthRightsModel(oauthRightsId);
    }

    @Override
    public QueryResult<OsOAuthRights> queryOAuthRightsPage(Map<String, Object> map) {
        List<OsOAuthRights> osOAuthRightsList = this.queryOAuthRightsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOAuthRights(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(osOAuthRightsList);
        return queryResult;
    }

    @Override
    public List<OsOAuthRights> queryOAuthRightsList(Map<String, Object> map) throws ApiException {
        return this.queryOAuthRightsModelPage(map);
    }

    @Override
    public void queryOauthRightsCache() {
        this.info("os.OAUTHSERVER.OsOAuthRightsServiceImpl.queryOauthRightsCache", "=======queryOauthRightsCache\u8c03\u5ea6start=======");
        List<OsOAuthRights> osRightsList = this.queryOAuthRightsList(this.getQueryParamMap("dataState", new Object[]{1}));
        if (osRightsList == null || osRightsList.isEmpty()) {
            DisUtil.delVer((String)"OsOAuthRights-oauthserver");
            this.info("os.OAUTHSERVER.OsOAuthRightsServiceImpl.queryOauthRightsCache", "=======queryOauthRightsCache\u8c03\u5ea6end-del=======");
            return;
        }
        HashMap<String, List<OauthRights>> smap = new HashMap<String, List<OauthRights>>();
        for (OsOAuthRights osRights : osRightsList) {
            this.saveCache(osRights, smap);
        }
        DisUtil.setVer((String)"OsOAuthRights-oauthserver", (String)JsonUtil.buildNormalBinder().toJson(smap));
        this.info("os.OAUTHSERVER.OsOAuthRightsServiceImpl.queryOauthRightsCache", "=======queryOauthRightsCache\u8c03\u5ea6end=======");
    }

    private OauthRights makeOauthRights(OsOAuthRights osRights) {
        if (null == osRights) {
            return null;
        }
        OauthRights rights = new OauthRights();
        try {
            BeanUtils.copyAllPropertys((Object)rights, (Object)osRights);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthRightsServiceImpl.makeOauthRights", (Throwable)e);
        }
        return rights;
    }

    private void refreshCache(OsOAuthRights osRights, Integer dataState) {
        boolean addflag = dataState == 1;
        HashMap<String, List<OauthRights>> map = DisUtil.getMapByListJson((String)"OsOAuthRights-oauthserver", String.class, OauthRights.class);
        if (map == null) {
            map = new HashMap<String, List<OauthRights>>();
        }
        if (addflag) {
            this.saveCache(osRights, map);
            System.out.println("==========save, map:" + map);
        } else {
            this.deleteCache(osRights, map);
            System.out.println("********delete:, map" + map);
        }
        DisUtil.setVer((String)"OsOAuthRights-oauthserver", (String)JsonUtil.buildNormalBinder().toJson(map));
    }

    private void deleteCache(OsOAuthRights osRights, Map<String, List<OauthRights>> map) {
        if (osRights == null || map == null) {
            return;
        }
        String key = osRights.getOauthTokenId() + "-" + osRights.getOauthRightsForeignId() + "-" + osRights.getOauthRightsType();
        List<OauthRights> list = map.get(key);
        if (list == null || list.isEmpty()) {
            return;
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getOauthRightsId().equals(osRights.getOauthRightsId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.remove(index);
        }
    }

    private void saveCache(OsOAuthRights osRights, Map<String, List<OauthRights>> map) {
        if (osRights == null || map == null) {
            return;
        }
        OauthRights rights = this.makeOauthRights(osRights);
        String key = osRights.getOauthTokenId() + "-" + osRights.getOauthRightsForeignId() + "-" + osRights.getOauthRightsType();
        List<OauthRights> list = map.get(key);
        if (list == null) {
            list = new ArrayList<OauthRights>();
            map.put(key, list);
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getOauthRightsId().equals(osRights.getOauthRightsId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.set(index, rights);
        } else {
            list.add(rights);
        }
    }

    @Override
    public void deleteByTokenId(Integer oAuthTokenId) {
        if (null == oAuthTokenId) {
            return;
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("oauthTokenId", oAuthTokenId);
            List<OsOAuthRights> list = this.queryOAuthRightsModelPage(map);
            if (list != null) {
                for (OsOAuthRights osOAuthRights : list) {
                    this.deleteOAuthRightsModel(osOAuthRights.getOauthRightsId());
                }
            }
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthRightsServiceImpl.deleteOAuthRightsModel.ex");
        }
    }
}

