/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.token.cache;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthConfigListReDomain;
import com.yqbsoft.laser.service.oauthserver.domain.ResponseInfo;
import com.yqbsoft.laser.service.oauthserver.domain.UserSessionBean;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthToken;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthTokenService;
import com.yqbsoft.laser.service.oauthserver.token.cache.OAuthTokenCache;
import com.yqbsoft.laser.service.oauthserver.token.issuer.SaasOAuthTokenProducerImpl;
import com.yqbsoft.laser.service.oauthserver.token.validate.SaasOAuthTokenValidator;
import com.yqbsoft.laser.service.suppercore.router.AppProperty;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OAuthTokenCacheImpl
implements OAuthTokenCache<OsOAuthToken> {
    OpenLogUtil logger = new OpenLogUtil(this.getClass());
    private static OAuthTokenCacheImpl instance = new OAuthTokenCacheImpl();
    private static OsOAuthTokenService oauthTokenService;
    private static final String VFOOAUTHTOKEN_PRO = "OsOauthToken-pro";
    private static final String VFOOAUTHTOKENSWITCH_PRO = "OsOauthTokenSwitch-pro";
    private static final String VFOOAUTHTOKENCSS_PRO = "OsOauthTokenCss-pro";
    private static final String VFOOAUTHTOKENMEMBER_PRO = "OsOauthTokenMember-pro";
    private static final String VFOOAUTHTOKENEXTERNALMERCHANT_PRO = "OsOauthTokenExternalMerchant-pro";
    private static final String SWITCH_STATUS_FAILED = "load_failed";
    private static final String SWITCH_STATUS_LOADING = "loading";
    private static final String SWITCH_STATUS_SUCCESS = "load_success";
    private static final String SYS_CODE = "os.oauthserver.OAuthTokenCacheImpl";
    private static String TokenLogin;

    private OAuthTokenCacheImpl() {
    }

    public static OAuthTokenCacheImpl getInstance() {
        return instance;
    }

    public OsOAuthTokenService getOauthTokenService() {
        return oauthTokenService;
    }

    @Override
    public void initialize() {
        this.clearAll();
        this.setInitFlag(SWITCH_STATUS_LOADING);
        if (oauthTokenService == null) {
            oauthTokenService = (OsOAuthTokenService)ApplicationContextUtil.getService((String)"oauthTokenService");
        }
        if (oauthTokenService == null) {
            this.logger.debug(SYS_CODE, (Object)".initizlize.oauthTokenService.null\u3002afterInit");
            this.setInitFlag(SWITCH_STATUS_FAILED);
            return;
        }
        List<OsOAuthToken> list = null;
        try {
            list = oauthTokenService.queryOAuthTokenList(new HashMap<String, Object>());
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)".initialize.list.queryError", (Throwable)e);
            this.setInitFlag(SWITCH_STATUS_FAILED);
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (ListUtil.isEmpty(list)) {
            this.logger.debug(SYS_CODE, (Object)".initizlize.list.null");
            DisUtil.setMap((String)VFOOAUTHTOKEN_PRO, map);
            this.setInitFlag(SWITCH_STATUS_SUCCESS);
            return;
        }
        for (OsOAuthToken v : list) {
            if (v == null) continue;
            String key = v.getTenantCode() + "_" + v.getOauthTokenAppKey() + "_" + v.getOauthTokenUserAccount();
            String json = JsonUtil.buildNormalBinder().toJson((Object)v);
            map.put(key, json);
        }
        DisUtil.setMap((String)VFOOAUTHTOKEN_PRO, map);
        this.setInitFlag(SWITCH_STATUS_SUCCESS);
    }

    private void clearAll() {
        DisUtil.del((String)VFOOAUTHTOKEN_PRO);
        DisUtil.del((String)VFOOAUTHTOKENSWITCH_PRO);
        DisUtil.del((String)VFOOAUTHTOKENCSS_PRO);
        DisUtil.del((String)VFOOAUTHTOKENMEMBER_PRO);
        DisUtil.del((String)VFOOAUTHTOKENEXTERNALMERCHANT_PRO);
    }

    public AppProperty getAppProperty(String key) {
        List l;
        Map m;
        String json = DisUtil.get((String)"EcoreAppmanage-pro");
        if (StringUtils.isNotBlank((String)json) && MapUtil.isNotEmpty((Map)(m = (Map)JsonUtil.buildNormalBinder().getJsonToMapByList(json, String.class, AppProperty.class))) && ListUtil.isNotEmpty((Collection)(l = (List)m.get(key)))) {
            return (AppProperty)l.get(0);
        }
        return null;
    }

    @Override
    public OsOAuthToken getToken(String key) {
        String json = DisUtil.getMap((String)VFOOAUTHTOKEN_PRO, (String)key);
        if (StringUtils.isEmpty((String)json)) {
            return null;
        }
        OsOAuthToken osOAuthToken = (OsOAuthToken)JsonUtil.buildNormalBinder().getJsonToObject(json, OsOAuthToken.class);
        return osOAuthToken;
    }

    @Override
    public boolean addToken(String key, OsOAuthToken t) {
        if (t == null) {
            return false;
        }
        DisUtil.setMap((String)VFOOAUTHTOKEN_PRO, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)t));
        return true;
    }

    @Override
    public void removeToken(String key) {
        DisUtil.delMap((String)VFOOAUTHTOKEN_PRO, (String[])new String[]{key});
    }

    public Map<String, String> getAllToken() {
        Map map = DisUtil.getMapAll((String)VFOOAUTHTOKEN_PRO);
        return map;
    }

    public String getCss(String key) {
        String json = DisUtil.getMap((String)VFOOAUTHTOKENCSS_PRO, (String)key);
        if (StringUtils.isEmpty((String)json)) {
            return null;
        }
        return json;
    }

    public boolean addCss(String key, String cssUrl) {
        if (StringUtils.isEmpty((String)cssUrl)) {
            this.logger.debug(SYS_CODE, (Object)".addCss.cssurl.null");
            return false;
        }
        DisUtil.setMap((String)VFOOAUTHTOKENCSS_PRO, (String)key, (String)cssUrl);
        return true;
    }

    public void removeCss(String key) {
        DisUtil.delMap((String)VFOOAUTHTOKENCSS_PRO, (String[])new String[]{key});
    }

    public ResponseInfo getMemberInfo(String key) {
        String json = DisUtil.getMap((String)VFOOAUTHTOKENMEMBER_PRO, (String)key);
        if (StringUtils.isEmpty((String)json)) {
            this.logger.debug(SYS_CODE, (Object)".getMemberInfo.json.null");
            return null;
        }
        ResponseInfo responseInfo = (ResponseInfo)JsonUtil.buildNormalBinder().getJsonToObject(json, ResponseInfo.class);
        return responseInfo;
    }

    public boolean addMemberInfo(String key, ResponseInfo t) {
        if (t == null) {
            this.logger.debug(SYS_CODE, (Object)".addMemberInfo.ResponseInfo.null");
            return false;
        }
        DisUtil.setMap((String)VFOOAUTHTOKENMEMBER_PRO, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)t));
        return true;
    }

    public void removeMemberInfo(String key) {
        DisUtil.delMap((String)VFOOAUTHTOKENMEMBER_PRO, (String[])new String[]{key});
    }

    public String getExternalMerchant(String key) {
        String json = DisUtil.getMap((String)VFOOAUTHTOKENEXTERNALMERCHANT_PRO, (String)key);
        if (StringUtils.isEmpty((String)json)) {
            this.logger.debug(SYS_CODE, (Object)".getExternalMerchant.json.null");
            return null;
        }
        return json;
    }

    public boolean addExternalMerchant(String key, String parterId) {
        if (StringUtils.isEmpty((String)parterId)) {
            this.logger.debug(SYS_CODE, (Object)".addExternalMerchant.parterId.null");
            return false;
        }
        DisUtil.setMap((String)VFOOAUTHTOKENEXTERNALMERCHANT_PRO, (String)key, (String)parterId);
        return true;
    }

    public void removeExternalMerchant(String key) {
        DisUtil.delMap((String)VFOOAUTHTOKENEXTERNALMERCHANT_PRO, (String[])new String[]{key});
    }

    public boolean needToInit() {
        String flag = this.getInitFlag();
        if (StringUtils.isEmpty((String)flag)) {
            this.logger.debug(SYS_CODE, (Object)".needToInit.flag.null");
            return true;
        }
        if (flag.equals(SWITCH_STATUS_SUCCESS) || flag.equals(SWITCH_STATUS_LOADING)) {
            return false;
        }
        return flag.equals(SWITCH_STATUS_FAILED);
    }

    public boolean isSuccess() {
        String flag = this.getInitFlag();
        return flag.equals(SWITCH_STATUS_SUCCESS);
    }

    public String getInitFlag() {
        return DisUtil.get((String)VFOOAUTHTOKENSWITCH_PRO);
    }

    public void setInitFlag(String flag) {
        DisUtil.set((String)VFOOAUTHTOKENSWITCH_PRO, (String)flag);
    }

    public String getTokenExit(String userName, String tenantCode, String browType) {
        String key = tenantCode + "_" + browType + "_" + userName;
        String tokenid = DisUtil.getMap((String)TokenLogin, (String)key);
        return tokenid;
    }

    public void ClearTokenExit(String userName, String tenantCode, String browType) {
        String key = tenantCode + "_" + browType + "_" + userName;
        DisUtil.delMap((String)TokenLogin, (String[])new String[]{key});
    }

    public void setTokenExit(String userName, String tenantCode, String browType, String tokenID) {
        String key = tenantCode + "_" + browType + "_" + userName;
        DisUtil.setMap((String)TokenLogin, (String)key, (String)tokenID);
    }

    public UserSessionBean getSessionbyType(UserSessionBean userSesionBean, String tenantCode, String browType, OsOAuthConfigListReDomain osOAuthConfigList) {
        String UserName = userSesionBean.getUserName();
        String tokenid = this.getTokenExit(UserName, tenantCode, browType);
        String accTokenType = osOAuthConfigList.getOauthConfigTokenplo();
        String group = DisUtil.getMap((String)"osconfig_key", (String)userSesionBean.getAppmanageIcode());
        switch (Integer.valueOf(accTokenType)) {
            case 0: {
                this.removeToken(tokenid);
                this.ClearTokenExit(UserName, tenantCode, browType);
                this.delUserSession(tokenid + "-" + group);
                OsOAuthToken osOAuthToken = new SaasOAuthTokenProducerImpl().accessToken(userSesionBean.getAppmanageIcode(), userSesionBean.getUserId().toString(), osOAuthConfigList.getOauthConfigTime().toString(), browType, tenantCode);
                tokenid = osOAuthToken.getOauthTokenToken();
                userSesionBean.setTicketTokenid(tokenid);
                this.addToken(tokenid, osOAuthToken);
                break;
            }
            case 1: {
                userSesionBean = this.getUserSession(tokenid + "-" + group);
                OsOAuthToken osOAuthToken = this.getToken(tokenid);
                if (osOAuthToken == null) {
                    osOAuthToken = new SaasOAuthTokenProducerImpl().accessToken(userSesionBean.getAppmanageIcode(), userSesionBean.getUserId().toString(), osOAuthConfigList.getOauthConfigTime().toString(), browType, tenantCode);
                    tokenid = osOAuthToken.getOauthTokenToken();
                    userSesionBean.setTicketTokenid(tokenid);
                    this.addToken(tokenid, osOAuthToken);
                }
                SaasOAuthTokenValidator saasOAuthTokenValidator = new SaasOAuthTokenValidator();
                saasOAuthTokenValidator.delay(osOAuthToken);
                break;
            }
            default: {
                group = DisUtil.getMap((String)"osconfig_key", (String)userSesionBean.getAppmanageIcode());
                userSesionBean = (UserSessionBean)DisUtil.getObjectJson((String)(tokenid + "-" + group), UserSessionBean.class);
                OsOAuthToken osOAuthToken = this.getToken(tokenid);
                if (osOAuthToken == null) {
                    osOAuthToken = new SaasOAuthTokenProducerImpl().accessToken(userSesionBean.getAppmanageIcode(), userSesionBean.getUserId().toString(), osOAuthConfigList.getOauthConfigTime().toString(), browType, tenantCode);
                    tokenid = osOAuthToken.getOauthTokenToken();
                    userSesionBean.setTicketTokenid(tokenid);
                    this.addToken(tokenid, osOAuthToken);
                }
                SaasOAuthTokenValidator saasOAuthTokenValidator = new SaasOAuthTokenValidator();
                saasOAuthTokenValidator.delay(osOAuthToken);
            }
        }
        return userSesionBean;
    }

    public void setUserSession(String key, UserSessionBean userSession) {
        DisUtil.setMap((String)"UserSession_key", (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)userSession));
    }

    public UserSessionBean getUserSession(String key) {
        String json = DisUtil.getMap((String)"UserSession_key", (String)key);
        return (UserSessionBean)JsonUtil.buildNormalBinder().getJsonToObject(json, UserSessionBean.class);
    }

    public void delUserSession(String key) {
        DisUtil.delMapVer((String)"UserSession_key", (String[])new String[]{key});
    }

    static {
        TokenLogin = "TokenLogin_pk";
    }
}

