/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.token.issuer;

import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthToken;
import com.yqbsoft.laser.service.oauthserver.token.issuer.OAuthIssuerImpl;
import com.yqbsoft.laser.service.oauthserver.token.issuer.OAuthSystemException;
import com.yqbsoft.laser.service.oauthserver.token.issuer.OAuthTokenProducer;
import com.yqbsoft.laser.service.oauthserver.token.issuer.UUIDValueGenerator;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;

public class OpenOAuthTokenProducerImpl
implements OAuthTokenProducer<OsOAuthToken> {
    private OpenLogUtil logger = new OpenLogUtil(this.getClass());
    private String SYSCODE = "com.yqbsoft.laser.service.oauthserver.token.issuer.OAuthTokenProducerImpl";

    @Override
    public OsOAuthToken accessToken(String appKey, String uid, String oauthTokenExpireIn, String browType, String tenantCode) {
        OAuthIssuerImpl issuer = new OAuthIssuerImpl(new UUIDValueGenerator());
        String code = null;
        String token = null;
        String refreshToken = null;
        try {
            code = issuer.authorizationCode().replace("-", "").toUpperCase();
            token = issuer.accessToken().replace("-", "").toUpperCase();
            refreshToken = issuer.refreshToken().replace("-", "");
            OsOAuthToken osOAuthToken = new OsOAuthToken();
            osOAuthToken.setOauthTokenCode(code);
            osOAuthToken.setOauthTokenToken(token);
            osOAuthToken.setOauthTokenRefreshToken(refreshToken);
            osOAuthToken.setOauthTokenAppKey(appKey);
            osOAuthToken.setOauthTokenUserAccount(uid);
            osOAuthToken.setOauthTokenUpdateTime(new Date());
            osOAuthToken.setTenantCode(tenantCode);
            osOAuthToken.setOauthTokenBrowtype(browType);
            if (StringUtils.isNotBlank((String)oauthTokenExpireIn)) {
                osOAuthToken.setOauthTokenExpireIn(Integer.parseInt(oauthTokenExpireIn));
            } else {
                osOAuthToken.setOauthTokenExpireIn(30000);
            }
            osOAuthToken.setOauthTokenState(2);
            osOAuthToken.setOauthTokenRemark("OPEN");
            osOAuthToken.setDataState(1);
            return osOAuthToken;
        }
        catch (OAuthSystemException e) {
            this.logger.error(this.SYSCODE, (Object)".accessToken.error", (Throwable)e);
            return null;
        }
    }
}

