/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.oauthserver.domain.OsMuserDomainBean;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthConfigListDomain;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthConfigListReDomain;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthConfigReDomain;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthTokenReDomainBean;
import com.yqbsoft.laser.service.oauthserver.domain.UserSessionBean;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthConfig;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthToken;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthConfigService;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthLoginService;
import com.yqbsoft.laser.service.oauthserver.token.cache.OAuthTokenCacheImpl;
import com.yqbsoft.laser.service.oauthserver.token.issuer.OAuthIssuerImpl;
import com.yqbsoft.laser.service.oauthserver.token.issuer.OAuthSystemException;
import com.yqbsoft.laser.service.oauthserver.token.issuer.SaasOAuthTokenProducerImpl;
import com.yqbsoft.laser.service.oauthserver.token.issuer.UUIDValueGenerator;
import com.yqbsoft.laser.service.oauthserver.util.CommonUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MD5Util;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OsOAuthLoginServiceImpl
extends BaseServiceImpl
implements OsOAuthLoginService {
    public static final String SYS_CODE = "os.OAUTHSERVER.OsOAuthLoginServiceImpl";
    private OsOAuthConfigService osOAuthConfigService;

    public OsOAuthConfigService getOsOAuthConfigService() {
        return this.osOAuthConfigService;
    }

    public void setOsOAuthConfigService(OsOAuthConfigService osOAuthConfigService) {
        this.osOAuthConfigService = osOAuthConfigService;
    }

    @Override
    public String getLoginPage(String uri, String browType, String clientId, String tenantCode) {
        OsOAuthConfigReDomain osOAuthConfigReDomain = this.osOAuthConfigService.getOAuthConfigAll(tenantCode, clientId);
        if (null == osOAuthConfigReDomain) {
            return "\u975e\u6cd5\u5ba2\u6237\u7aef";
        }
        String url = CommonUtil.getRes().getString("com.loginSub.url");
        String red_url = CommonUtil.getRes().getString("com.authAuthorizePage.url");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<!DOCTYPE HTML>");
        buffer.append("<HTML lang=\"en\">");
        buffer.append("<HEAD>");
        buffer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        buffer.append("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">");
        buffer.append("<title>OPEN\u6388\u6743\u5b89\u5168\u767b\u5f55</title>");
        buffer.append("<style type=\"text/css\">");
        buffer.append("table {border: 0;width: 100%;}tr {border: 1px solid #333;}td {height: 30px;}.center-box {width: 400px;margin: 50px auto;overflow: hidden;}.buttongroup {text-align: center;}.buttongroup input {margin: 10px 20px;}");
        buffer.append("</style>");
        buffer.append("</HEAD>");
        buffer.append("<BODY>");
        buffer.append("<div class=\"center-box\">");
        buffer.append("<form id = \"f1\" method=\"post\">");
        buffer.append("<table>");
        buffer.append("<tr><td>Username:</td>");
        buffer.append("<td><input type=\"text\" id=\"userName\" name=\"userName\"> *</td>");
        buffer.append("<input id=\"loginNum\" type=\"hidden\" value=\"\">");
        buffer.append("</tr><tr><td>Passowrd:</td><td><input type=\"password\" id=\"userPasswd\" name=\"userPasswd\"> *</td></tr>");
        buffer.append("<tr><td colspan=\"2\" class=\"buttongroup\">");
        buffer.append("<input type=\"button\" onclick=\"onLogin()\" value=\"\u63d0\u4ea4\" name=\"Login\"> <input type=\"reset\" name=\"Reset\">");
        buffer.append("</td></tr>");
        buffer.append("</table></form></div></BODY></HTML>");
        buffer.append("<script type=\"text/javascript\">");
        buffer.append("var userName,userPasswd,xmlHttpRequest;function createXmlHttpRequest(){if(window.ActiveXObject){return new ActiveXObject(\"Microsoft.XMLHTTP\");}else if(window.XMLHttpRequest){return new XMLHttpRequest();}}function onLogin(){userName = document.getElementById('userName').value;userPasswd = document.getElementById('userPasswd').value;");
        buffer.append("var url = \"" + url + "\";");
        buffer.append("xmlHttpRequest = createXmlHttpRequest();xmlHttpRequest.onreadystatechange = zswFun;xmlHttpRequest.open(\"POST\",url,true);xmlHttpRequest.send(null);}function zswFun(){if(xmlHttpRequest.readyState == 4 && xmlHttpRequest.status == 200){var b = xmlHttpRequest.responseText;var re = eval('('+b+')');var ret = re.os.oauthserver_validateLogin_response.result;var resultArray = ret.split(\":\");if(resultArray.length>0&&resultArray[0] == \"success\"){");
        buffer.append("window.location.href=\"" + red_url + "&code=\"+resultArray[1]+\"&uri=\"+'" + uri + "'+'&clientId='+'" + clientId + "';");
        buffer.append("}else{alert(\"\u767b\u5f55\u5931\u8d25\uff01\");}}}");
        buffer.append("</script>");
        return buffer.toString();
    }

    @Override
    public Map<String, Object> validateLogin(String userName, String userPasswd, String browType, String appmanageIcode, String tenantCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String msg = this.checkparam(userName, userPasswd, browType, appmanageIcode, tenantCode);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.debug(SYS_CODE, (Object)".validateLogin.null,\u53c2\u6570\u4e3a\u7a7a\uff01");
            result.put("flag", false);
            result.put("message", msg);
            return result;
        }
        String json = DisUtil.getMap((String)"OsOAuthConfig_Key", (String)(tenantCode + "-" + appmanageIcode));
        OsOAuthConfigReDomain osOAuthConfigReDomain = (OsOAuthConfigReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OsOAuthConfigReDomain.class);
        if (null == osOAuthConfigReDomain) {
            this.logger.debug(SYS_CODE, (Object)".validateLogin.\u672a\u627e\u5230\u914d\u7f6e\uff01");
            result.put("flag", false);
            result.put("message", "\u672a\u627e\u5230\u914d\u7f6e");
            return result;
        }
        String apiCode = osOAuthConfigReDomain.getOauthConfigLoginurl();
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        params.put("userName", userName);
        params.put("password", userPasswd);
        params.put("appmanageIcode", appmanageIcode);
        String user = this.internalInvoke(apiCode, params);
        Map userresult = (Map)JsonUtil.buildNonNullBinder().getJsonToObject(user, Map.class);
        if (!((Boolean)userresult.get("flag")).booleanValue()) {
            result.put("flag", false);
            result.put("message", userresult.get("message"));
            return result;
        }
        UserSessionBean userSession = (UserSessionBean)JsonUtil.buildNormalBinder().getJsonToObject(userresult.get("message").toString(), UserSessionBean.class);
        userSession.setAppmanageIcode(appmanageIcode);
        String tokenid = OAuthTokenCacheImpl.getInstance().getTokenExit(userSession.getUserName(), tenantCode, browType);
        UserSessionBean olduserSesionBean = OAuthTokenCacheImpl.getInstance().getUserSession(tokenid + "-" + osOAuthConfigReDomain.getAppmanageGroup());
        List<OsOAuthConfigListReDomain> list_config = osOAuthConfigReDomain.getOsOAuthConfigListReDomainList();
        OsOAuthConfigListDomain oslist = null;
        if (list_config != null && list_config.size() > 0) {
            for (OsOAuthConfigListReDomain os : list_config) {
                if (!os.getOauthConfigTokenbr().equals(browType)) continue;
                oslist = os;
                break;
            }
        }
        if (StringUtils.isNotBlank((String)tokenid) && olduserSesionBean != null) {
            if (oslist != null) {
                userSession = OAuthTokenCacheImpl.getInstance().getSessionbyType(userSession, tenantCode, browType, (OsOAuthConfigListReDomain)oslist);
            } else {
                OsOAuthToken osOAuthToken = new SaasOAuthTokenProducerImpl().accessToken(appmanageIcode, userSession.getUserId().toString(), osOAuthConfigReDomain.getOauthConfigTime().toString(), browType, tenantCode);
                tokenid = osOAuthToken.getOauthTokenToken().toString();
                OAuthTokenCacheImpl.getInstance().addToken(tokenid, osOAuthToken);
                userSession.setTicketTokenid(tokenid);
            }
        } else {
            String time = osOAuthConfigReDomain.getOauthConfigTime().toString();
            if (oslist != null) {
                time = oslist.getOauthConfigTime().toString();
            }
            OsOAuthToken osOAuthToken = new SaasOAuthTokenProducerImpl().accessToken(appmanageIcode, userSession.getUserId().toString(), time, browType, tenantCode);
            tokenid = osOAuthToken.getOauthTokenToken().toString();
            OAuthTokenCacheImpl.getInstance().addToken(tokenid, osOAuthToken);
            userSession.setTicketTokenid(tokenid);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appmanageGroup", osOAuthConfigReDomain.getAppmanageGroup());
        map.put("tenantCode", tenantCode);
        QueryResult<OsOAuthConfig> queryResult = this.osOAuthConfigService.queryOAuthConfigPage(map);
        List list = queryResult.getList();
        Map<String, String> mapRole = new HashMap<String, String>();
        for (OsOAuthConfig osoa : list) {
            apiCode = osoa.getAppmanageAppkeyMp();
            params.clear();
            params.put("appmanageIcode", appmanageIcode);
            params.put("roleCode", userSession.getRoleCode());
            params.put("userCode", StringUtils.isBlank((String)userSession.getUserCode()) ? "" : userSession.getUserCode());
            String rolemrp = this.internalInvoke(apiCode, params);
            if (mapRole.isEmpty()) {
                mapRole = (Map)JsonUtil.buildNonNullBinder().getJsonToObject(rolemrp, Map.class);
                continue;
            }
            mapRole.putAll((Map)JsonUtil.buildNonNullBinder().getJsonToObject(rolemrp, Map.class));
        }
        userSession.setMap(mapRole);
        OAuthTokenCacheImpl.getInstance().setUserSession(userSession.getTicketTokenid() + "-" + osOAuthConfigReDomain.getAppmanageGroup(), userSession);
        OAuthTokenCacheImpl.getInstance().setTokenExit(userSession.getUserName(), tenantCode, browType, userSession.getTicketTokenid());
        result.put("flag", true);
        result.put("session", JsonUtil.getAllJsonUtil().toJson((Object)userSession));
        return result;
    }

    @Override
    public String validateOpenLogin(String userName, String userPasswd, String browType, String clientId, String tenantCode) {
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        String apiCode = CommonUtil.getRes().getString("com.loginValid.open.apicode");
        String appmanageIcode = CommonUtil.getRes().getString("com.loginValid.open.appmanageIcode");
        HashMap<String, String> mapuser = new HashMap<String, String>();
        mapuser.put("userName", userName);
        mapuser.put("appmanageIcode", appmanageIcode);
        params.put("map", JsonUtil.buildNormalBinder().toJson(mapuser));
        String user_json = this.internalInvoke(apiCode, params);
        OsMuserDomainBean user = (OsMuserDomainBean)JsonUtil.buildNonNullBinder().getJsonToObject(user_json, OsMuserDomainBean.class);
        String retStr = "";
        if (!"".equals(user) && user != null) {
            if (!MD5Util.MD5((String)userPasswd).equals(user.getUserPwsswd())) {
                retStr = "error:0";
            } else {
                OAuthIssuerImpl issuer = new OAuthIssuerImpl(new UUIDValueGenerator());
                try {
                    String code = issuer.authorizationCode().replace("-", "").toUpperCase();
                    String token = issuer.accessToken().replace("-", "").toUpperCase();
                    String refreshToken = issuer.refreshToken().replace("-", "");
                    this.saveDb(code, token, refreshToken, apiCode, userName, clientId, tenantCode);
                    retStr = "success:" + code;
                }
                catch (OAuthSystemException e) {
                    this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.validateOpenLogin", (Object)"e", (Throwable)e);
                }
            }
        } else {
            retStr = "error:0";
        }
        return retStr;
    }

    private void saveDb(String code, String token, String refreshToken, String apiCode, String userName, String clientId, String tenantCode) {
        OsOAuthTokenReDomainBean osOAuthTokenReDomainBean = new OsOAuthTokenReDomainBean();
        try {
            osOAuthTokenReDomainBean.setTenantCode(tenantCode);
            osOAuthTokenReDomainBean.setOauthTokenAppKey(clientId);
            osOAuthTokenReDomainBean.setOauthTokenCode(code);
            osOAuthTokenReDomainBean.setOauthTokenToken(token);
            osOAuthTokenReDomainBean.setOauthTokenRefreshToken(refreshToken);
            osOAuthTokenReDomainBean.setOauthTokenUserAccount(userName);
            osOAuthTokenReDomainBean.setOauthTokenUpdateTime(new Date());
            osOAuthTokenReDomainBean.setOauthTokenExpireIn(30000);
            osOAuthTokenReDomainBean.setOauthTokenState(1);
            osOAuthTokenReDomainBean.setOauthTokenRemark("code state");
            osOAuthTokenReDomainBean.setDataState(1);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.saveDb.make", (Object)"e", (Throwable)e);
        }
        if (osOAuthTokenReDomainBean != null) {
            ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
            String saveApiCode = "os.oauthserver.saveOAuthToken";
            params.put("osOAuthTokenReDomainBean", JsonUtil.buildNormalBinder().toJson((Object)osOAuthTokenReDomainBean));
            try {
                this.internalInvoke(saveApiCode, params);
            }
            catch (Exception e) {
                this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.saveDb.save", (Object)"e", (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, Object> LoginOut(String oauthTokenToken, String browType, String appmanageIcode, String tenantCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)oauthTokenToken)) {
            this.logger.debug(SYS_CODE, (Object)".LoginOut.\u53c2\u6570\u4e3a\u7a7a\uff01");
            result.put("flag", false);
            return result;
        }
        if (StringUtils.isEmpty((String)browType)) {
            this.logger.debug(SYS_CODE, (Object)".LoginOut.\u53c2\u6570\u4e3a\u7a7a\uff01");
            result.put("flag", false);
            return result;
        }
        if (StringUtils.isEmpty((String)appmanageIcode)) {
            this.logger.debug(SYS_CODE, (Object)".LoginOut.\u53c2\u6570\u4e3a\u7a7a\uff01");
            result.put("flag", false);
            return result;
        }
        if (StringUtils.isEmpty((String)tenantCode)) {
            this.logger.debug(SYS_CODE, (Object)".LoginOut.\u53c2\u6570\u4e3a\u7a7a\uff01");
            result.put("flag", false);
            return result;
        }
        String appmanageGroup = DisUtil.getMap((String)"osconfig_key", (String)appmanageIcode);
        OsOAuthToken osOAuthToken = OAuthTokenCacheImpl.getInstance().getToken(oauthTokenToken);
        UserSessionBean userSessionBean = OAuthTokenCacheImpl.getInstance().getUserSession(oauthTokenToken + "-" + appmanageGroup);
        if (!"".equals(osOAuthToken) && osOAuthToken != null) {
            OAuthTokenCacheImpl.getInstance().removeToken(oauthTokenToken);
        }
        if (!"".equals(userSessionBean) && userSessionBean != null) {
            DisUtil.del((String)(oauthTokenToken + "-" + appmanageGroup));
            String tokenid = OAuthTokenCacheImpl.getInstance().getTokenExit(userSessionBean.getUserName(), tenantCode, browType);
            if (StringUtils.isNotBlank((String)tokenid)) {
                OAuthTokenCacheImpl.getInstance().ClearTokenExit(userSessionBean.getUserName(), tenantCode, browType);
            }
        }
        result.put("flag", true);
        return result;
    }

    private String checkparam(String userName, String userPasswd, String browType, String appmanageIcode, String tenantCode) {
        String result = "";
        if (StringUtils.isEmpty((String)userName)) {
            this.logger.debug(SYS_CODE, (Object)".validateLogin.\u53c2\u6570\u4e3a\u7a7a\uff01");
            result = "userName\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((String)appmanageIcode)) {
            result = result + ",appmanageIcode\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((String)tenantCode)) {
            result = result + ",tenantCode\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((String)tenantCode)) {
            result = result + ",browType\u4e3a\u7a7a";
        }
        return result;
    }

    @Override
    public void reLoadUserSession(String oauthTokenToken, String key, String value, String appmanageIcode) {
        if (StringUtils.isBlank((String)oauthTokenToken) || StringUtils.isBlank((String)key) || StringUtils.isBlank((String)appmanageIcode)) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthLoginServiceImpl.reLoadUserSession.null", "\u53c2\u6570\u4e3a\u7a7a!");
        }
        String appmanageGroup = DisUtil.getMap((String)"osconfig_key", (String)appmanageIcode);
        UserSessionBean userSession = OAuthTokenCacheImpl.getInstance().getUserSession(oauthTokenToken + "-" + appmanageGroup);
        Class<?> userCla = userSession.getClass();
        try {
            Field fs = userCla.getDeclaredField(key);
            fs.setAccessible(true);
            fs.set(userSession, value);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthLoginServiceImpl.reLoadUserSession." + e, "\u4fee\u6539\u4fe1\u606f\u5931\u8d25");
        }
        OAuthTokenCacheImpl.getInstance().setUserSession(oauthTokenToken + "-" + appmanageGroup, userSession);
    }

    @Override
    public Map<String, Object> validateLogin(String userName, String browType, String appmanageIcode, String tenantCode) {
        return this.validateLogin(userName, "", browType, appmanageIcode, tenantCode);
    }
}

