/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.token.issuer;

import com.yqbsoft.laser.service.oauthserver.token.issuer.MD5Generator;
import com.yqbsoft.laser.service.oauthserver.token.issuer.OAuthIssuer;
import com.yqbsoft.laser.service.oauthserver.token.issuer.OAuthSystemException;
import com.yqbsoft.laser.service.oauthserver.token.issuer.UUIDValueGenerator;
import com.yqbsoft.laser.service.oauthserver.token.issuer.ValueGenerator;

public class OAuthIssuerImpl
implements OAuthIssuer {
    private ValueGenerator vg;

    public OAuthIssuerImpl(ValueGenerator vg) {
        this.vg = vg;
    }

    @Override
    public String accessToken() throws OAuthSystemException {
        return this.vg.generateValue();
    }

    @Override
    public String refreshToken() throws OAuthSystemException {
        return this.vg.generateValue();
    }

    @Override
    public String authorizationCode() throws OAuthSystemException {
        return this.vg.generateValue();
    }

    public static void main(String[] args) {
        OAuthIssuerImpl md5 = new OAuthIssuerImpl(new MD5Generator());
        OAuthIssuerImpl uuid = new OAuthIssuerImpl(new UUIDValueGenerator());
        try {
            System.out.println(md5.accessToken());
            System.out.println(uuid.accessToken().replace("-", "").toUpperCase());
            System.out.println(uuid.authorizationCode().replace("-", "").toUpperCase());
        }
        catch (OAuthSystemException e) {
            e.printStackTrace();
        }
    }
}

