/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.token.process;

import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.oauthserver.token.process.OAuthTokenProcess;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public abstract class AbstractOauthTokenProcess<T>
extends Thread
implements OAuthTokenProcess<T> {
    private OpenLogUtil logger = new OpenLogUtil(this.getClass());
    private String SYSCODE = "com.yqbsoft.laser.service.oauthserver.token.process.AbstractOauthTokenProcess";
    private static final int LIST_CAPACITY = 300;
    private static final int TIME_MAX = 30000;
    private LinkedBlockingQueue<T> queue = new LinkedBlockingQueue(200000);
    private List<T> processingDataList = new ArrayList<T>();
    private boolean running = true;
    private volatile boolean waiting = false;
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(T t) {
        try {
            this.queue.put(t);
            if (this.waiting) {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
            return true;
        }
        catch (InterruptedException e) {
            this.logger.error(this.SYSCODE, (Object)(".put.error.[queue.size]" + this.queue.size()), (Throwable)e);
            return false;
        }
    }

    @Override
    public void sendToMQ(T t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            long time = System.currentTimeMillis();
            try {
                T entity;
                if (this.queue.isEmpty()) {
                    this.waiting = true;
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait();
                    }
                }
                while ((entity = this.queue.poll(5000L, TimeUnit.MILLISECONDS)) != null) {
                    this.processingDataList.add(entity);
                    if (this.processingDataList.size() < 300 && System.currentTimeMillis() - time < 30000L) continue;
                }
                this.waiting = false;
                this.logger.debug(this.SYSCODE, (Object)"[---------Thread run-------------].inAction.do");
                this.writeIntoDB(this.processingDataList);
                this.processingDataList.clear();
            }
            catch (InterruptedException e) {
                this.logger.error(this.SYSCODE, (Object)".lock.wait.error", (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    this.logger.error(this.SYSCODE, (Object)".sleep.error", (Throwable)e1);
                    this.running = false;
                    break;
                }
            }
        }
    }

    public abstract void writeIntoDB(List<T> var1);

    public int getQueueSize() {
        return this.queue.size();
    }
}

