/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.dao.PtePtradeInfoMapper;
import com.yqbsoft.laser.service.paytradeengine.domain.PtePtradeInfoDomain;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtradeInfo;
import com.yqbsoft.laser.service.paytradeengine.service.PtePtradeInfoService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PtePtradeInfoServiceImpl
extends BaseServiceImpl
implements PtePtradeInfoService {
    public static final String SYS_CODE = "pte.PtePtradeInfoServiceImpl";
    private PtePtradeInfoMapper ptePtradeInfoMapper;

    public void setPtePtradeInfoMapper(PtePtradeInfoMapper ptePtradeInfoMapper) {
        this.ptePtradeInfoMapper = ptePtradeInfoMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptePtradeInfoMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeInfoServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtradeInfo(PtePtradeInfoDomain ptePtradeInfoDomain) {
        if (null == ptePtradeInfoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPtradeInfoDefault(PtePtradeInfo ptePtradeInfo) {
        if (null == ptePtradeInfo) {
            return;
        }
        if (null == ptePtradeInfo.getDataState()) {
            ptePtradeInfo.setDataState(0);
        }
        if (null == ptePtradeInfo.getGmtCreate()) {
            ptePtradeInfo.setGmtCreate(this.getSysDate());
        }
        ptePtradeInfo.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ptePtradeInfo.getPtradeInfoCode())) {
            ptePtradeInfo.setPtradeInfoCode(this.createUUIDString());
        }
    }

    private int getPtradeInfoMaxCode() {
        int code = 0;
        try {
            return this.ptePtradeInfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeInfoServiceImpl.getPtradeInfoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtradeInfoUpdataDefault(PtePtradeInfo ptePtradeInfo) {
        if (null == ptePtradeInfo) {
            return;
        }
        ptePtradeInfo.setGmtModified(this.getSysDate());
    }

    private void savePtradeInfoModel(PtePtradeInfo ptePtradeInfo) throws ApiException {
        if (null == ptePtradeInfo) {
            return;
        }
        try {
            this.ptePtradeInfoMapper.insert(ptePtradeInfo);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.savePtradeInfoModel.ex", (Throwable)e);
        }
    }

    private PtePtradeInfo getPtradeInfoModelById(Integer ptradeInfoId) {
        if (null == ptradeInfoId) {
            return null;
        }
        try {
            return this.ptePtradeInfoMapper.selectByPrimaryKey(ptradeInfoId);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeInfoServiceImpl.getPtradeInfoModelById", (Throwable)e);
            return null;
        }
    }

    public PtePtradeInfo getPtradeInfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptePtradeInfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeInfoServiceImpl.getPtradeInfoModelByCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public PtePtradeInfo getPtradeInfoModelByPtraderCode(Map<String, Object> map) {
        try {
            List<PtePtradeInfo> list = this.ptePtradeInfoMapper.query(map);
            if (null != list && list.size() > 0) {
                return list.get(0);
            }
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeInfoServiceImpl.getPtradeInfoModelByCode", (Throwable)e);
        }
        return null;
    }

    public void delPtradeInfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptePtradeInfoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.delPtradeInfoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.delPtradeInfoModelByCode.num");
        }
    }

    private void deletePtradeInfoModel(Integer ptradeInfoId) throws ApiException {
        if (null == ptradeInfoId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptePtradeInfoMapper.deleteByPrimaryKey(ptradeInfoId);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.deletePtradeInfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.deletePtradeInfoModel.num");
        }
    }

    private void updatePtradeInfoModel(PtePtradeInfo ptePtradeInfo) throws ApiException {
        if (null == ptePtradeInfo) {
            return;
        }
        try {
            this.ptePtradeInfoMapper.updateByPrimaryKeySelective(ptePtradeInfo);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.updatePtradeInfoModel.ex", (Throwable)e);
        }
    }

    private void updateStatePtradeInfoModel(Integer ptradeInfoId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == ptradeInfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptradeInfoId", ptradeInfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptePtradeInfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.updateStatePtradeInfoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.updateStatePtradeInfoModel.null");
        }
    }

    private PtePtradeInfo makePtradeInfo(PtePtradeInfoDomain ptePtradeInfoDomain, PtePtradeInfo ptePtradeInfo) {
        if (null == ptePtradeInfoDomain) {
            return null;
        }
        if (null == ptePtradeInfo) {
            ptePtradeInfo = new PtePtradeInfo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptePtradeInfo, (Object)ptePtradeInfoDomain);
            return ptePtradeInfo;
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeInfoServiceImpl.makePtradeInfo", (Throwable)e);
            return null;
        }
    }

    private List<PtePtradeInfo> queryPtradeInfoModelPage(Map<String, Object> parammap) {
        try {
            return this.ptePtradeInfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeInfoServiceImpl.queryPtradeInfoModel", (Throwable)e);
            return null;
        }
    }

    private int countPtradeInfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptePtradeInfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeInfoServiceImpl.countPtradeInfo", (Throwable)e);
        }
        return i;
    }

    @Override
    public String savePtradeInfo(PtePtradeInfoDomain ptePtradeInfoDomain) throws ApiException {
        String msg = this.checkPtradeInfo(ptePtradeInfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.savePtradeInfo.checkPtradeInfo", msg);
        }
        PtePtradeInfo ptePtradeInfo = this.makePtradeInfo(ptePtradeInfoDomain, null);
        this.setPtradeInfoDefault(ptePtradeInfo);
        this.savePtradeInfoModel(ptePtradeInfo);
        return ptePtradeInfo.getPtradeInfoCode();
    }

    @Override
    public void updatePtradeInfoState(Integer ptradeInfoId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePtradeInfoModel(ptradeInfoId, dataState, oldDataState);
    }

    @Override
    public void updatePtradeInfo(PtePtradeInfoDomain ptePtradeInfoDomain) throws ApiException {
        String msg = this.checkPtradeInfo(ptePtradeInfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.updatePtradeInfo.checkPtradeInfo", msg);
        }
        PtePtradeInfo oldPtePtradeInfo = this.getPtradeInfoModelById(ptePtradeInfoDomain.getPtradeInfoId());
        if (null == oldPtePtradeInfo) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.updatePtradeInfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtePtradeInfo ptePtradeInfo = this.makePtradeInfo(ptePtradeInfoDomain, oldPtePtradeInfo);
        this.setPtradeInfoUpdataDefault(ptePtradeInfo);
        this.updatePtradeInfoModel(ptePtradeInfo);
    }

    @Override
    public PtePtradeInfo getPtradeInfo(Integer ptradeInfoId) {
        return this.getPtradeInfoModelById(ptradeInfoId);
    }

    @Override
    public void deletePtradeInfo(Integer ptradeInfoId) throws ApiException {
        this.deletePtradeInfoModel(ptradeInfoId);
    }

    @Override
    public QueryResult<PtePtradeInfo> queryPtradeInfoPage(Map<String, Object> map) {
        List<PtePtradeInfo> ptePtradeInfoList = this.queryPtradeInfoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtradeInfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptePtradeInfoList);
        return queryResult;
    }

    @Override
    public PtePtradeInfo getPtradeInfoByCode(Map<String, Object> map) {
        return this.getPtradeInfoModelByCode(map);
    }

    @Override
    public void delPtradeInfoByCode(Map<String, Object> map) throws ApiException {
        this.delPtradeInfoModelByCode(map);
    }
}

