/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.PteConstants;
import com.yqbsoft.laser.service.paytradeengine.cache.PteQueryCall;
import com.yqbsoft.laser.service.paytradeengine.cache.SyncTradeFuture;
import com.yqbsoft.laser.service.paytradeengine.dao.PtePtradeMapper;
import com.yqbsoft.laser.service.paytradeengine.domain.PtePtradeDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PtePtradeInfoDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PtePtradeParticipantDomain;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtrade;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtradeInfo;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtradeParticipant;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtradpdeMpg;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtradpdeMpgpa;
import com.yqbsoft.laser.service.paytradeengine.sdomain.ChannelRestForm;
import com.yqbsoft.laser.service.paytradeengine.sdomain.PayengineForm;
import com.yqbsoft.laser.service.paytradeengine.sdomain.PePaymentDomain;
import com.yqbsoft.laser.service.paytradeengine.sdomain.PePaymentOrderDomain;
import com.yqbsoft.laser.service.paytradeengine.sdomain.PePaymentParticipantDomain;
import com.yqbsoft.laser.service.paytradeengine.sdomain.PtradeBackBean;
import com.yqbsoft.laser.service.paytradeengine.sdomain.PtradeBean;
import com.yqbsoft.laser.service.paytradeengine.sdomain.VdFaccountOuter;
import com.yqbsoft.laser.service.paytradeengine.service.PtePtradeInfoService;
import com.yqbsoft.laser.service.paytradeengine.service.PtePtradeParticipantService;
import com.yqbsoft.laser.service.paytradeengine.service.PtePtradeService;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PtradePollThread;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PtradePutThread;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PtradeService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PtePtradeServiceImpl
extends BaseServiceImpl
implements PtePtradeService {
    public static final String SYS_CODE = "pte.PtePtradeServiceImpl";
    private PtePtradeMapper ptePtradeMapper;
    private PtePtradeInfoService ptePtradeInfoService;
    private PtePtradeParticipantService ptePtradeParticipantService;
    private static PtradeService ptradeService;
    private static Object lock;

    public void setPtePtradeInfoService(PtePtradeInfoService ptePtradeInfoService) {
        this.ptePtradeInfoService = ptePtradeInfoService;
    }

    public void setPtePtradeMapper(PtePtradeMapper ptePtradeMapper) {
        this.ptePtradeMapper = ptePtradeMapper;
    }

    public void setPtePtradeParticipantService(PtePtradeParticipantService ptePtradeParticipantService) {
        this.ptePtradeParticipantService = ptePtradeParticipantService;
    }

    private Date getSysDate() {
        try {
            return this.ptePtradeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtrade(PtePtradeDomain ptePtradeDomain) {
        if (null == ptePtradeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ptePtradeDomain.getMerchantCode())) {
            msg = msg + "\u5546\u6237\u53f7\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ptePtradeDomain.getOpuserCode())) {
            msg = msg + "\u7528\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ptePtradeDomain.getPtradpdeCode())) {
            msg = msg + "\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a;";
        }
        if (ptePtradeDomain.getOrderAmount() == null) {
            msg = msg + "\u4ea4\u6613\u989d\u4e3a\u7a7a;";
        }
        if (ptePtradeDomain.getPartnerCode() == null) {
            msg = msg + "\u5408\u4f5c\u65b9\u7f16\u7801\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPtradeDefault(PtePtrade ptePtrade) {
        if (null == ptePtrade) {
            return;
        }
        if (null == ptePtrade.getDataState()) {
            ptePtrade.setDataState(0);
        }
        if (null == ptePtrade.getGmtCreate()) {
            ptePtrade.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)ptePtrade.getPtradeNotstatus())) {
            ptePtrade.setPtradeNotstatus("0");
        }
        ptePtrade.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ptePtrade.getPtradeSeqno())) {
            ptePtrade.setPtradeSeqno(this.createUUIDString());
        }
    }

    private int getPtradeMaxCode() {
        int code = 0;
        try {
            return this.ptePtradeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.getPtradeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtradeUpdataDefault(PtePtrade ptePtrade) {
        if (null == ptePtrade) {
            return;
        }
        ptePtrade.setGmtModified(this.getSysDate());
    }

    private void savePtradeModel(PtePtrade ptePtrade) throws ApiException {
        if (null == ptePtrade) {
            return;
        }
        try {
            this.ptePtradeMapper.insert(ptePtrade);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.savePtradeModel.ex", (Throwable)e);
        }
    }

    private PtePtrade getPtradeModelById(Integer ptradeId) {
        if (null == ptradeId) {
            return null;
        }
        try {
            return this.ptePtradeMapper.selectByPrimaryKey(ptradeId);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.getPtradeModelById", (Throwable)e);
            return null;
        }
    }

    public PtePtrade getPtradeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptePtradeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.getPtradeModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPtradeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptePtradeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.delPtradeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PtePtradeServiceImpl.delPtradeModelByCode.num");
        }
    }

    private void deletePtradeModel(Integer ptradeId) throws ApiException {
        if (null == ptradeId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptePtradeMapper.deleteByPrimaryKey(ptradeId);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.deletePtradeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PtePtradeServiceImpl.deletePtradeModel.num");
        }
    }

    private void updatePtradeModel(PtePtrade ptePtrade) throws ApiException {
        if (null == ptePtrade) {
            return;
        }
        try {
            this.ptePtradeMapper.updateByPrimaryKeySelective(ptePtrade);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePtradeModel.ex", (Throwable)e);
        }
    }

    private void updateStatePtradeModel(Integer ptradeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == ptradeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptradeId", ptradeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptePtradeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.updateStatePtradeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PtePtradeServiceImpl.updateStatePtradeModel.null");
        }
    }

    private void updatePtradeModelById(Integer ptradeId, Integer oldDataState, Map<String, Object> setMap) throws ApiException {
        if (null == ptradeId || null == oldDataState || setMap == null || setMap.isEmpty()) {
            return;
        }
        setMap.put("ptradeId", ptradeId);
        setMap.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptePtradeMapper.updateStateByPrimaryKey(setMap);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePtradeModelById.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePtradeModelById.null");
        }
    }

    private PtePtrade makePtrade(PtePtradeDomain ptePtradeDomain, PtePtrade ptePtrade) {
        if (null == ptePtradeDomain) {
            return null;
        }
        if (null == ptePtrade) {
            ptePtrade = new PtePtrade();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptePtrade, (Object)ptePtradeDomain);
            return ptePtrade;
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.makePtrade", (Throwable)e);
            return null;
        }
    }

    private List<PtePtrade> queryPtradeModelPage(Map<String, Object> parammap) {
        try {
            return this.ptePtradeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.queryPtradeModel", (Throwable)e);
            return null;
        }
    }

    private int countPtrade(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptePtradeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.countPtrade", (Throwable)e);
        }
        return i;
    }

    private String savePtradeInfo(PtePtrade ptePtrade) {
        try {
            PtePtradeInfoDomain ptePtradeInfoDomain = new PtePtradeInfoDomain();
            BeanUtils.copyAllPropertys((Object)ptePtradeInfoDomain, (Object)ptePtrade);
            ptePtradeInfoDomain.setPaymentOperator(ptePtrade.getPaymentOperator());
            return this.ptePtradeInfoService.savePtradeInfo(ptePtradeInfoDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String savePtrade(PtePtradeDomain ptePtradeDomain) throws ApiException {
        String msg = this.checkPtrade(ptePtradeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PtePtradeServiceImpl.savePtrade.checkPtrade", msg);
        }
        PtePtrade ptePtrade = this.makePtrade(ptePtradeDomain, null);
        this.setPtradeDefault(ptePtrade);
        String ptradeInfoCode = this.savePtradeInfo(ptePtrade);
        if (!ptePtrade.getOpuserCode().equals(ptePtrade.getMerchantCode())) {
            Map<String, Object> map = this.setMerchant(ptePtrade, ptradeInfoCode);
            String ptradeExtension = ptePtrade.getPtradeExtension();
            if (StringUtils.isNotBlank((String)ptradeExtension)) {
                Map pa = (Map)JsonUtil.buildNormalBinder().getJsonToMap(ptradeExtension, String.class, Object.class);
                map.putAll(pa);
            }
            ptePtrade.setPtradeExtension(JsonUtil.buildNormalBinder().toJson(map));
        }
        this.savePtradeModel(ptePtrade);
        return ptePtrade.getPtradeSeqno();
    }

    @Override
    public String sendSavePtrade(PtePtradeDomain ptePtradeDomain) throws ApiException {
        String ptradeSeqno = this.savePtrade(ptePtradeDomain);
        PtradeBean ptradeBean = ptePtradeDomain.getPtradeBean();
        if (ptradeBean != null) {
            ptradeBean.setPtradeSeqno(ptradeSeqno);
            return this.sendParticipantByPtrade(ptradeBean);
        }
        return null;
    }

    @Override
    public void updatePtradeState(Integer ptradeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePtradeModel(ptradeId, dataState, oldDataState);
    }

    @Override
    public void updatePtrade(PtePtradeDomain ptePtradeDomain) throws ApiException {
        String msg = this.checkPtrade(ptePtradeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePtrade.checkPtrade", msg);
        }
        PtePtrade oldPtePtrade = this.getPtradeModelById(ptePtradeDomain.getPtradeId());
        if (null == oldPtePtrade) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePtrade.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtePtrade ptePtrade = this.makePtrade(ptePtradeDomain, oldPtePtrade);
        this.setPtradeUpdataDefault(ptePtrade);
        this.updatePtradeModel(ptePtrade);
    }

    @Override
    public PtePtrade getPtrade(Integer ptradeId) {
        return this.getPtradeModelById(ptradeId);
    }

    @Override
    public void deletePtrade(Integer ptradeId) throws ApiException {
        this.deletePtradeModel(ptradeId);
    }

    @Override
    public QueryResult<PtePtrade> queryPtradePage(Map<String, Object> map) {
        List<PtePtrade> ptePtradeList = this.queryPtradeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtrade(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptePtradeList);
        return queryResult;
    }

    @Override
    public PtePtrade getPtradeByCode(Map<String, Object> map) {
        return this.getPtradeModelByCode(map);
    }

    @Override
    public void delPtradeByCode(Map<String, Object> map) throws ApiException {
        this.delPtradeModelByCode(map);
    }

    private Map<String, Object> setMerchant(PtePtrade ptePtrade, String ptradeInfoCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("merchantCode", ptePtrade.getMerchantCode());
        String code = ptePtrade.getMerchantCode().substring(0, 1);
        pmap.put("faccountType", code + "01");
        pmap.put("tenantCode", ptePtrade.getTenantCode());
        String result = this.internalInvoke("vd.faccountOuter.queryOuterFaccount", pmap);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("pte.PtePtradeServiceImpl.savePtrade.setMerchant", "\u672a\u67e5\u8be2\u5230\u5546\u6237\u8d26\u6237\u4fe1\u606f!");
        }
        List vdFaccountOuter = (List)JsonUtil.buildNormalBinder().getJsonToList(result, VdFaccountOuter.class);
        if (ListUtil.isEmpty((Collection)vdFaccountOuter)) {
            throw new ApiException("pte.PtePtradeServiceImpl.savePtrade.setMerchant", "\u672a\u67e5\u8be2\u5230\u5546\u6237\u8d26\u6237\u4fe1\u606f!");
        }
        PtePtradeParticipantDomain ptePtradeParticipantDomain = new PtePtradeParticipantDomain();
        ptePtradeParticipantDomain.setPtradeInfoCode(ptradeInfoCode);
        ptePtradeParticipantDomain.setTenantCode(((VdFaccountOuter)vdFaccountOuter.get(0)).getTenantCode());
        ptePtradeParticipantDomain.setPartnerCode(ptePtrade.getPartnerCode());
        ptePtradeParticipantDomain.setOpuserCode(ptePtrade.getMerchantCode());
        ptePtradeParticipantDomain.setDicActorCode("SELL_B");
        ptePtradeParticipantDomain.setFaccountId(((VdFaccountOuter)vdFaccountOuter.get(0)).getFaccountOuterNo());
        ptePtradeParticipantDomain.setFchannelCode("0" + code);
        ptePtradeParticipantDomain.setFchannelClassifyCode(code + "01");
        ptePtradeParticipantDomain.setOrderAmount(ptePtrade.getOrderAmount());
        ptePtradeParticipantDomain.setOrderPortion(ptePtrade.getOrderPortion());
        ptePtradeParticipantDomain.setOrderPrice(ptePtrade.getOrderPrice());
        ptePtradeParticipantDomain.setFaccountName(((VdFaccountOuter)vdFaccountOuter.get(0)).getFaccountOuterName());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ptePtradeParticipantDomain.getDicActorCode(), ptePtradeParticipantDomain);
        return map;
    }

    private String checkPtradeBean(PtradeBean ptradeBean) {
        String msg = "";
        if (ptradeBean == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)ptradeBean.getPtradeSeqno())) {
            msg = msg + "ptradeSeqno\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)ptradeBean.getFchannelMode())) {
            msg = msg + "\u6e20\u9053\u6a21\u5f0f\u4e3a\u7a7a";
        }
        if (ListUtil.isEmpty(ptradeBean.getPartList())) {
            msg = msg + "\u4ea4\u6613\u6e20\u9053\u79df\u4fe1\u606f\u4e3a\u7a7a";
        }
        return msg;
    }

    @Override
    public String saveParticipantByPtrade(PtradeBean ptradeBean) throws ApiException {
        String msg = this.checkPtradeBean(ptradeBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtrade.null", msg);
        }
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("ptradeSeqno", ptradeBean.getPtradeSeqno());
        pmap.put("tenantCode", ptradeBean.getTenantCode());
        PtePtrade ptePtrade = this.getPtradeModelByCode(pmap);
        if (null == ptePtrade) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtrade.null", "\u672a\u83b7\u53d6\u5230\u4ea4\u6613\u4fe1\u606f");
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)ptePtrade, (Object)ptradeBean);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.copyAllPropertysNotNull", (Throwable)e);
        }
        PtePtradeInfo ptePtradeInfo = this.ptePtradeInfoService.getPtradeInfoModelByPtraderCode(pmap);
        if (null == ptePtradeInfo) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtrade.null", "\u672a\u83b7\u53d6\u5230\u4ea4\u6613\u4fe1\u606f");
        }
        List<PtePtradpdeMpgpa> list = this.queryPtradpdeMpgpa(ptePtrade);
        if (list == null || list.size() == 0) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtrade.null", "\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        Map<String, Object> paramsMap = this.makeParamsMap(ptradeBean.getPartList(), ptePtrade, ptePtradeInfo);
        ArrayList<PtePtradeParticipantDomain> participantList = new ArrayList<PtePtradeParticipantDomain>();
        for (PtePtradpdeMpgpa ptePtradpdeMpgpa : list) {
            PtePtradeParticipantDomain ptePtradeParticipantDomain = this.analysisParticipant(ptePtradpdeMpgpa, paramsMap);
            if (ptePtradeParticipantDomain == null) continue;
            participantList.add(ptePtradeParticipantDomain);
        }
        if (participantList == null || participantList.isEmpty()) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtrade.makeParticipantList", "\u65e0\u89e3\u6790\u6570\u636e");
        }
        for (PtePtradeParticipantDomain ptePtradeParticipantDomain : participantList) {
            this.ptePtradeParticipantService.savePtradeParticipant(ptePtradeParticipantDomain);
        }
        Integer state = "0".equals(ptradeBean.getFchannelMode()) ? PteConstants.DATA_STATE_1 : PteConstants.DATA_STATE_3;
        this.updatePtradeState(ptePtrade.getPtradeId(), state, ptePtrade.getDataState());
        String paymentSeqno = this.sendPatment(ptePtrade, ptePtradeInfo, participantList, "AN");
        if (StringUtils.isBlank((String)paymentSeqno)) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtrade.sendPatment", "\u64cd\u4f5c\u5931\u8d25");
        }
        return paymentSeqno;
    }

    private String sendPatment(PtePtrade ptePtrade, PtePtradeInfo ptePtradeInfo, List<PtePtradeParticipantDomain> participantList, String paymentType) {
        if (participantList == null || participantList.isEmpty() || ptePtrade == null || ptePtradeInfo == null) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtrade.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        PePaymentDomain pePaymentDomain = new PePaymentDomain();
        PePaymentOrderDomain pePaymentOrderDomain = new PePaymentOrderDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pePaymentDomain, (Object)ptePtrade);
            if (StringUtils.isBlank((String)paymentType)) {
                paymentType = "AN";
            }
            pePaymentDomain.setPaymentType(paymentType);
            pePaymentDomain.setPaymentOldseqno(ptePtrade.getPaymentSeqno());
            pePaymentDomain.setPaymentReturnurl("pte.ptrade.sendCallBack");
            pePaymentDomain.setPartnerCode(ptePtrade.getPartnerCode());
            pePaymentDomain.setFchannelPmodeCode(ptePtrade.getFchannelPmodeCode());
            pePaymentDomain.setPaymentSeqno(null);
            pePaymentDomain.setDataState(null);
            BeanUtils.copyAllPropertys((Object)pePaymentOrderDomain, (Object)ptePtradeInfo);
            String str = DisUtil.getMap((String)"ptePtradpdeMpg_key", (String)(ptePtrade.getTenantCode() + "-" + ptePtrade.getPtradpdeCode()));
            PtePtradpdeMpg ptePtradpdeMpg = (PtePtradpdeMpg)JsonUtil.buildNormalBinder().getJsonToObject(str, PtePtradpdeMpg.class);
            pePaymentOrderDomain.setDicPaypdCode(ptePtradpdeMpg.getDicPaypdCode());
            pePaymentOrderDomain.setPaymentOrderMemo(ptePtradeInfo.getMemo());
            pePaymentOrderDomain.setPtradpdeCode(ptePtrade.getPtradpdeCode());
            pePaymentOrderDomain.setPaymentSeqno(null);
            ArrayList<PePaymentOrderDomain> orderDomainList = new ArrayList<PePaymentOrderDomain>();
            pePaymentDomain.setOrderDomainList(orderDomainList);
            orderDomainList.add(pePaymentOrderDomain);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.copyAllPropertys", (Throwable)e);
        }
        ArrayList<PePaymentParticipantDomain> participantDomainList = new ArrayList<PePaymentParticipantDomain>();
        pePaymentOrderDomain.setParticipantDomainList(participantDomainList);
        for (PtePtradeParticipantDomain ptePtradeParticipantDomain : participantList) {
            PePaymentParticipantDomain p1 = new PePaymentParticipantDomain();
            try {
                pePaymentOrderDomain.setOrderCurrency(ptePtradeParticipantDomain.getOrderCurrency());
                BeanUtils.copyAllPropertys((Object)p1, (Object)ptePtradeParticipantDomain);
            }
            catch (Exception e) {
                this.logger.error("pte.PtePtradeServiceImpl.copyAllPropertys", (Throwable)e);
            }
            participantDomainList.add(p1);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("pePaymentDomain", JsonUtil.buildNormalBinder().toJson((Object)pePaymentDomain));
        return this.internalInvoke("pe.paymentEngine.sendPayment", paramMap);
    }

    private Map<String, Object> makeParamsMap(List<PtePtradeParticipantDomain> partList, PtePtrade ptePtrade, PtePtradeInfo ptePtradeinfo) {
        if (partList == null || partList.isEmpty()) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtrade.makeParamsMap", "\u65e0\u4ea4\u6613\u4fe1\u606f");
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        String ptradeExtension = ptePtrade.getPtradeExtension();
        if (StringUtils.isNotBlank((String)ptradeExtension)) {
            Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(ptradeExtension, String.class, PtePtradeParticipantDomain.class);
            paramsMap.putAll(map);
        }
        for (PtePtradeParticipantDomain ptradePartBean : partList) {
            paramsMap.put(ptradePartBean.getDicActorCode(), ptradePartBean);
        }
        paramsMap.put(PtePtrade.class.getSimpleName(), ptePtrade);
        paramsMap.put(PtePtradeInfo.class.getSimpleName(), ptePtradeinfo);
        return paramsMap;
    }

    private PtePtradeParticipantDomain analysisParticipant(PtePtradpdeMpgpa ptePtradpdeMpgpa, Map<String, Object> paramsMap) {
        if (ptePtradpdeMpgpa == null || paramsMap == null || paramsMap.isEmpty()) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtrade.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        PtePtradeParticipantDomain domain = new PtePtradeParticipantDomain();
        try {
            String dicActorCode = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaActor(), paramsMap);
            if (StringUtils.isBlank((String)dicActorCode)) {
                return null;
            }
            BigDecimal orderAmount = (BigDecimal)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaAmount(), paramsMap);
            if (orderAmount == null) {
                return null;
            }
            String faccountIdType = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFatype(), paramsMap);
            String faccountId = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFaid(), paramsMap);
            String faccountName = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFaname(), paramsMap);
            String faccountBranch = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFabranch(), paramsMap);
            String faccountProvince = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFaprovince(), paramsMap);
            String faccountCity = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFacity(), paramsMap);
            String faccountLocation = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFalocation(), paramsMap);
            String opuserCode = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaUcode(), paramsMap);
            String fchannelCode = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFchannel(), paramsMap);
            String fchannelClassifyCode = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFcclassify(), paramsMap);
            String fundType = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFund(), paramsMap);
            String orderPrice = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaPrice(), paramsMap);
            String orderPortion = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaPortion(), paramsMap);
            String orderCurrency = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaCurrency(), paramsMap);
            domain.setDicActorCode(dicActorCode);
            domain.setOrderAmount(orderAmount);
            domain.setFaccountId(faccountId);
            domain.setFaccountIdType(faccountIdType);
            domain.setFchannelCode(fchannelCode);
            domain.setFchannelClassifyCode(fchannelClassifyCode);
            domain.setFundType(fundType);
            domain.setOrderCurrency(orderCurrency);
            domain.setOrderPortion(StringUtils.isBlank((String)orderPortion) ? BigDecimal.ZERO : new BigDecimal(orderPortion));
            domain.setOrderPrice(StringUtils.isBlank((String)orderPrice) ? BigDecimal.ZERO : new BigDecimal(orderPrice));
            domain.setFaccountName(faccountName);
            domain.setFaccountBranch(faccountBranch);
            domain.setFaccountProvince(faccountProvince);
            domain.setFaccountCity(faccountCity);
            domain.setFaccountLocation(faccountLocation);
            domain.setOpuserCode(opuserCode);
            PtePtradeInfo ptePtradeInfo = (PtePtradeInfo)paramsMap.get(PtePtradeInfo.class.getSimpleName());
            domain.setPtradeInfoCode(ptePtradeInfo.getPtradeInfoCode());
            domain.setTenantCode(ptePtradeInfo.getTenantCode());
            domain.setPartnerCode(ptePtradeInfo.getPartnerCode());
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.analysisParticipant", "\u89e3\u6790\u9519\u8bef", (Throwable)e);
        }
        return domain;
    }

    private List<PtePtradpdeMpgpa> queryPtradpdeMpgpa(PtePtrade ptradeBean) {
        if (ptradeBean == null) {
            return null;
        }
        String str = DisUtil.getMap((String)"ptePtradpdeMpg_key", (String)(ptradeBean.getTenantCode() + "-" + ptradeBean.getPtradpdeCode()));
        PtePtradpdeMpg ptePtradpdeMpg = (PtePtradpdeMpg)JsonUtil.buildNormalBinder().getJsonToObject(str, PtePtradpdeMpg.class);
        if (ptePtradpdeMpg == null) {
            throw new ApiException("pte.PtePtradeServiceImpl.queryPtradpdeMpgpa.getPtradpdeMpgByCode", "\u6570\u636e\u4e3a\u7a7a");
        }
        List<PtePtradpdeMpgpa> list = this.getPteMap("ptePtradpdeMpgpa_key", ptradeBean.getTenantCode() + "-" + ptePtradpdeMpg.getPtradpdeMpgCode(), PtePtradpdeMpgpa.class);
        if (list == null) {
            throw new ApiException("pte.PtePtradeServiceImpl.queryPtradpdeMpgpa.queryPtradpdeMpgpaPage", "\u6570\u636e\u4e3a\u7a7a");
        }
        return list;
    }

    @Override
    public String getGateway(PtradeBean ptradeBean) {
        if (ptradeBean == null) {
            throw new ApiException("pte.PtePtradeServiceImpl.getGateway.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String returnparam = "";
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("ptradeSeqno", ptradeBean.getPtradeSeqno());
        pmap.put("tenantCode", ptradeBean.getTenantCode());
        PtePtrade ptePtrade = this.getPtradeModelByCode(pmap);
        if (null == ptePtrade) {
            throw new ApiException("pte.PtePtradeServiceImpl.getGateway.null", "\u672a\u83b7\u53d6\u5230\u4ea4\u6613\u4fe1\u606f");
        }
        if (PteConstants.DATA_STATE_1 == ptePtrade.getDataState()) {
            returnparam = this.getCachStrByThread(ptradeBean.getTenantCode() + "-" + ptradeBean.getPtradeSeqno() + "-" + PteConstants.DATA_STATE_2);
        } else if (PteConstants.DATA_STATE_2 == ptePtrade.getDataState()) {
            returnparam = ptePtrade.getPaymentReturnparam();
        } else {
            throw new ApiException("pte.PtePtradeServiceImpl.getGateway.stateError", "\u72b6\u6001\u4fe1\u606f\u6709\u8bef");
        }
        return returnparam;
    }

    private String getCachStrByThread(String correlationId) {
        SyncTradeFuture syncTradeFuture = new SyncTradeFuture();
        String returnStr = SupDisUtil.getMap((String)"PTEQUERY_CALL", (String)correlationId);
        if (StringUtils.isBlank((String)returnStr)) {
            PteQueryCall.putSync(correlationId, syncTradeFuture, 5000L);
            returnStr = (String)syncTradeFuture.get(5000L);
        }
        return returnStr;
    }

    @Override
    public void saveParticipantByPtradeBack(PtradeBackBean ptradeBackBean) throws ApiException {
        String paymentSeqno;
        if (null == ptradeBackBean) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (null == ptradeBackBean.getAcquireSeqno()) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.null", "\u9000\u56de\u4e1a\u52a1\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        if (null == ptradeBackBean.getPtradpdeCode()) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.null", "\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        if (null == ptradeBackBean.getAcquireSeqno_new()) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.null", "\u65b0\u8ba2\u5355\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("acquireSeqno", ptradeBackBean.getAcquireSeqno());
        pmap.put("tenantCode", ptradeBackBean.getTenantCode());
        List<PtePtrade> list = this.queryPtradeModelPage(pmap);
        if (list == null || list.size() == 0) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack", "\u539f\u4ea4\u6613\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01");
        }
        pmap.clear();
        pmap.put("tenantCode", ptradeBackBean.getTenantCode());
        pmap.put("ptradeSeqno", list.get(0).getPtradeSeqno());
        QueryResult<PtePtradeInfo> qRptePtradeInfo = this.ptePtradeInfoService.queryPtradeInfoPage(pmap);
        if (qRptePtradeInfo == null || qRptePtradeInfo.getList().size() == 0) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack", "\u4ea4\u6613\u8be6\u60c5\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01");
        }
        PtePtrade ptePtrade = list.get(0);
        ptePtrade.setGmtPaid(null);
        ptePtrade.setGmtCreate(null);
        ptePtrade.setPtradeSeqno(null);
        ptePtrade.setPtradeId(null);
        ptePtrade.setPtradpdeCode(ptradeBackBean.getPtradpdeCode());
        if (ptradeBackBean.getOrderAmount() != null && ptradeBackBean.getOrderAmount().compareTo(BigDecimal.ZERO) != 1) {
            ptePtrade.setOrderAmount(ptradeBackBean.getOrderAmount());
        }
        ptePtrade.setAcquireSeqno(ptradeBackBean.getAcquireSeqno_new());
        this.setPtradeDefault(ptePtrade);
        ptePtrade.setDataState(PteConstants.DATA_STATE_1);
        PtePtradeInfo ptePtradeInfo = new PtePtradeInfo();
        PtePtradeInfoDomain ptePtradeInfoDomain = new PtePtradeInfoDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptePtradeInfoDomain, (Object)ptePtrade);
            BeanUtils.copyAllPropertys((Object)ptePtradeInfo, (Object)ptePtrade);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack", (Throwable)e);
        }
        String ptePtradeInfoCode = this.ptePtradeInfoService.savePtradeInfo(ptePtradeInfoDomain);
        String oldptePtradeInfoCode = ((PtePtradeInfo)qRptePtradeInfo.getList().get(0)).getPtradeInfoCode();
        ArrayList<PtePtradeParticipantDomain> participantList = new ArrayList<PtePtradeParticipantDomain>();
        if (ptradeBackBean.getPartList() == null || ptradeBackBean.getPartList().size() == 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ptradeInfoCode", oldptePtradeInfoCode);
            map.put("tenantCode", ptradeBackBean.getTenantCode());
            QueryResult<PtePtradeParticipant> rs = this.ptePtradeParticipantService.queryPtradeParticipantPage(map);
            if (rs == null || rs.getList().size() == 0) {
                throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack", "\u6e20\u9053\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01");
            }
            for (PtePtradeParticipant ptePtradeParticipant : rs.getList()) {
                PtePtradeParticipantDomain domain = new PtePtradeParticipantDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)domain, (Object)ptePtradeParticipant);
                }
                catch (Exception e) {
                    this.logger.error("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack", (Throwable)e);
                }
                domain.setPtePtradeId(null);
                domain.setPtePtradeCode(null);
                domain.setPtradeInfoCode(ptePtradeInfoCode);
                this.ptePtradeParticipantService.savePtradeParticipant(domain);
                participantList.add(domain);
            }
        } else {
            for (PtePtradeParticipantDomain ptePtradeParticipantDomain : ptradeBackBean.getPartList()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("dicActorCode", ptePtradeParticipantDomain.getDicActorCode());
                map.put("faccountId", ptePtradeParticipantDomain.getFaccountId());
                map.put("ptradeInfoCode", oldptePtradeInfoCode);
                map.put("tenantCode", ptradeBackBean.getTenantCode());
                QueryResult<PtePtradeParticipant> rs = this.ptePtradeParticipantService.queryPtradeParticipantPage(map);
                if (rs == null || rs.getList().size() == 0) {
                    throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack", "\u6e20\u9053\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01");
                }
                PtePtradeParticipantDomain domain = new PtePtradeParticipantDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)domain, rs.getList().get(0));
                }
                catch (Exception e) {
                    this.logger.error("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack", (Throwable)e);
                }
                domain.setPtePtradeId(null);
                domain.setPtePtradeCode(null);
                domain.setPtradeInfoCode(ptePtradeInfoCode);
                domain.setOrderAmount(ptePtradeParticipantDomain.getOrderAmount());
                this.ptePtradeParticipantService.savePtradeParticipant(domain);
                participantList.add(domain);
            }
        }
        if (StringUtils.isBlank((String)(paymentSeqno = this.sendPatment(ptePtrade, ptePtradeInfo, participantList, "AB")))) {
            throw new ApiException("pte.PtePtradeServiceImplsaveParticipantByPtradeBack.sendPatment", "\u53d1\u9001\u652f\u4ed8\u5931\u8d25\uff01");
        }
        ptePtrade.setPaymentSeqno(paymentSeqno);
        this.savePtradeModel(ptePtrade);
    }

    @Override
    public void sendCallBack(Map<String, Object> map) throws ApiException {
        String tenantCode = (String)map.get("tenantCode");
        String partnerCode = (String)map.get("partnerCode");
        String ptradeSeqno = (String)map.get("ptradeSeqno");
        String paymentSeqno = (String)map.get("paymentSeqno");
        String paymentReorderMemo = (String)map.get("paymentReorderMemo");
        PayengineForm payengineForm = (PayengineForm)JsonUtil.buildNormalBinder().getJsonToObject(paymentReorderMemo, PayengineForm.class);
        String paymentstate = "";
        if (null != payengineForm && null != payengineForm.getCallmap() && null != payengineForm.getChannelRestForm()) {
            paymentstate = (String)payengineForm.getCallmap().get("paymentstate");
        }
        if (StringUtils.isBlank((String)paymentstate)) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveCallBack.paymentstate.null", "\u56de\u8c03\u72b6\u6001\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((String)ptradeSeqno)) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveCallBack", "\u4ea4\u6613\u6d41\u6c34\u53f7\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("ptradeSeqno", ptradeSeqno);
        pmap.put("tenantCode", tenantCode);
        pmap.put("partnerCode", partnerCode);
        PtePtrade ptePtrade = this.getPtradeByCode(pmap);
        if (ptePtrade == null) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveCallBack", "\u65e0\u6548\u4ea4\u6613\u6d41\u6c34\uff01");
        }
        pmap.clear();
        pmap.put("paymentSeqno", paymentSeqno);
        pmap.put("paymentReturnparam", paymentReorderMemo);
        pmap.put("dataState", Integer.parseInt(paymentstate));
        pmap.put("ptradeNotstatus", "0");
        this.updatePtradeModelById(ptePtrade.getPtradeId(), ptePtrade.getDataState(), pmap);
        ChannelRestForm channelRestForm = payengineForm.getChannelRestForm();
        PteQueryCall.call(tenantCode + "-" + ptradeSeqno + "-" + paymentstate, JsonUtil.buildNonDefaultBinder().toJson((Object)channelRestForm));
        ptePtrade.setDataState(Integer.parseInt(paymentstate));
        this.getPtradeService().putQueue(ptePtrade);
    }

    @Override
    public String sendParticipantByPtrade(PtradeBean ptradeBean) throws ApiException {
        this.saveParticipantByPtrade(ptradeBean);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("ptradeSeqno", ptradeBean.getPtradeSeqno());
        pmap.put("tenantCode", ptradeBean.getTenantCode());
        if ("0".equals(ptradeBean.getFchannelMode())) {
            return this.getCachStrByThread(ptradeBean.getTenantCode() + "-" + ptradeBean.getPtradeSeqno() + "-" + PteConstants.DATA_STATE_2);
        }
        return null;
    }

    public List<?> getPteMap(String mapkey, String key, Class<?> clazz) {
        Map map = DisUtil.getMapAll((String)mapkey);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Map.Entry entry : map.entrySet()) {
            if (((String)entry.getKey()).indexOf(key) == -1) continue;
            list.add(JsonUtil.getAllJsonUtil().getJsonToObject((String)entry.getValue(), clazz));
        }
        return list;
    }

    @Override
    public void sendPtradeCallback(PtePtrade ptePtrade) {
        boolean returnFlag = false;
        if (ptePtrade == null) {
            throw new ApiException("pte.PtePtradeServiceImpl.sendPtradeCallback", "\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isNotBlank((String)ptePtrade.getPaymentReturnurl())) {
            HashMap<String, String> pmap = new HashMap<String, String>();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("acquireSeqno", ptePtrade.getAcquireSeqno());
            paramMap.put("dataState", ptePtrade.getDataState());
            paramMap.put("tenantCode", ptePtrade.getTenantCode());
            paramMap.put("partnerCode", ptePtrade.getPartnerCode());
            paramMap.put("ptradpdeCode", ptePtrade.getPtradpdeCode());
            pmap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
            String flag = this.internalInvoke(ptePtrade.getPaymentReturnurl(), pmap);
            if ("true".equals(flag)) {
                HashMap<String, Object> setMap = new HashMap<String, Object>();
                setMap.put("ptradeNotstatus", "1");
                this.updatePtradeModelById(ptePtrade.getPtradeId(), ptePtrade.getDataState(), setMap);
                returnFlag = true;
            }
        }
        if (!returnFlag) {
            throw new ApiException("pte.PtePtradeServiceImpl.sendPtradeCallback", "\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
    }

    @Override
    public void loadPtradeProcess() {
        this.getPtradeService().addPollPool(new PtradePollThread(this.getPtradeService()));
        this.getPtradeService().addPollPool(new PtradePollThread(this.getPtradeService()));
        this.getPtradeService().addPollPool(new PtradePollThread(this.getPtradeService()));
        this.getPtradeService().addPollPool(new PtradePollThread(this.getPtradeService()));
        this.getPtradeService().addPollPool(new PtradePollThread(this.getPtradeService()));
        this.loadDb();
    }

    private void loadDb() {
        try {
            this.logger.info("pte.PtePtradeServiceImpl.loadDb.start", (Object)"============start================");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ptradeNotstatus", "0");
            QueryResult<PtePtrade> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getPtradeService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getPtradeService().getPage());
                result = this.queryPtradePage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getPtradeService().addPutPool(new PtradePutThread(this.getPtradeService(), result.getRows()));
                    if (result.getRows().size() == this.getPtradeService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getPtradeService().initStartRow();
            this.logger.info("pte.PtePtradeServiceImpl.loadDb.end", (Object)"============end================");
        }
        catch (Exception e) {
            this.logger.info("pte.PtePtradeServiceImpl.loadDb.end.e", (Object)"============end================", (Throwable)e);
            throw new ApiException("pte.PtePtradeServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PtradeService getPtradeService() {
        Object object = lock;
        synchronized (object) {
            if (null == ptradeService) {
                ptradeService = new PtradeService((PtePtradeService)SpringApplicationContextUtil.getBean((String)"ptePtradeService"));
            }
            return ptradeService;
        }
    }

    @Override
    public boolean checkPtradeSuccess(String tenantCode, String ptradeSeqno, String dataState) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)ptradeSeqno) || StringUtils.isBlank((String)dataState)) {
            return false;
        }
        for (int i = 0; i < dataState.split(",").length; ++i) {
            String state = dataState.split(",")[i];
            String correlationId = tenantCode + "-" + ptradeSeqno + "-" + state;
            String str = "";
            str = i == 0 ? this.getCachStrByThread(correlationId) : SupDisUtil.getMap((String)"PTEQUERY_CALL", (String)(tenantCode + "-" + ptradeSeqno + "-" + state));
            if (StringUtils.isBlank((String)str)) continue;
            return true;
        }
        return false;
    }

    static {
        lock = new Object();
    }
}

