/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.permis.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.permis.PermisConstants;
import com.yqbsoft.laser.service.permis.dao.UpMenuMapper;
import com.yqbsoft.laser.service.permis.dao.UpOpPermissionMapper;
import com.yqbsoft.laser.service.permis.dao.UpPermissionMapper;
import com.yqbsoft.laser.service.permis.domain.UpMenuDomainBean;
import com.yqbsoft.laser.service.permis.model.UpMenu;
import com.yqbsoft.laser.service.permis.model.UpOpPermission;
import com.yqbsoft.laser.service.permis.model.UpPermission;
import com.yqbsoft.laser.service.permis.service.MenuService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;

public class MenuServiceImpl
extends BaseServiceImpl
implements MenuService {
    public static final String SYS_CODE = "up.PERMIS.MenuServiceImpl";
    private UpMenuMapper upMenuMapper;
    private UpOpPermissionMapper upOpPermissionMapper;
    private UpPermissionMapper upPermissionMapper;

    public UpPermissionMapper getUpPermissionMapper() {
        return this.upPermissionMapper;
    }

    public void setUpPermissionMapper(UpPermissionMapper upPermissionMapper) {
        this.upPermissionMapper = upPermissionMapper;
    }

    public UpOpPermissionMapper getUpOpPermissionMapper() {
        return this.upOpPermissionMapper;
    }

    public void setUpOpPermissionMapper(UpOpPermissionMapper upOpPermissionMapper) {
        this.upOpPermissionMapper = upOpPermissionMapper;
    }

    public UpMenuMapper getUpMenuMapper() {
        return this.upMenuMapper;
    }

    public void setUpMenuMapper(UpMenuMapper upMenuMapper) {
        this.upMenuMapper = upMenuMapper;
    }

    @Override
    public void saveMenu(UpMenu upMenu) throws ApiException {
        String msg = this.check(upMenu);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.saveMenu.null", msg);
        }
        this.setDefault(upMenu);
        this.saveMenuModel(upMenu);
    }

    private void saveMenuModel(UpMenu upMenu) throws ApiException {
        if (upMenu == null) {
            return;
        }
        try {
            this.upMenuMapper.insert(upMenu);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.saveMenuModel.ex");
        }
    }

    private String check(UpMenu upMenu) {
        if (upMenu == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)upMenu.getMenuName())) {
            msg = String.valueOf(msg) + "\u83dc\u5355\u540d\u79f0\u4e3a\u7a7a;";
        }
        return msg;
    }

    private Date getSysDate() {
        try {
            return this.upMenuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.MenuServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private void setDefault(UpMenu upMenu) {
        if (upMenu == null) {
            return;
        }
        if (upMenu.getDataState() == null) {
            upMenu.setDataState(0);
        }
        if (upMenu.getGmtCreate() == null) {
            upMenu.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)upMenu.getMenuCode())) {
            int code = this.getMaxcode();
            upMenu.setMenuCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxcode() {
        int code = 0;
        try {
            code = this.upMenuMapper.getMaxCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    private List<UpMenu> queryMenu(Map<String, Object> parammap) {
        try {
            return this.upMenuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public UpMenu getMenu(Integer menuId) {
        return this.upMenuMapper.selectByPrimaryKey(menuId);
    }

    @Override
    public void updateMenu(UpMenuDomainBean upMenuDomainBean) throws ApiException {
        UpMenu upMenu = this.getMenu(upMenuDomainBean.getMenuId());
        if (upMenu == null) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.updateMenu.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(upMenu = this.makeModel(upMenu, upMenuDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.updateMenu.null", msg);
        }
        this.setUpDefault(upMenu);
        this.updateMenuModel(upMenu);
    }

    private void updateMenuModel(UpMenu upMenu) throws ApiException {
        if (upMenu == null) {
            return;
        }
        try {
            this.upMenuMapper.updateByPrimaryKey(upMenu);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.MenuServiceImpl.updateMenuModel.ex", (Throwable)e);
        }
    }

    private void setUpDefault(UpMenu upMenu) {
        if (upMenu == null) {
            return;
        }
        upMenu.setGmtModified(this.getSysDate());
    }

    private UpMenu makeModel(UpMenu upMenu, UpMenuDomainBean upMenuDomainBean) {
        if (upMenuDomainBean == null) {
            return null;
        }
        if (upMenu == null) {
            upMenu = new UpMenu();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upMenu, (Object)upMenuDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return upMenu;
    }

    @Override
    public List<UpMenu> queryUpMenu(Map<String, Object> map) {
        return this.queryMenu(map);
    }

    @Override
    public void deleteMenu(Integer menuId) {
        this.upMenuMapper.deleteByPrimaryKey(menuId);
    }

    @Override
    public QueryResult<UpMenu> queryUpMenuPage(Map<String, Object> map) {
        QueryResult queryResult = new QueryResult();
        List<UpMenu> list = this.queryMenu(map);
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.count(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(list);
        return queryResult;
    }

    private int count(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upMenuMapper.count(map);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    @Override
    public List<UpMenuDomainBean> queryUpMenuTree(String appmanageIcode, String menuParentCode) {
        ArrayList<UpMenuDomainBean> upMenuDomainBeanList = new ArrayList<UpMenuDomainBean>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appmanageIcode", appmanageIcode);
        map.put("menuParentCode", menuParentCode);
        map.put("order", true);
        map.put("menuShow", 0);
        List<UpMenu> upMenuList = this.queryMenu(map);
        if (upMenuList == null || upMenuList.isEmpty()) {
            return null;
        }
        for (UpMenu upMenu : upMenuList) {
            UpMenuDomainBean upMenuDomainBean = this.getUpMenuDomain(upMenu);
            upMenuDomainBean.setChildren(this.queryUpMenuTree(upMenu.getAppmanageIcode(), upMenu.getMenuCode()));
            upMenuDomainBeanList.add(upMenuDomainBean);
        }
        return upMenuDomainBeanList;
    }

    @Override
    public List<UpMenuDomainBean> queryUpMenuPermisTree(String appmanageIcode, String menuParentCode, String tenantCode) {
        List<UpMenuDomainBean> upMenuDomainBeanList = this.queryUpMenuTree(appmanageIcode, menuParentCode);
        if (upMenuDomainBeanList == null || upMenuDomainBeanList.isEmpty()) {
            return null;
        }
        List<UpPermission> permissionList = this.upPermissionMapper.query(this.getQueryParamMap("appmanageIcode,permissionSort", new Object[]{appmanageIcode, PermisConstants.PERMIS_SORT_OPER}));
        HashMap<String, String> permissionMap = null;
        if (permissionList != null && !permissionList.isEmpty()) {
            permissionMap = new HashMap<String, String>();
            for (UpPermission upPermission : permissionList) {
                permissionMap.put(upPermission.getPermissionCode(), upPermission.getPermissionCode());
            }
        }
        List<UpOpPermission> tenantPermisList = this.upOpPermissionMapper.query(this.getQueryParamMap("tenantCode,appmanageIcode,opPermissionType,opPermissionCode", new Object[]{tenantCode, appmanageIcode, PermisConstants.PERMIS_TYPE_TENANT, tenantCode}));
        HashMap<String, String> tenantPerMap = null;
        if (tenantPermisList != null && !tenantPermisList.isEmpty()) {
            tenantPerMap = new HashMap<String, String>();
            for (UpOpPermission upOpPermission : tenantPermisList) {
                tenantPerMap.put(upOpPermission.getMenuCode(), upOpPermission.getMenuCode());
            }
        }
        return this.makePermisMenu(upMenuDomainBeanList, permissionMap, tenantPerMap);
    }

    private List<UpMenuDomainBean> makePermisMenu(List<UpMenuDomainBean> upMenuDomainBeanList, Map<String, String> permissionMap, Map<String, String> tenantPerMap) {
        if (upMenuDomainBeanList == null || upMenuDomainBeanList.isEmpty()) {
            return null;
        }
        ArrayList<UpMenuDomainBean> menuList = new ArrayList<UpMenuDomainBean>();
        for (UpMenuDomainBean upMenuDomainBean : upMenuDomainBeanList) {
            String permissionCode = upMenuDomainBean.getPermissionCode();
            String menuCode = upMenuDomainBean.getMenuCode();
            List<UpMenuDomainBean> childen = upMenuDomainBean.getChildren();
            if (childen == null || childen.isEmpty()) {
                if (StringUtil.isBlank((String)permissionCode) || permissionMap != null && StringUtil.isBlank((String)permissionMap.get(permissionCode)) || tenantPerMap != null && StringUtil.isBlank((String)tenantPerMap.get(menuCode))) continue;
                menuList.add(upMenuDomainBean);
                continue;
            }
            childen = this.makePermisMenu(upMenuDomainBean.getChildren(), permissionMap, tenantPerMap);
            if (childen == null || childen.isEmpty()) continue;
            upMenuDomainBean.setChildren(childen);
            menuList.add(upMenuDomainBean);
        }
        return menuList;
    }

    @Override
    public Map<String, String> queryMenuCodeByUrl(String appmanageIcode, String menuParentCode) {
        List<UpMenuDomainBean> list = this.queryUpMenuTree(appmanageIcode, menuParentCode);
        return this.queryMenuCodeByUrlWrapper(list);
    }

    private Map<String, String> queryMenuCodeByUrlWrapper(List<UpMenuDomainBean> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashMap<String, String> menuCodeMap = new HashMap<String, String>();
        for (UpMenuDomainBean upMenuDomainBean : list) {
            this.putMenuCodeMap(upMenuDomainBean.getChildren(), menuCodeMap, String.valueOf(upMenuDomainBean.getMenuCode()) + "_" + upMenuDomainBean.getMenuAction());
            menuCodeMap.put(upMenuDomainBean.getMenuAction(), String.valueOf(upMenuDomainBean.getMenuCode()) + "_" + upMenuDomainBean.getMenuAction());
        }
        return menuCodeMap;
    }

    private void putMenuCodeMap(List<UpMenuDomainBean> list, Map<String, String> menuCodeMap, String parentMenuCode) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (UpMenuDomainBean upMenuDomainBean : list) {
            if (upMenuDomainBean.getChildren() != null && !upMenuDomainBean.getChildren().isEmpty()) {
                this.putMenuCodeMap(upMenuDomainBean.getChildren(), menuCodeMap, parentMenuCode);
            }
            if (!StringUtils.isNotBlank((String)upMenuDomainBean.getMenuAction())) continue;
            menuCodeMap.put(upMenuDomainBean.getMenuAction(), parentMenuCode);
        }
    }

    private UpMenuDomainBean getUpMenuDomain(UpMenu upMenu) {
        UpMenuDomainBean upMenuDomainBean = new UpMenuDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)upMenuDomainBean, (Object)upMenu);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return upMenuDomainBean;
    }

    @Override
    public void updateMenuRelease(Integer menuId) {
        UpMenu upMenu = this.getMenu(menuId);
        this.releaseMenu(upMenu, null, null, false);
    }

    @Override
    public void updateMenuReleaseByCode(Map<String, Object> map) {
        String doclistCode;
        List<UpMenu> menuList = this.queryUpMenu(map);
        String string = doclistCode = map.get("doclistCode") == null ? null : map.get("doclistCode").toString();
        if (menuList != null && !menuList.isEmpty()) {
            this.releaseMenu(menuList.get(0), doclistCode, map.get("OUT_PUT"), true);
        }
    }

    private void releaseMenu(UpMenu upMenu, String doclistCode, Object outPut, boolean flag) {
        if (upMenu == null) {
            return;
        }
        upMenu.setDataState(PermisConstants.MENU_STATE_1);
        this.updateMenuModel(upMenu);
        HashMap<String, Object> map = new HashMap<String, Object>();
        String fileName = upMenu.getMenuAction();
        if (StringUtil.isBlank((String)doclistCode)) {
            map.put("OUT_PUT", String.valueOf(upMenu.getMenuJspath()) + upMenu.getMenuAction());
            if (StringUtil.isBlank((String)upMenu.getMenuIndexCode())) {
                return;
            }
            map.put("modelCode", upMenu.getMenuIndexCode());
        } else {
            fileName = String.valueOf(doclistCode) + ".html";
            if (outPut == null) {
                map.put("OUT_PUT", String.valueOf(doclistCode) + ".html");
            } else {
                map.put("OUT_PUT", outPut);
            }
            if (StringUtil.isBlank((String)upMenu.getMenuDetailsCode())) {
                this.logger.error("releaseMenu is error, menuDetailCode is null, menuCode ==> \u3010" + upMenu.getMenuCode() + "\u3011");
                return;
            }
            map.put("modelCode", upMenu.getMenuDetailsCode());
        }
        map.put("menuCode", upMenu.getMenuCode());
        map.put("menuType", upMenu.getMenuType());
        map.put("doclistCode", doclistCode);
        map.put("tenantCode", upMenu.getTenantCode());
        map.put("menuDetailsCode", upMenu.getMenuDetailsCode());
        map.put("fileName", fileName);
        map.put("flag", flag);
        map.put(UpMenu.class.getSimpleName(), upMenu);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.internalInvoke("cms.model.updateReleaseModel", paramsMap);
    }

    @Override
    public List<UpMenu> queryUpMenuByCode(String appmanageIcode, List<String> menuCodeList) {
        return this.queryUpMenuModelByCode(appmanageIcode, menuCodeList);
    }

    private List<UpMenu> queryUpMenuModelByCode(String appmanageIcode, List<String> menuCodeList) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("appmanageIcode", appmanageIcode);
            map.put("menuCodes", menuCodeList);
            return this.upMenuMapper.queryByCodes(map);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public String updateMenuReleaseAll(Map<String, Object> map) {
        List<UpMenu> menuList = this.queryUpMenu(map);
        if (menuList == null || menuList.size() == 0) {
            return "\u67e5\u8be2\u83dc\u5355\u5931\u8d25";
        }
        String rs = "";
        for (UpMenu menu : menuList) {
            try {
                this.updateMenuRelease(menu.getMenuId());
            }
            catch (Exception e) {
                rs = String.valueOf(rs) + menu.getMenuName() + "\u53d1\u5e03\u5931\u8d25!";
            }
        }
        return rs;
    }

    @Override
    public List<UpMenuDomainBean> queryUpMenuTreeByMap(Map<String, Object> map) {
        if (map == null || map.get("appmanageIcode") == null || map.get("menuParentCode") == null || map.get("tenantCode") == null) {
            return null;
        }
        String appmanageIcode = String.valueOf(map.get("appmanageIcode"));
        String menuParentCode = String.valueOf(map.get("menuParentCode"));
        String tenantCode = String.valueOf(map.get("tenantCode"));
        return this.queryUpMenuTree(appmanageIcode, menuParentCode, tenantCode);
    }

    @Override
    public Map<String, String> queryMenuCodeByUrlMap(Map<String, Object> map) {
        String appmanageIcode = String.valueOf(map.get("appmanageIcode"));
        String menuParentCode = String.valueOf(map.get("menuParentCode"));
        String tenantCode = String.valueOf(map.get("tenantCode"));
        List<UpMenuDomainBean> list = this.queryUpMenuTree(appmanageIcode, menuParentCode, tenantCode);
        return this.queryMenuCodeByUrlWrapper(list);
    }

    private List<UpMenuDomainBean> queryUpMenuTree(String appmanageIcode, String menuParentCode, String tenantCode) {
        ArrayList<UpMenuDomainBean> upMenuDomainBeanList = new ArrayList<UpMenuDomainBean>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appmanageIcode", appmanageIcode);
        map.put("menuParentCode", menuParentCode);
        map.put("tenantCode", tenantCode);
        map.put("order", true);
        map.put("menuShow", 0);
        List<UpMenu> upMenuList = this.queryMenu(map);
        if (upMenuList == null || upMenuList.isEmpty()) {
            return null;
        }
        for (UpMenu upMenu : upMenuList) {
            UpMenuDomainBean upMenuDomainBean = this.getUpMenuDomain(upMenu);
            upMenuDomainBean.setChildren(this.queryUpMenuTree(upMenu.getAppmanageIcode(), upMenu.getMenuCode(), upMenu.getTenantCode()));
            upMenuDomainBeanList.add(upMenuDomainBean);
        }
        return upMenuDomainBeanList;
    }
}

