/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.freemarker.FreemarkerUtil;
import com.yqbsoft.laser.service.portal.PortalConstants;
import com.yqbsoft.laser.service.portal.dao.CmsHtmltagMapper;
import com.yqbsoft.laser.service.portal.domain.CmsHtmltagDomain;
import com.yqbsoft.laser.service.portal.model.CmsHtmltag;
import com.yqbsoft.laser.service.portal.service.CmsHtmltagService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmsHtmltagServiceImpl
extends BaseServiceImpl
implements CmsHtmltagService {
    public static final String SYS_CODE = "cms.CmsHtmltagServiceImpl";
    private CmsHtmltagMapper cmsHtmltagMapper;

    public void setCmsHtmltagMapper(CmsHtmltagMapper cmsHtmltagMapper) {
        this.cmsHtmltagMapper = cmsHtmltagMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmsHtmltagMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsHtmltagServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkHtmltag(CmsHtmltagDomain cmsHtmltagDomain) {
        if (null == cmsHtmltagDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setHtmltagDefault(CmsHtmltag cmsHtmltag) {
        if (null == cmsHtmltag) {
            return;
        }
        if (null == cmsHtmltag.getDataState()) {
            cmsHtmltag.setDataState(0);
        }
        if (null == cmsHtmltag.getGmtCreate()) {
            cmsHtmltag.setGmtCreate(this.getSysDate());
        }
        cmsHtmltag.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsHtmltag.getHtmltagCode())) {
            cmsHtmltag.setHtmltagCode(this.createUUIDString());
        }
    }

    private int getHtmltagMaxCode() {
        int code = 0;
        try {
            return this.cmsHtmltagMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsHtmltagServiceImpl.getHtmltagMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setHtmltagUpdataDefault(CmsHtmltag cmsHtmltag) {
        if (null == cmsHtmltag) {
            return;
        }
        cmsHtmltag.setGmtModified(this.getSysDate());
    }

    private void saveHtmltagModel(CmsHtmltag cmsHtmltag) throws ApiException {
        if (null == cmsHtmltag) {
            return;
        }
        try {
            this.cmsHtmltagMapper.insert(cmsHtmltag);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsHtmltagServiceImpl.saveHtmltagModel.ex", (Throwable)e);
        }
    }

    private CmsHtmltag getHtmltagModelById(Integer htmltagId) {
        if (null == htmltagId) {
            return null;
        }
        try {
            return this.cmsHtmltagMapper.selectByPrimaryKey(htmltagId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsHtmltagServiceImpl.getHtmltagModelById", (Throwable)e);
            return null;
        }
    }

    public CmsHtmltag getHtmltagModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsHtmltagMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsHtmltagServiceImpl.getHtmltagModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delHtmltagModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsHtmltagMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsHtmltagServiceImpl.delHtmltagModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsHtmltagServiceImpl.delHtmltagModelByCode.num");
        }
    }

    private void deleteHtmltagModel(Integer htmltagId) throws ApiException {
        if (null == htmltagId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsHtmltagMapper.deleteByPrimaryKey(htmltagId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsHtmltagServiceImpl.deleteHtmltagModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsHtmltagServiceImpl.deleteHtmltagModel.num");
        }
    }

    private void updateHtmltagModel(CmsHtmltag cmsHtmltag) throws ApiException {
        if (null == cmsHtmltag) {
            return;
        }
        try {
            this.cmsHtmltagMapper.updateByPrimaryKeySelective(cmsHtmltag);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsHtmltagServiceImpl.updateHtmltagModel.ex", (Throwable)e);
        }
    }

    private void updateStateHtmltagModel(Integer htmltagId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == htmltagId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("htmltagId", htmltagId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsHtmltagMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsHtmltagServiceImpl.updateStateHtmltagModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsHtmltagServiceImpl.updateStateHtmltagModel.null");
        }
    }

    private CmsHtmltag makeHtmltag(CmsHtmltagDomain cmsHtmltagDomain, CmsHtmltag cmsHtmltag) {
        if (null == cmsHtmltagDomain) {
            return null;
        }
        if (null == cmsHtmltag) {
            cmsHtmltag = new CmsHtmltag();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsHtmltag, (Object)cmsHtmltagDomain);
            return cmsHtmltag;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsHtmltagServiceImpl.makeHtmltag", (Throwable)e);
            return null;
        }
    }

    private List<CmsHtmltag> queryHtmltagModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsHtmltagMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsHtmltagServiceImpl.queryHtmltagModel", (Throwable)e);
            return null;
        }
    }

    private int countHtmltag(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsHtmltagMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsHtmltagServiceImpl.countHtmltag", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveHtmltag(CmsHtmltagDomain cmsHtmltagDomain) throws ApiException {
        String msg = this.checkHtmltag(cmsHtmltagDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsHtmltagServiceImpl.saveHtmltag.checkHtmltag", msg);
        }
        CmsHtmltag cmsHtmltag = this.makeHtmltag(cmsHtmltagDomain, null);
        this.setHtmltagDefault(cmsHtmltag);
        this.saveHtmltagModel(cmsHtmltag);
    }

    @Override
    public void updateHtmltagState(Integer htmltagId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateHtmltagModel(htmltagId, dataState, oldDataState);
    }

    @Override
    public void updateHtmltag(CmsHtmltagDomain cmsHtmltagDomain) throws ApiException {
        String msg = this.checkHtmltag(cmsHtmltagDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsHtmltagServiceImpl.updateHtmltag.checkHtmltag", msg);
        }
        CmsHtmltag oldCmsHtmltag = this.getHtmltagModelById(cmsHtmltagDomain.getHtmltagId());
        if (null == oldCmsHtmltag) {
            throw new ApiException("cms.CmsHtmltagServiceImpl.updateHtmltag.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsHtmltag cmsHtmltag = this.makeHtmltag(cmsHtmltagDomain, oldCmsHtmltag);
        this.setHtmltagUpdataDefault(cmsHtmltag);
        this.updateHtmltagModel(cmsHtmltag);
    }

    @Override
    public CmsHtmltag getHtmltag(Integer htmltagId) {
        return this.getHtmltagModelById(htmltagId);
    }

    @Override
    public void deleteHtmltag(Integer htmltagId) throws ApiException {
        this.deleteHtmltagModel(htmltagId);
    }

    @Override
    public QueryResult<CmsHtmltag> queryHtmltagPage(Map<String, Object> map) {
        List<CmsHtmltag> cmsHtmltagList = this.queryHtmltagModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countHtmltag(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsHtmltagList);
        return queryResult;
    }

    @Override
    public CmsHtmltag getHtmltagByCode(Map<String, Object> map) {
        return this.getHtmltagModelByCode(map);
    }

    @Override
    public void delHtmltagByCode(Map<String, Object> map) throws ApiException {
        this.delHtmltagModelByCode(map);
    }

    @Override
    public String getHtmltagModel(Map<String, Object> map) throws ApiException {
        try {
            CmsHtmltag cmsHtmltag = this.getHtmltagByCode(map);
            if (cmsHtmltag == null) {
                return null;
            }
            String htmltagDataconf = cmsHtmltag.getHtmltagDataconf();
            if (PortalConstants.HTMLTAG_TYPE_0 == cmsHtmltag.getHtmltagType()) {
                map.put(map.get("key").toString(), new FreemarkerUtil().returnTranslateByString(map, htmltagDataconf));
                return htmltagDataconf;
            }
            if (PortalConstants.HTMLTAG_TYPE_1 == cmsHtmltag.getHtmltagType()) {
                return this.makeModelHtml(cmsHtmltag, map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String makeModelHtml(CmsHtmltag cmsHtmltag, Map<String, Object> data) {
        if (cmsHtmltag == null) {
            return null;
        }
        try {
            String htmltagCom = cmsHtmltag.getHtmltagCom();
            Map comMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(htmltagCom, String.class, String.class);
            String apiCode = (String)comMap.get("apiCode");
            String objType = (String)comMap.get("type");
            if (StringUtils.isBlank((String)objType)) {
                objType = "object";
            }
            String className = (String)comMap.get("className");
            Object[] classNames = null;
            if (!StringUtils.isBlank((String)className)) {
                classNames = new Object[className.split(",").length];
                for (int i = 0; i < className.split(",").length; ++i) {
                    classNames[i] = Class.forName(className.split(",")[i]);
                }
            } else {
                classNames = new Object[]{String.class};
            }
            String htmltagModel = new FreemarkerUtil().returnTranslateByString(data, cmsHtmltag.getHtmltagModel());
            Map modelMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(htmltagModel, String.class, Object.class);
            Object sourceStr = this.readObj(apiCode, modelMap, objType, classNames);
            data.put("obj", sourceStr);
            String html = new FreemarkerUtil().returnTranslateByString(data, cmsHtmltag.getHtmltagDataconf());
            data.put(data.get("key").toString(), html);
            return html;
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsHtmltagServiceImpl.makeModelHtml", "\u52a8\u6001\u6807\u7b7e\u66ff\u6362\u9519\u8bef\u3010htmltagCode\u3011(" + cmsHtmltag.getHtmltagCode() + ")", (Throwable)e);
        }
    }
}

