/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.dao.CmsMenucontrastMapper;
import com.yqbsoft.laser.service.portal.domain.CmsMenucontrastDomain;
import com.yqbsoft.laser.service.portal.domain.ContrastMenuDomain;
import com.yqbsoft.laser.service.portal.model.CmsMenucontrast;
import com.yqbsoft.laser.service.portal.service.CmsMenucontrastService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class CmsMenucontrastServiceImpl
extends BaseServiceImpl
implements CmsMenucontrastService {
    public static final String SYS_CODE = "cms.CmsMenucontrastServiceImpl";
    private CmsMenucontrastMapper cmsMenucontrastMapper;

    public void setCmsMenucontrastMapper(CmsMenucontrastMapper cmsMenucontrastMapper) {
        this.cmsMenucontrastMapper = cmsMenucontrastMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmsMenucontrastMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsMenucontrastServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMenucontrast(CmsMenucontrastDomain cmsMenucontrastDomain) {
        if (null == cmsMenucontrastDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cmsMenucontrastDomain.getMenuCode())) {
            msg = msg + "\u83dc\u5355\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cmsMenucontrastDomain.getOpMenuCode())) {
            msg = msg + "\u5173\u8054\u83dc\u5355\u4ee3\u7801\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMenucontrastDefault(CmsMenucontrast cmsMenucontrast) {
        if (null == cmsMenucontrast) {
            return;
        }
        if (null == cmsMenucontrast.getDataState()) {
            cmsMenucontrast.setDataState(0);
        }
        if (null == cmsMenucontrast.getGmtCreate()) {
            cmsMenucontrast.setGmtCreate(this.getSysDate());
        }
        cmsMenucontrast.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsMenucontrast.getMenucontrastCode())) {
            cmsMenucontrast.setMenucontrastCode(this.createUUIDString());
        }
    }

    private int getMenucontrastMaxCode() {
        int code = 0;
        try {
            return this.cmsMenucontrastMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsMenucontrastServiceImpl.getMenucontrastMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMenucontrastUpdataDefault(CmsMenucontrast cmsMenucontrast) {
        if (null == cmsMenucontrast) {
            return;
        }
        cmsMenucontrast.setGmtModified(this.getSysDate());
    }

    private void saveMenucontrastModel(CmsMenucontrast cmsMenucontrast) throws ApiException {
        if (null == cmsMenucontrast) {
            return;
        }
        try {
            this.cmsMenucontrastMapper.insert(cmsMenucontrast);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsMenucontrastServiceImpl.saveMenucontrastModel.ex", (Throwable)e);
        }
    }

    private CmsMenucontrast getMenucontrastModelById(Integer menucontrastId) {
        if (null == menucontrastId) {
            return null;
        }
        try {
            return this.cmsMenucontrastMapper.selectByPrimaryKey(menucontrastId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsMenucontrastServiceImpl.getMenucontrastModelById", (Throwable)e);
            return null;
        }
    }

    public CmsMenucontrast getMenucontrastModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsMenucontrastMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsMenucontrastServiceImpl.getMenucontrastModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delMenucontrastModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsMenucontrastMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsMenucontrastServiceImpl.delMenucontrastModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsMenucontrastServiceImpl.delMenucontrastModelByCode.num");
        }
    }

    private void deleteMenucontrastModel(Integer menucontrastId) throws ApiException {
        if (null == menucontrastId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsMenucontrastMapper.deleteByPrimaryKey(menucontrastId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsMenucontrastServiceImpl.deleteMenucontrastModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsMenucontrastServiceImpl.deleteMenucontrastModel.num");
        }
    }

    private void updateMenucontrastModel(CmsMenucontrast cmsMenucontrast) throws ApiException {
        if (null == cmsMenucontrast) {
            return;
        }
        try {
            this.cmsMenucontrastMapper.updateByPrimaryKeySelective(cmsMenucontrast);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsMenucontrastServiceImpl.updateMenucontrastModel.ex", (Throwable)e);
        }
    }

    private void updateStateMenucontrastModel(Integer menucontrastId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == menucontrastId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("menucontrastId", menucontrastId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsMenucontrastMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsMenucontrastServiceImpl.updateStateMenucontrastModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsMenucontrastServiceImpl.updateStateMenucontrastModel.null");
        }
    }

    private CmsMenucontrast makeMenucontrast(CmsMenucontrastDomain cmsMenucontrastDomain, CmsMenucontrast cmsMenucontrast) {
        if (null == cmsMenucontrastDomain) {
            return null;
        }
        if (null == cmsMenucontrast) {
            cmsMenucontrast = new CmsMenucontrast();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsMenucontrast, (Object)cmsMenucontrastDomain);
            return cmsMenucontrast;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsMenucontrastServiceImpl.makeMenucontrast", (Throwable)e);
            return null;
        }
    }

    private List<CmsMenucontrast> queryMenucontrastModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsMenucontrastMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsMenucontrastServiceImpl.queryMenucontrastModel", (Throwable)e);
            return null;
        }
    }

    private int countMenucontrast(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsMenucontrastMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsMenucontrastServiceImpl.countMenucontrast", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveMenucontrast(CmsMenucontrastDomain cmsMenucontrastDomain) throws ApiException {
        String msg = this.checkMenucontrast(cmsMenucontrastDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsMenucontrastServiceImpl.saveMenucontrast.checkMenucontrast", msg);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("menuCode", cmsMenucontrastDomain.getMenuCode());
        map.put("menuType", cmsMenucontrastDomain.getMenuType());
        map.put("opMenuCode", cmsMenucontrastDomain.getOpMenuCode());
        map.put("opMenuType", cmsMenucontrastDomain.getOpMenuType());
        QueryResult<CmsMenucontrast> result = this.queryMenucontrastPage(map);
        if (result != null && !result.getRows().isEmpty() && result.getRows() != null) {
            return;
        }
        CmsMenucontrast cmsMenucontrast = this.makeMenucontrast(cmsMenucontrastDomain, null);
        this.setMenucontrastDefault(cmsMenucontrast);
        this.saveMenucontrastModel(cmsMenucontrast);
    }

    @Override
    public void updateMenucontrastState(Integer menucontrastId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMenucontrastModel(menucontrastId, dataState, oldDataState);
    }

    @Override
    public void updateMenucontrast(CmsMenucontrastDomain cmsMenucontrastDomain) throws ApiException {
        String msg = this.checkMenucontrast(cmsMenucontrastDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsMenucontrastServiceImpl.updateMenucontrast.checkMenucontrast", msg);
        }
        CmsMenucontrast oldCmsMenucontrast = this.getMenucontrastModelById(cmsMenucontrastDomain.getMenucontrastId());
        if (null == oldCmsMenucontrast) {
            throw new ApiException("cms.CmsMenucontrastServiceImpl.updateMenucontrast.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsMenucontrast cmsMenucontrast = this.makeMenucontrast(cmsMenucontrastDomain, oldCmsMenucontrast);
        this.setMenucontrastUpdataDefault(cmsMenucontrast);
        this.updateMenucontrastModel(cmsMenucontrast);
    }

    @Override
    public CmsMenucontrast getMenucontrast(Integer menucontrastId) {
        return this.getMenucontrastModelById(menucontrastId);
    }

    @Override
    public void deleteMenucontrast(Integer menucontrastId) throws ApiException {
        this.deleteMenucontrastModel(menucontrastId);
    }

    @Override
    public QueryResult<CmsMenucontrast> queryMenucontrastPage(Map<String, Object> map) {
        List<CmsMenucontrast> cmsMenucontrastList = this.queryMenucontrastModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMenucontrast(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsMenucontrastList);
        return queryResult;
    }

    @Override
    public void saveMenuContrastByModel(String htmlText, ContrastMenuDomain contrastMenuDomain) {
        Document doc = Jsoup.parse((String)htmlText);
        List<CmsMenucontrastDomain> menucontrastDomainList = this.getMenucontrastList(contrastMenuDomain, doc);
        if (menucontrastDomainList == null || menucontrastDomainList.isEmpty() || menucontrastDomainList.size() <= 0) {
            return;
        }
        for (CmsMenucontrastDomain cmsMenucontrastDomain : menucontrastDomainList) {
            this.saveMenucontrast(cmsMenucontrastDomain);
        }
    }

    private List<CmsMenucontrastDomain> getMenucontrastList(ContrastMenuDomain contrastMenuDomain, Document doc) {
        if (contrastMenuDomain == null) {
            return null;
        }
        ArrayList<CmsMenucontrastDomain> portalMenuContrastVoList = new ArrayList<CmsMenucontrastDomain>();
        Elements comElementList = doc.getElementsByAttribute("menuComcode");
        if (comElementList != null && !comElementList.isEmpty()) {
            for (Element element : comElementList) {
                String opMenuCode = element.attr("menuComcode");
                CmsMenucontrastDomain cmsMenucontrastDomain = this.makeContrastVo(contrastMenuDomain, opMenuCode);
                portalMenuContrastVoList.add(cmsMenucontrastDomain);
            }
        }
        CmsMenucontrastDomain cmsMenucontrastDomain = this.makeContrastVo(contrastMenuDomain, contrastMenuDomain.getMenuCode());
        portalMenuContrastVoList.add(cmsMenucontrastDomain);
        return portalMenuContrastVoList;
    }

    private CmsMenucontrastDomain makeContrastVo(ContrastMenuDomain contrastMenuDomain, String opMenuCode) {
        if (contrastMenuDomain == null) {
            return null;
        }
        CmsMenucontrastDomain cmsMenucontrastDomain = new CmsMenucontrastDomain();
        cmsMenucontrastDomain.setMenuCode(contrastMenuDomain.getMenuCode());
        cmsMenucontrastDomain.setMenuType(contrastMenuDomain.getMenuType());
        cmsMenucontrastDomain.setOpMenuCode(opMenuCode);
        cmsMenucontrastDomain.setOpMenuType(contrastMenuDomain.getMenuType());
        return cmsMenucontrastDomain;
    }
}

