/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.dao.CmsMmodelMapper;
import com.yqbsoft.laser.service.portal.domain.CmsMmodelDomain;
import com.yqbsoft.laser.service.portal.model.CmsMmodel;
import com.yqbsoft.laser.service.portal.service.CmsMmodelService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmsMmodelServiceImpl
extends BaseServiceImpl
implements CmsMmodelService {
    public static final String SYS_CODE = "cms.CmsMmodelServiceImpl";
    private CmsMmodelMapper cmsMmodelMapper;

    public void setCmsMmodelMapper(CmsMmodelMapper cmsMmodelMapper) {
        this.cmsMmodelMapper = cmsMmodelMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmsMmodelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsMmodelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMmodel(CmsMmodelDomain cmsMmodelDomain) {
        if (null == cmsMmodelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setMmodelDefault(CmsMmodel cmsMmodel) {
        if (null == cmsMmodel) {
            return;
        }
        if (null == cmsMmodel.getDataState()) {
            cmsMmodel.setDataState(0);
        }
        if (null == cmsMmodel.getGmtCreate()) {
            cmsMmodel.setGmtCreate(this.getSysDate());
        }
        cmsMmodel.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsMmodel.getMmodelCode())) {
            cmsMmodel.setMmodelCode(this.createUUIDString());
        }
    }

    private int getMmodelMaxCode() {
        int code = 0;
        try {
            return this.cmsMmodelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsMmodelServiceImpl.getMmodelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMmodelUpdataDefault(CmsMmodel cmsMmodel) {
        if (null == cmsMmodel) {
            return;
        }
        cmsMmodel.setGmtModified(this.getSysDate());
    }

    private void saveMmodelModel(CmsMmodel cmsMmodel) throws ApiException {
        if (null == cmsMmodel) {
            return;
        }
        try {
            this.cmsMmodelMapper.insert(cmsMmodel);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsMmodelServiceImpl.saveMmodelModel.ex", (Throwable)e);
        }
    }

    private CmsMmodel getMmodelModelById(Integer mmodelId) {
        if (null == mmodelId) {
            return null;
        }
        try {
            return this.cmsMmodelMapper.selectByPrimaryKey(mmodelId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsMmodelServiceImpl.getMmodelModelById", (Throwable)e);
            return null;
        }
    }

    public CmsMmodel getMmodelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsMmodelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsMmodelServiceImpl.getMmodelModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delMmodelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsMmodelMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsMmodelServiceImpl.delMmodelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsMmodelServiceImpl.delMmodelModelByCode.num");
        }
    }

    private void deleteMmodelModel(Integer mmodelId) throws ApiException {
        if (null == mmodelId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsMmodelMapper.deleteByPrimaryKey(mmodelId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsMmodelServiceImpl.deleteMmodelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsMmodelServiceImpl.deleteMmodelModel.num");
        }
    }

    private void updateMmodelModel(CmsMmodel cmsMmodel) throws ApiException {
        if (null == cmsMmodel) {
            return;
        }
        try {
            this.cmsMmodelMapper.updateByPrimaryKeySelective(cmsMmodel);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsMmodelServiceImpl.updateMmodelModel.ex", (Throwable)e);
        }
    }

    private void updateStateMmodelModel(Integer mmodelId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == mmodelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mmodelId", mmodelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsMmodelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsMmodelServiceImpl.updateStateMmodelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsMmodelServiceImpl.updateStateMmodelModel.null");
        }
    }

    private CmsMmodel makeMmodel(CmsMmodelDomain cmsMmodelDomain, CmsMmodel cmsMmodel) {
        if (null == cmsMmodelDomain) {
            return null;
        }
        if (null == cmsMmodel) {
            cmsMmodel = new CmsMmodel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsMmodel, (Object)cmsMmodelDomain);
            return cmsMmodel;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsMmodelServiceImpl.makeMmodel", (Throwable)e);
            return null;
        }
    }

    private List<CmsMmodel> queryMmodelModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsMmodelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsMmodelServiceImpl.queryMmodelModel", (Throwable)e);
            return null;
        }
    }

    private int countMmodel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsMmodelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsMmodelServiceImpl.countMmodel", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveMmodel(CmsMmodelDomain cmsMmodelDomain) throws ApiException {
        String msg = this.checkMmodel(cmsMmodelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsMmodelServiceImpl.saveMmodel.checkMmodel", msg);
        }
        CmsMmodel cmsMmodel = this.makeMmodel(cmsMmodelDomain, null);
        this.setMmodelDefault(cmsMmodel);
        this.saveMmodelModel(cmsMmodel);
    }

    @Override
    public void updateMmodelState(Integer mmodelId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMmodelModel(mmodelId, dataState, oldDataState);
    }

    @Override
    public void updateMmodel(CmsMmodelDomain cmsMmodelDomain) throws ApiException {
        String msg = this.checkMmodel(cmsMmodelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsMmodelServiceImpl.updateMmodel.checkMmodel", msg);
        }
        CmsMmodel oldCmsMmodel = this.getMmodelModelById(cmsMmodelDomain.getMmodelId());
        if (null == oldCmsMmodel) {
            throw new ApiException("cms.CmsMmodelServiceImpl.updateMmodel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsMmodel cmsMmodel = this.makeMmodel(cmsMmodelDomain, oldCmsMmodel);
        this.setMmodelUpdataDefault(cmsMmodel);
        this.updateMmodelModel(cmsMmodel);
    }

    @Override
    public CmsMmodel getMmodel(Integer mmodelId) {
        return this.getMmodelModelById(mmodelId);
    }

    @Override
    public void deleteMmodel(Integer mmodelId) throws ApiException {
        this.deleteMmodelModel(mmodelId);
    }

    @Override
    public QueryResult<CmsMmodel> queryMmodelPage(Map<String, Object> map) {
        List<CmsMmodel> cmsMmodelList = this.queryMmodelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMmodel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsMmodelList);
        return queryResult;
    }

    @Override
    public CmsMmodel getMmodelByCode(Map<String, Object> map) {
        return this.getMmodelModelByCode(map);
    }

    @Override
    public void delMmodelByCode(Map<String, Object> map) throws ApiException {
        this.delMmodelModelByCode(map);
    }
}

