/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.freemarker.FreemarkerUtil;
import com.yqbsoft.laser.service.portal.dao.CmsModelMapper;
import com.yqbsoft.laser.service.portal.domain.CmsModelDomain;
import com.yqbsoft.laser.service.portal.domain.ContrastMenuDomain;
import com.yqbsoft.laser.service.portal.domain.UpMenu;
import com.yqbsoft.laser.service.portal.model.CmsModel;
import com.yqbsoft.laser.service.portal.model.FileBean;
import com.yqbsoft.laser.service.portal.model.FileDomain;
import com.yqbsoft.laser.service.portal.service.CmsHtmltagService;
import com.yqbsoft.laser.service.portal.service.CmsMenucontrastService;
import com.yqbsoft.laser.service.portal.service.CmsModelService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmsModelServiceImpl
extends BaseServiceImpl
implements CmsModelService {
    public static final String SYS_CODE = "cms.CmsModelServiceImpl";
    private CmsModelMapper cmsModelMapper;
    private CmsHtmltagService cmsHtmltagService;
    private CmsMenucontrastService cmsMenucontrastService;

    public void setCmsMenucontrastService(CmsMenucontrastService cmsMenucontrastService) {
        this.cmsMenucontrastService = cmsMenucontrastService;
    }

    public void setCmsHtmltagService(CmsHtmltagService cmsHtmltagService) {
        this.cmsHtmltagService = cmsHtmltagService;
    }

    public void setCmsModelMapper(CmsModelMapper cmsModelMapper) {
        this.cmsModelMapper = cmsModelMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmsModelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsModelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkModel(CmsModelDomain cmsModelDomain) {
        if (null == cmsModelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setModelDefault(CmsModel cmsModel) {
        if (null == cmsModel) {
            return;
        }
        if (null == cmsModel.getDataState()) {
            cmsModel.setDataState(0);
        }
        if (null == cmsModel.getGmtCreate()) {
            cmsModel.setGmtCreate(this.getSysDate());
        }
        cmsModel.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsModel.getModelCode())) {
            cmsModel.setModelCode(this.createUUIDString());
        }
    }

    private int getModelMaxCode() {
        int code = 0;
        try {
            return this.cmsModelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsModelServiceImpl.getModelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setModelUpdataDefault(CmsModel cmsModel) {
        if (null == cmsModel) {
            return;
        }
        cmsModel.setGmtModified(this.getSysDate());
    }

    private void saveModelModel(CmsModel cmsModel) throws ApiException {
        if (null == cmsModel) {
            return;
        }
        try {
            this.cmsModelMapper.insert(cmsModel);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsModelServiceImpl.saveModelModel.ex", (Throwable)e);
        }
    }

    private CmsModel getModelModelById(Integer modelId) {
        if (null == modelId) {
            return null;
        }
        try {
            return this.cmsModelMapper.selectByPrimaryKey(modelId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsModelServiceImpl.getModelModelById", (Throwable)e);
            return null;
        }
    }

    public CmsModel getModelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsModelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsModelServiceImpl.getModelModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delModelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsModelMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsModelServiceImpl.delModelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsModelServiceImpl.delModelModelByCode.num");
        }
    }

    private void deleteModelModel(Integer modelId) throws ApiException {
        if (null == modelId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsModelMapper.deleteByPrimaryKey(modelId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsModelServiceImpl.deleteModelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsModelServiceImpl.deleteModelModel.num");
        }
    }

    private void updateModelModel(CmsModel cmsModel) throws ApiException {
        if (null == cmsModel) {
            return;
        }
        try {
            this.cmsModelMapper.updateByPrimaryKeySelective(cmsModel);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsModelServiceImpl.updateModelModel.ex", (Throwable)e);
        }
    }

    private void updateStateModelModel(Integer modelId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == modelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelId", modelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsModelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsModelServiceImpl.updateStateModelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsModelServiceImpl.updateStateModelModel.null");
        }
    }

    private CmsModel makeModel(CmsModelDomain cmsModelDomain, CmsModel cmsModel) {
        if (null == cmsModelDomain) {
            return null;
        }
        if (null == cmsModel) {
            cmsModel = new CmsModel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsModel, (Object)cmsModelDomain);
            return cmsModel;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsModelServiceImpl.makeModel", (Throwable)e);
            return null;
        }
    }

    private List<CmsModel> queryModelModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsModelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsModelServiceImpl.queryModelModel", (Throwable)e);
            return null;
        }
    }

    private int countModel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsModelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsModelServiceImpl.countModel", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveModel(CmsModelDomain cmsModelDomain) throws ApiException {
        String msg = this.checkModel(cmsModelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsModelServiceImpl.saveModel.checkModel", msg);
        }
        CmsModel cmsModel = this.makeModel(cmsModelDomain, null);
        this.setModelDefault(cmsModel);
        this.saveModelModel(cmsModel);
    }

    @Override
    public void updateModelState(Integer modelId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateModelModel(modelId, dataState, oldDataState);
    }

    @Override
    public void updateModel(CmsModelDomain cmsModelDomain) throws ApiException {
        String msg = this.checkModel(cmsModelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsModelServiceImpl.updateModel.checkModel", msg);
        }
        CmsModel oldCmsModel = this.getModelModelById(cmsModelDomain.getModelId());
        if (null == oldCmsModel) {
            throw new ApiException("cms.CmsModelServiceImpl.updateModel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsModel cmsModel = this.makeModel(cmsModelDomain, oldCmsModel);
        this.setModelUpdataDefault(cmsModel);
        this.updateModelModel(cmsModel);
    }

    @Override
    public CmsModel getModel(Integer modelId) {
        return this.getModelModelById(modelId);
    }

    @Override
    public void deleteModel(Integer modelId) throws ApiException {
        this.deleteModelModel(modelId);
    }

    @Override
    public QueryResult<CmsModel> queryModelPage(Map<String, Object> map) {
        List<CmsModel> cmsModelList = this.queryModelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countModel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsModelList);
        return queryResult;
    }

    @Override
    public CmsModel getModelByCode(Map<String, Object> map) {
        return this.getModelModelByCode(map);
    }

    @Override
    public void delModelByCode(Map<String, Object> map) throws ApiException {
        this.delModelModelByCode(map);
    }

    @Override
    public void updateReleaseModel(Map<String, Object> map) {
        CmsModel cmsModel = this.getModelByCode(map);
        if (cmsModel == null) {
            return;
        }
        String htmlConf = cmsModel.getModelConfig();
        Map configMap = (Map)JsonUtil.buildNormalBinder().getJsonToLinkedMap(htmlConf, String.class, String.class);
        if (configMap == null) {
            throw new ApiException("cms.CmsModelServiceImpl.updateReleaseModel", "\u6a21\u677f\u914d\u7f6e\u4fe1\u606f\u9519\u8bef");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(UpMenu.class.getSimpleName(), map.get(UpMenu.class.getSimpleName()));
        for (String key : configMap.keySet()) {
            paramMap.put("htmltagCode", configMap.get(key));
            paramMap.put("key", key);
            this.cmsHtmltagService.getHtmltagModel(paramMap);
        }
        Object outPut = map.get("OUT_PUT");
        if (outPut == null) {
            throw new ApiException("cms.CmsModelServiceImpl.updateReleaseModel", "\u751f\u6210\u76ee\u6807\u8def\u5f84\u4e3a\u7a7a");
        }
        try {
            String html = new FreemarkerUtil().returnTranslateByString(paramMap, cmsModel.getModelHtmlconf());
            this.saveFile(html, outPut.toString(), "00000000", "FILE_04");
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsModelServiceImpl.updateReleaseModel", (Throwable)e);
        }
        ContrastMenuDomain contrastMenuDomain = new ContrastMenuDomain();
        contrastMenuDomain.setMenuCode(map.get("menuCode") == null ? null : map.get("menuCode").toString());
        contrastMenuDomain.setMenuType(map.get("menuType") == null ? null : map.get("menuType").toString());
        this.cmsMenucontrastService.saveMenuContrastByModel(cmsModel.getModelHtmlconf(), contrastMenuDomain);
    }

    private void saveFile(String html, String filename, String tenantCode, String fileSort) {
        try {
            if (html == null) {
                return;
            }
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            String fileType = filename.substring(filename.lastIndexOf(".") + 1, filename.length());
            String name = filename.substring(0, filename.lastIndexOf("."));
            FileDomain fileDomainBean = new FileDomain();
            fileDomainBean.setFileName(name);
            fileDomainBean.setFileType("1");
            fileDomainBean.setFileCtype(fileType);
            fileDomainBean.setFileSort(fileSort);
            fileDomainBean.setTenantCode(tenantCode);
            fileDomainBean.setFlag(true);
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            FileBean fileBean = new FileBean();
            fileBean.setFileType(fileType);
            fileBean.setOriginalFilename(name);
            byte[] b = html.getBytes();
            fileDomainBean.setFileSize(b.length);
            fileBean.setBytes(b);
            fileBean.setSize(Long.valueOf(b.length));
            fileBeanList.add(fileBean);
            paramsMap.put("fmFileDomainBean", JsonUtil.buildNormalBinder().toJson((Object)fileDomainBean));
            paramsMap.put("fileBeanList", JsonUtil.buildNormalBinder().toJson(fileBeanList));
            this.internalInvoke("fm.file.saveFile", paramsMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

