/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.dao.CmsTrainMapper;
import com.yqbsoft.laser.service.portal.domain.CmsTrainDomain;
import com.yqbsoft.laser.service.portal.model.CmsTrain;
import com.yqbsoft.laser.service.portal.service.TrainService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TrainServiceImpl
extends BaseServiceImpl
implements TrainService {
    public static final String SYS_CODE = "cms.TrainServiceImpl";
    private CmsTrainMapper cmsTrainMapper;

    public void setCmsTrainMapper(CmsTrainMapper cmsTrainMapper) {
        this.cmsTrainMapper = cmsTrainMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmsTrainMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.TrainServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTrain(CmsTrainDomain cmsTrainDomain) {
        if (null == cmsTrainDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setTrainDefault(CmsTrain cmsTrain) {
        if (null == cmsTrain) {
            return;
        }
        if (null == cmsTrain.getDataState()) {
            cmsTrain.setDataState(0);
        }
        if (null == cmsTrain.getGmtCreate()) {
            cmsTrain.setGmtCreate(this.getSysDate());
        }
        cmsTrain.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.cmsTrainMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.TrainServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTrainUpdataDefault(CmsTrain cmsTrain) {
        if (null == cmsTrain) {
            return;
        }
        cmsTrain.setGmtModified(this.getSysDate());
    }

    private void saveTrainModel(CmsTrain cmsTrain) throws ApiException {
        if (null == cmsTrain) {
            return;
        }
        try {
            this.cmsTrainMapper.insert(cmsTrain);
        }
        catch (Exception e) {
            throw new ApiException("cms.TrainServiceImpl.saveFtpserverModel.ex");
        }
    }

    private CmsTrain getTrainModelById(Integer trainId) {
        if (null == trainId) {
            return null;
        }
        try {
            return this.cmsTrainMapper.selectByPrimaryKey(trainId);
        }
        catch (Exception e) {
            this.logger.error("cms.TrainServiceImpl.getTrainModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteTrainModel(Integer trainId) throws ApiException {
        if (null == trainId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsTrainMapper.deleteByPrimaryKey(trainId);
        }
        catch (Exception e) {
            throw new ApiException("cms.TrainServiceImpl.deleteTrainModel.ex");
        }
        if (1 != i) {
            throw new ApiException("cms.TrainServiceImpl.deleteTrainModel.num");
        }
    }

    private void updateTrainModel(CmsTrain cmsTrain) throws ApiException {
        if (null == cmsTrain) {
            return;
        }
        try {
            this.cmsTrainMapper.updateByPrimaryKeySelective(cmsTrain);
        }
        catch (Exception e) {
            throw new ApiException("cms.TrainServiceImpl.updateTrainModel.ex");
        }
    }

    private void updateStateTrainModel(Integer trainId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == trainId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("trainId", trainId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsTrainMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.TrainServiceImpl.updateStateTrainModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("cms.TrainServiceImpl.updateStateTrainModel.null");
        }
    }

    private CmsTrain makeTrain(CmsTrainDomain cmsTrainDomain, CmsTrain cmsTrain) {
        if (null == cmsTrainDomain) {
            return null;
        }
        if (null == cmsTrain) {
            cmsTrain = new CmsTrain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsTrain, (Object)cmsTrainDomain);
        }
        catch (Exception e) {
            this.logger.error("cms.TrainServiceImpl.makeTrain", (Throwable)e);
        }
        return cmsTrain;
    }

    private List<CmsTrain> queryTrainModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsTrainMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.TrainServiceImpl.queryTrainModel", (Throwable)e);
            return null;
        }
    }

    private int countTrain(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsTrainMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.TrainServiceImpl.countTrain", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveTrain(CmsTrainDomain cmsTrainDomain) throws ApiException {
        String msg = this.checkTrain(cmsTrainDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.TrainServiceImpl.saveTrain.checkTrain", msg);
        }
        CmsTrain cmsTrain = this.makeTrain(cmsTrainDomain, null);
        this.setTrainDefault(cmsTrain);
        this.saveTrainModel(cmsTrain);
    }

    @Override
    public void updateTrainState(Integer trainId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTrainModel(trainId, dataState, oldDataState);
    }

    @Override
    public void updateTrain(CmsTrainDomain cmsTrainDomain) throws ApiException {
        String msg = this.checkTrain(cmsTrainDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.TrainServiceImpl.updateTrain.checkTrain", msg);
        }
        CmsTrain oldCmsTrain = this.getTrainModelById(cmsTrainDomain.getTrainId());
        if (null == oldCmsTrain) {
            throw new ApiException("cms.TrainServiceImpl.updateTrain.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsTrain cmsTrain = this.makeTrain(cmsTrainDomain, oldCmsTrain);
        this.setTrainUpdataDefault(cmsTrain);
        this.updateTrainModel(cmsTrain);
    }

    @Override
    public CmsTrain getTrain(Integer trainId) {
        return this.getTrainModelById(trainId);
    }

    @Override
    public void deleteTrain(Integer trainId) throws ApiException {
        this.deleteTrainModel(trainId);
    }

    @Override
    public QueryResult<CmsTrain> queryTrainPage(Map<String, Object> map) {
        List<CmsTrain> cmsTrainList = this.queryTrainModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTrain(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsTrainList);
        return queryResult;
    }
}

