/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsResourceGinfoMapper;
import com.yqbsoft.laser.service.resources.domain.RsResourceGinfoDomain;
import com.yqbsoft.laser.service.resources.model.RsResourceGinfo;
import com.yqbsoft.laser.service.resources.service.RsResourceGinfoService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsResourceGinfoServiceImpl
extends BaseServiceImpl
implements RsResourceGinfoService {
    public static final String SYS_CODE = "rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl";
    private RsResourceGinfoMapper rsResourceGinfoMapper;

    public void setRsResourceGinfoMapper(RsResourceGinfoMapper rsResourceGinfoMapper) {
        this.rsResourceGinfoMapper = rsResourceGinfoMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsResourceGinfoMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkResourceGinfo(RsResourceGinfoDomain rsResourceGinfoDomain) {
        if (null == rsResourceGinfoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setResourceGinfoDefault(RsResourceGinfo rsResourceGinfo) {
        if (null == rsResourceGinfo) {
            return;
        }
        if (null == rsResourceGinfo.getDataState()) {
            rsResourceGinfo.setDataState(0);
        }
        if (null == rsResourceGinfo.getGmtCreate()) {
            rsResourceGinfo.setGmtCreate(this.getSysDate());
        }
        rsResourceGinfo.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsResourceGinfo.getGinfoCode())) {
            rsResourceGinfo.setGinfoCode(this.createUUIDString());
        }
    }

    private int getResourceGinfoMaxCode() {
        int code = 0;
        try {
            return this.rsResourceGinfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.getResourceGinfoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setResourceGinfoUpdataDefault(RsResourceGinfo rsResourceGinfo) {
        if (null == rsResourceGinfo) {
            return;
        }
        rsResourceGinfo.setGmtModified(this.getSysDate());
    }

    private void saveResourceGinfoModel(RsResourceGinfo rsResourceGinfo) throws ApiException {
        if (null == rsResourceGinfo) {
            return;
        }
        try {
            this.rsResourceGinfoMapper.insert(rsResourceGinfo);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.saveResourceGinfoModel.ex", (Throwable)e);
        }
    }

    private RsResourceGinfo getResourceGinfoModelById(Integer ginfoId) {
        if (null == ginfoId) {
            return null;
        }
        try {
            return this.rsResourceGinfoMapper.selectByPrimaryKey(ginfoId);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.getResourceGinfoModelById", (Throwable)e);
            return null;
        }
    }

    public RsResourceGinfo getResourceGinfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsResourceGinfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.getResourceGinfoModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delResourceGinfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsResourceGinfoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.delResourceGinfoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.delResourceGinfoModelByCode.num");
        }
    }

    private void deleteResourceGinfoModel(Integer ginfoId) throws ApiException {
        if (null == ginfoId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsResourceGinfoMapper.deleteByPrimaryKey(ginfoId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.deleteResourceGinfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.deleteResourceGinfoModel.num");
        }
    }

    private void updateResourceGinfoModel(RsResourceGinfo rsResourceGinfo) throws ApiException {
        if (null == rsResourceGinfo) {
            return;
        }
        try {
            this.rsResourceGinfoMapper.updateByPrimaryKeySelective(rsResourceGinfo);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.updateResourceGinfoModel.ex", (Throwable)e);
        }
    }

    private void updateStateResourceGinfoModel(Integer ginfoId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == ginfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ginfoId", ginfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsResourceGinfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.updateStateResourceGinfoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.updateStateResourceGinfoModel.null");
        }
    }

    private RsResourceGinfo makeResourceGinfo(RsResourceGinfoDomain rsResourceGinfoDomain, RsResourceGinfo rsResourceGinfo) {
        if (null == rsResourceGinfoDomain) {
            return null;
        }
        if (null == rsResourceGinfo) {
            rsResourceGinfo = new RsResourceGinfo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsResourceGinfo, (Object)rsResourceGinfoDomain);
            return rsResourceGinfo;
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.makeResourceGinfo", (Throwable)e);
            return null;
        }
    }

    private List<RsResourceGinfo> queryResourceGinfoModelPage(Map<String, Object> parammap) {
        try {
            return this.rsResourceGinfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.queryResourceGinfoModel", (Throwable)e);
            return null;
        }
    }

    private int countResourceGinfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsResourceGinfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.countResourceGinfo", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveResourceGinfo(RsResourceGinfoDomain rsResourceGinfoDomain) throws ApiException {
        String msg = this.checkResourceGinfo(rsResourceGinfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.saveResourceGinfo.checkResourceGinfo", msg);
        }
        RsResourceGinfo rsResourceGinfo = this.makeResourceGinfo(rsResourceGinfoDomain, null);
        this.setResourceGinfoDefault(rsResourceGinfo);
        this.saveResourceGinfoModel(rsResourceGinfo);
        return rsResourceGinfo.getGinfoCode();
    }

    @Override
    public void updateResourceGinfoState(Integer ginfoId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateResourceGinfoModel(ginfoId, dataState, oldDataState);
    }

    @Override
    public void updateResourceGinfo(RsResourceGinfoDomain rsResourceGinfoDomain) throws ApiException {
        String msg = this.checkResourceGinfo(rsResourceGinfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.updateResourceGinfo.checkResourceGinfo", msg);
        }
        RsResourceGinfo oldRsResourceGinfo = this.getResourceGinfoModelById(rsResourceGinfoDomain.getGinfoId());
        if (null == oldRsResourceGinfo) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.updateResourceGinfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsResourceGinfo rsResourceGinfo = this.makeResourceGinfo(rsResourceGinfoDomain, oldRsResourceGinfo);
        this.setResourceGinfoUpdataDefault(rsResourceGinfo);
        this.updateResourceGinfoModel(rsResourceGinfo);
    }

    @Override
    public RsResourceGinfo getResourceGinfo(Integer ginfoId) {
        return this.getResourceGinfoModelById(ginfoId);
    }

    @Override
    public void deleteResourceGinfo(Integer ginfoId) throws ApiException {
        this.deleteResourceGinfoModel(ginfoId);
    }

    @Override
    public QueryResult<RsResourceGinfo> queryResourceGinfoPage(Map<String, Object> map) {
        List<RsResourceGinfo> rsResourceGinfoList = this.queryResourceGinfoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countResourceGinfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsResourceGinfoList);
        return queryResult;
    }

    @Override
    public RsResourceGinfo getResourceGinfoByCode(Map<String, Object> map) {
        return this.getResourceGinfoModelByCode(map);
    }

    @Override
    public void delResourceGinfoByCode(Map<String, Object> map) throws ApiException {
        this.delResourceGinfoModelByCode(map);
    }

    @Override
    public QueryResult<RsResourceGinfo> queryResourceGinfoByDateStatePage(Map<String, Object> map) {
        List<RsResourceGinfo> rsResourceGinfoList = this.queryResourceGinfoByDateStateList(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countByDataState(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsResourceGinfoList);
        return queryResult;
    }

    private List<RsResourceGinfo> queryResourceGinfoByDateStateList(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        try {
            return this.rsResourceGinfoMapper.queryByDataState(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.queryResourceGinfoByDateStateList.ex", (Throwable)e);
        }
    }

    @Override
    public List<Map<String, Object>> getResourceGinfoCountByDateState(Map<String, Object> map) {
        return this.countGroupByDataState(map);
    }

    private List<Map<String, Object>> countGroupByDataState(Map<String, Object> map) {
        try {
            return this.rsResourceGinfoMapper.countGroupByDataState(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.countResourceGinfo", (Throwable)e);
            return null;
        }
    }

    private int countByDataState(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsResourceGinfoMapper.countByDataState(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.countResourceGinfo", (Throwable)e);
        }
        return i;
    }

    @Override
    public void updateGinfoAnum(String ginfoCode, String tenantCode) {
        if (ginfoCode == null || tenantCode == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ginfoCode", ginfoCode);
        map.put("tenantCode", tenantCode);
        this.updateGinfoAnumByCode(map);
    }

    private int updateGinfoAnumByCode(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsResourceGinfoMapper.updateGinfoAnum(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RESOURCE_GOODS.RsResourceGinfoServiceImpl.updateGinfoAnumByID", (Throwable)e);
        }
        return i;
    }
}

