/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.route.matching.check;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.AppModelAppValue;
import com.yqbsoft.laser.service.route.matching.check.AbstractValueCheck;
import com.yqbsoft.laser.service.route.matching.util.AppModelContext;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;

public class BetweenValueCheck
extends AbstractValueCheck {
    private static final long serialVersionUID = 1289284838798173554L;
    private static final String sys_code = "ecore.ESB.CORE.BetweenValueCheck";

    @Override
    public boolean checkValue(Object inValue, AppModelContext appModelContext) throws ApiException {
        if (appModelContext == null) {
            throw new ApiException(sys_code, "objects length error");
        }
        if (appModelContext.getAppModelValue().getAppvalueList() == null || appModelContext.getAppModelValue().getAppvalueList().isEmpty()) {
            if (appModelContext.getModelValue() == null || appModelContext.getModelValue().length < 2) {
                throw new ApiException(sys_code, "objects length error");
            }
            return this.compareValue(inValue, appModelContext.getModelValue());
        }
        for (AppModelAppValue appModelAppValue : appModelContext.getAppModelValue().getAppvalueList()) {
            if (appModelAppValue == null || appModelAppValue.getParamValue() == null || appModelAppValue.getParamValue2() == null || !this.compareValue(inValue, appModelAppValue.getParamValue(), appModelAppValue.getParamValue2())) continue;
            appModelContext.getAppModelValue().setAppmanageIcode(appModelAppValue.getAppmanageIcode());
            appModelContext.getAppModelValue().setParamValue(appModelAppValue.getParamValue());
            appModelContext.getAppModelValue().setParamValue2(appModelAppValue.getParamValue2());
            return true;
        }
        return false;
    }

    private boolean compareValue(Object inValue, Object ... objects) {
        if (objects == null) {
            throw new ApiException(sys_code, "objects null");
        }
        try {
            Integer value = Integer.valueOf(inValue.toString());
            Integer checkValue1 = Integer.valueOf(objects[0].toString());
            Integer checkValue2 = Integer.valueOf(objects[1].toString());
            return value >= checkValue1 && value <= checkValue2;
        }
        catch (NumberFormatException e) {
            throw new ApiException(sys_code, "value type is not number");
        }
    }

    @Override
    public String getParamValue(Map<String, String> incomingMap, String paramName) {
        if (incomingMap == null || incomingMap.isEmpty() || StringUtils.isBlank((String)paramName)) {
            return null;
        }
        String[] ketStr = paramName.split("\\.");
        String vstr = "";
        Map valueMap = incomingMap;
        int i = 0;
        while (i < ketStr.length) {
            if (StringUtils.isNotBlank((String)vstr)) {
                valueMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(vstr, String.class, String.class);
            }
            if (valueMap == null) {
                return null;
            }
            vstr = (String)valueMap.get(ketStr[i]);
            ++i;
        }
        return vstr;
    }
}

