/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.fs.archive.zip.ZipArchiveEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.fs.archive.zip.ZipInputShop;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.InputSocket;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

@DefaultAnnotation(value={NonNull.class})
public class CheckedZipInputShop
extends ZipInputShop {
    public CheckedZipInputShop(ReadOnlyFile rof, ZipDriver driver) throws IOException {
        super(driver, rof);
    }

    @Override
    public InputSocket<ZipArchiveEntry> getInputSocket(final String name) {
        if (null == name) {
            throw new NullPointerException();
        }
        class Input
        extends InputSocket<ZipArchiveEntry> {
            Input() {
            }

            public ZipArchiveEntry getLocalTarget() throws IOException {
                ZipArchiveEntry entry = (ZipArchiveEntry)CheckedZipInputShop.this.getEntry(name);
                if (null == entry) {
                    throw new FileNotFoundException(name + " (entry not found)");
                }
                return entry;
            }

            public ReadOnlyFile newReadOnlyFile() throws IOException {
                throw new FileNotFoundException(name + " (unsupported operation)");
            }

            public InputStream newInputStream() throws IOException {
                return CheckedZipInputShop.this.getInputStream(this.getLocalTarget().getName(), true, !(this.getPeerTarget() instanceof ZipArchiveEntry));
            }
        }
        return new Input();
    }
}

