/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;

public class AeronClient
implements DriverManagedResource {
    private final long clientId;
    private final long clientLivenessTimeoutNs;
    private long timeOfLastKeepaliveNs;
    private boolean reachedEndOfLife = false;

    public AeronClient(long clientId, long clientLivenessTimeoutNs, long nowNs) {
        this.clientId = clientId;
        this.clientLivenessTimeoutNs = clientLivenessTimeoutNs;
        this.timeOfLastKeepaliveNs = nowNs;
    }

    public long clientId() {
        return this.clientId;
    }

    public long timeOfLastKeepalive() {
        return this.timeOfLastKeepaliveNs;
    }

    public void timeOfLastKeepalive(long nowNs) {
        this.timeOfLastKeepaliveNs = nowNs;
    }

    public boolean hasTimedOut(long nowNs) {
        return nowNs > this.timeOfLastKeepaliveNs + this.clientLivenessTimeoutNs;
    }

    @Override
    public void onTimeEvent(long timeNs, long timeMs, DriverConductor conductor) {
        if (timeNs > this.timeOfLastKeepaliveNs + this.clientLivenessTimeoutNs) {
            this.reachedEndOfLife = true;
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    public void timeOfLastStateChange(long timeNs) {
        this.timeOfLastKeepaliveNs = timeNs;
    }

    public long timeOfLastStateChange() {
        return this.timeOfLastKeepaliveNs;
    }

    public void delete() {
    }
}

