/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.AuthenticationSpec;
import io.fabric8.openshift.api.model.AuthenticationSpecFluent;
import io.fabric8.openshift.api.model.ConfigMapNameReference;
import io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.ConfigMapNameReferenceFluentImpl;
import io.fabric8.openshift.api.model.DeprecatedWebhookTokenAuthenticator;
import io.fabric8.openshift.api.model.DeprecatedWebhookTokenAuthenticatorBuilder;
import io.fabric8.openshift.api.model.DeprecatedWebhookTokenAuthenticatorFluentImpl;
import io.fabric8.openshift.api.model.WebhookTokenAuthenticator;
import io.fabric8.openshift.api.model.WebhookTokenAuthenticatorBuilder;
import io.fabric8.openshift.api.model.WebhookTokenAuthenticatorFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AuthenticationSpecFluentImpl<A extends AuthenticationSpecFluent<A>>
extends BaseFluent<A>
implements AuthenticationSpecFluent<A> {
    private ConfigMapNameReferenceBuilder oauthMetadata;
    private String serviceAccountIssuer;
    private String type;
    private WebhookTokenAuthenticatorBuilder webhookTokenAuthenticator;
    private List<DeprecatedWebhookTokenAuthenticatorBuilder> webhookTokenAuthenticators = new ArrayList<DeprecatedWebhookTokenAuthenticatorBuilder>();
    private Map<String, Object> additionalProperties;

    public AuthenticationSpecFluentImpl() {
    }

    public AuthenticationSpecFluentImpl(AuthenticationSpec instance) {
        this.withOauthMetadata(instance.getOauthMetadata());
        this.withServiceAccountIssuer(instance.getServiceAccountIssuer());
        this.withType(instance.getType());
        this.withWebhookTokenAuthenticator(instance.getWebhookTokenAuthenticator());
        this.withWebhookTokenAuthenticators(instance.getWebhookTokenAuthenticators());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public ConfigMapNameReference getOauthMetadata() {
        return this.oauthMetadata != null ? this.oauthMetadata.build() : null;
    }

    @Override
    public ConfigMapNameReference buildOauthMetadata() {
        return this.oauthMetadata != null ? this.oauthMetadata.build() : null;
    }

    @Override
    public A withOauthMetadata(ConfigMapNameReference oauthMetadata) {
        this._visitables.get((Object)"oauthMetadata").remove(this.oauthMetadata);
        if (oauthMetadata != null) {
            this.oauthMetadata = new ConfigMapNameReferenceBuilder(oauthMetadata);
            this._visitables.get((Object)"oauthMetadata").add(this.oauthMetadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOauthMetadata() {
        return this.oauthMetadata != null;
    }

    @Override
    public A withNewOauthMetadata(String name) {
        return this.withOauthMetadata(new ConfigMapNameReference(name));
    }

    @Override
    public AuthenticationSpecFluent.OauthMetadataNested<A> withNewOauthMetadata() {
        return new OauthMetadataNestedImpl();
    }

    @Override
    public AuthenticationSpecFluent.OauthMetadataNested<A> withNewOauthMetadataLike(ConfigMapNameReference item) {
        return new OauthMetadataNestedImpl(item);
    }

    @Override
    public AuthenticationSpecFluent.OauthMetadataNested<A> editOauthMetadata() {
        return this.withNewOauthMetadataLike(this.getOauthMetadata());
    }

    @Override
    public AuthenticationSpecFluent.OauthMetadataNested<A> editOrNewOauthMetadata() {
        return this.withNewOauthMetadataLike(this.getOauthMetadata() != null ? this.getOauthMetadata() : new ConfigMapNameReferenceBuilder().build());
    }

    @Override
    public AuthenticationSpecFluent.OauthMetadataNested<A> editOrNewOauthMetadataLike(ConfigMapNameReference item) {
        return this.withNewOauthMetadataLike(this.getOauthMetadata() != null ? this.getOauthMetadata() : item);
    }

    @Override
    public String getServiceAccountIssuer() {
        return this.serviceAccountIssuer;
    }

    @Override
    public A withServiceAccountIssuer(String serviceAccountIssuer) {
        this.serviceAccountIssuer = serviceAccountIssuer;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountIssuer() {
        return this.serviceAccountIssuer != null;
    }

    @Override
    @Deprecated
    public A withNewServiceAccountIssuer(String arg0) {
        return this.withServiceAccountIssuer(new String(arg0));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    @Deprecated
    public A withNewType(String arg0) {
        return this.withType(new String(arg0));
    }

    @Override
    @Deprecated
    public WebhookTokenAuthenticator getWebhookTokenAuthenticator() {
        return this.webhookTokenAuthenticator != null ? this.webhookTokenAuthenticator.build() : null;
    }

    @Override
    public WebhookTokenAuthenticator buildWebhookTokenAuthenticator() {
        return this.webhookTokenAuthenticator != null ? this.webhookTokenAuthenticator.build() : null;
    }

    @Override
    public A withWebhookTokenAuthenticator(WebhookTokenAuthenticator webhookTokenAuthenticator) {
        this._visitables.get((Object)"webhookTokenAuthenticator").remove(this.webhookTokenAuthenticator);
        if (webhookTokenAuthenticator != null) {
            this.webhookTokenAuthenticator = new WebhookTokenAuthenticatorBuilder(webhookTokenAuthenticator);
            this._visitables.get((Object)"webhookTokenAuthenticator").add(this.webhookTokenAuthenticator);
        }
        return (A)this;
    }

    @Override
    public Boolean hasWebhookTokenAuthenticator() {
        return this.webhookTokenAuthenticator != null;
    }

    @Override
    public AuthenticationSpecFluent.WebhookTokenAuthenticatorNested<A> withNewWebhookTokenAuthenticator() {
        return new WebhookTokenAuthenticatorNestedImpl();
    }

    @Override
    public AuthenticationSpecFluent.WebhookTokenAuthenticatorNested<A> withNewWebhookTokenAuthenticatorLike(WebhookTokenAuthenticator item) {
        return new WebhookTokenAuthenticatorNestedImpl(item);
    }

    @Override
    public AuthenticationSpecFluent.WebhookTokenAuthenticatorNested<A> editWebhookTokenAuthenticator() {
        return this.withNewWebhookTokenAuthenticatorLike(this.getWebhookTokenAuthenticator());
    }

    @Override
    public AuthenticationSpecFluent.WebhookTokenAuthenticatorNested<A> editOrNewWebhookTokenAuthenticator() {
        return this.withNewWebhookTokenAuthenticatorLike(this.getWebhookTokenAuthenticator() != null ? this.getWebhookTokenAuthenticator() : new WebhookTokenAuthenticatorBuilder().build());
    }

    @Override
    public AuthenticationSpecFluent.WebhookTokenAuthenticatorNested<A> editOrNewWebhookTokenAuthenticatorLike(WebhookTokenAuthenticator item) {
        return this.withNewWebhookTokenAuthenticatorLike(this.getWebhookTokenAuthenticator() != null ? this.getWebhookTokenAuthenticator() : item);
    }

    @Override
    public A addToWebhookTokenAuthenticators(Integer index, DeprecatedWebhookTokenAuthenticator item) {
        if (this.webhookTokenAuthenticators == null) {
            this.webhookTokenAuthenticators = new ArrayList<DeprecatedWebhookTokenAuthenticatorBuilder>();
        }
        DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
        this._visitables.get((Object)"webhookTokenAuthenticators").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"webhookTokenAuthenticators").size(), builder);
        this.webhookTokenAuthenticators.add(index >= 0 ? index.intValue() : this.webhookTokenAuthenticators.size(), builder);
        return (A)this;
    }

    @Override
    public A setToWebhookTokenAuthenticators(Integer index, DeprecatedWebhookTokenAuthenticator item) {
        if (this.webhookTokenAuthenticators == null) {
            this.webhookTokenAuthenticators = new ArrayList<DeprecatedWebhookTokenAuthenticatorBuilder>();
        }
        DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"webhookTokenAuthenticators").size()) {
            this._visitables.get((Object)"webhookTokenAuthenticators").add(builder);
        } else {
            this._visitables.get((Object)"webhookTokenAuthenticators").set(index, builder);
        }
        if (index < 0 || index >= this.webhookTokenAuthenticators.size()) {
            this.webhookTokenAuthenticators.add(builder);
        } else {
            this.webhookTokenAuthenticators.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToWebhookTokenAuthenticators(DeprecatedWebhookTokenAuthenticator ... items) {
        if (this.webhookTokenAuthenticators == null) {
            this.webhookTokenAuthenticators = new ArrayList<DeprecatedWebhookTokenAuthenticatorBuilder>();
        }
        for (DeprecatedWebhookTokenAuthenticator item : items) {
            DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
            this._visitables.get((Object)"webhookTokenAuthenticators").add(builder);
            this.webhookTokenAuthenticators.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToWebhookTokenAuthenticators(Collection<DeprecatedWebhookTokenAuthenticator> items) {
        if (this.webhookTokenAuthenticators == null) {
            this.webhookTokenAuthenticators = new ArrayList<DeprecatedWebhookTokenAuthenticatorBuilder>();
        }
        for (DeprecatedWebhookTokenAuthenticator item : items) {
            DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
            this._visitables.get((Object)"webhookTokenAuthenticators").add(builder);
            this.webhookTokenAuthenticators.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromWebhookTokenAuthenticators(DeprecatedWebhookTokenAuthenticator ... items) {
        for (DeprecatedWebhookTokenAuthenticator item : items) {
            DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
            this._visitables.get((Object)"webhookTokenAuthenticators").remove(builder);
            if (this.webhookTokenAuthenticators == null) continue;
            this.webhookTokenAuthenticators.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromWebhookTokenAuthenticators(Collection<DeprecatedWebhookTokenAuthenticator> items) {
        for (DeprecatedWebhookTokenAuthenticator item : items) {
            DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
            this._visitables.get((Object)"webhookTokenAuthenticators").remove(builder);
            if (this.webhookTokenAuthenticators == null) continue;
            this.webhookTokenAuthenticators.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromWebhookTokenAuthenticators(Predicate<DeprecatedWebhookTokenAuthenticatorBuilder> predicate) {
        if (this.webhookTokenAuthenticators == null) {
            return (A)this;
        }
        Iterator<DeprecatedWebhookTokenAuthenticatorBuilder> each = this.webhookTokenAuthenticators.iterator();
        List visitables = this._visitables.get((Object)"webhookTokenAuthenticators");
        while (each.hasNext()) {
            DeprecatedWebhookTokenAuthenticatorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DeprecatedWebhookTokenAuthenticator> getWebhookTokenAuthenticators() {
        return AuthenticationSpecFluentImpl.build(this.webhookTokenAuthenticators);
    }

    @Override
    public List<DeprecatedWebhookTokenAuthenticator> buildWebhookTokenAuthenticators() {
        return AuthenticationSpecFluentImpl.build(this.webhookTokenAuthenticators);
    }

    @Override
    public DeprecatedWebhookTokenAuthenticator buildWebhookTokenAuthenticator(Integer index) {
        return this.webhookTokenAuthenticators.get(index).build();
    }

    @Override
    public DeprecatedWebhookTokenAuthenticator buildFirstWebhookTokenAuthenticator() {
        return this.webhookTokenAuthenticators.get(0).build();
    }

    @Override
    public DeprecatedWebhookTokenAuthenticator buildLastWebhookTokenAuthenticator() {
        return this.webhookTokenAuthenticators.get(this.webhookTokenAuthenticators.size() - 1).build();
    }

    @Override
    public DeprecatedWebhookTokenAuthenticator buildMatchingWebhookTokenAuthenticator(Predicate<DeprecatedWebhookTokenAuthenticatorBuilder> predicate) {
        for (DeprecatedWebhookTokenAuthenticatorBuilder item : this.webhookTokenAuthenticators) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingWebhookTokenAuthenticator(Predicate<DeprecatedWebhookTokenAuthenticatorBuilder> predicate) {
        for (DeprecatedWebhookTokenAuthenticatorBuilder item : this.webhookTokenAuthenticators) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withWebhookTokenAuthenticators(List<DeprecatedWebhookTokenAuthenticator> webhookTokenAuthenticators) {
        if (this.webhookTokenAuthenticators != null) {
            this._visitables.get((Object)"webhookTokenAuthenticators").removeAll(this.webhookTokenAuthenticators);
        }
        if (webhookTokenAuthenticators != null) {
            this.webhookTokenAuthenticators = new ArrayList<DeprecatedWebhookTokenAuthenticatorBuilder>();
            for (DeprecatedWebhookTokenAuthenticator item : webhookTokenAuthenticators) {
                this.addToWebhookTokenAuthenticators(item);
            }
        } else {
            this.webhookTokenAuthenticators = null;
        }
        return (A)this;
    }

    @Override
    public A withWebhookTokenAuthenticators(DeprecatedWebhookTokenAuthenticator ... webhookTokenAuthenticators) {
        if (this.webhookTokenAuthenticators != null) {
            this.webhookTokenAuthenticators.clear();
        }
        if (webhookTokenAuthenticators != null) {
            for (DeprecatedWebhookTokenAuthenticator item : webhookTokenAuthenticators) {
                this.addToWebhookTokenAuthenticators(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasWebhookTokenAuthenticators() {
        return this.webhookTokenAuthenticators != null && !this.webhookTokenAuthenticators.isEmpty();
    }

    @Override
    public AuthenticationSpecFluent.WebhookTokenAuthenticatorsNested<A> addNewWebhookTokenAuthenticator() {
        return new WebhookTokenAuthenticatorsNestedImpl();
    }

    @Override
    public AuthenticationSpecFluent.WebhookTokenAuthenticatorsNested<A> addNewWebhookTokenAuthenticatorLike(DeprecatedWebhookTokenAuthenticator item) {
        return new WebhookTokenAuthenticatorsNestedImpl(-1, item);
    }

    @Override
    public AuthenticationSpecFluent.WebhookTokenAuthenticatorsNested<A> setNewWebhookTokenAuthenticatorLike(Integer index, DeprecatedWebhookTokenAuthenticator item) {
        return new WebhookTokenAuthenticatorsNestedImpl(index, item);
    }

    @Override
    public AuthenticationSpecFluent.WebhookTokenAuthenticatorsNested<A> editWebhookTokenAuthenticator(Integer index) {
        if (this.webhookTokenAuthenticators.size() <= index) {
            throw new RuntimeException("Can't edit webhookTokenAuthenticators. Index exceeds size.");
        }
        return this.setNewWebhookTokenAuthenticatorLike(index, this.buildWebhookTokenAuthenticator(index));
    }

    @Override
    public AuthenticationSpecFluent.WebhookTokenAuthenticatorsNested<A> editFirstWebhookTokenAuthenticator() {
        if (this.webhookTokenAuthenticators.size() == 0) {
            throw new RuntimeException("Can't edit first webhookTokenAuthenticators. The list is empty.");
        }
        return this.setNewWebhookTokenAuthenticatorLike(0, this.buildWebhookTokenAuthenticator(0));
    }

    @Override
    public AuthenticationSpecFluent.WebhookTokenAuthenticatorsNested<A> editLastWebhookTokenAuthenticator() {
        int index = this.webhookTokenAuthenticators.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last webhookTokenAuthenticators. The list is empty.");
        }
        return this.setNewWebhookTokenAuthenticatorLike(index, this.buildWebhookTokenAuthenticator(index));
    }

    @Override
    public AuthenticationSpecFluent.WebhookTokenAuthenticatorsNested<A> editMatchingWebhookTokenAuthenticator(Predicate<DeprecatedWebhookTokenAuthenticatorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.webhookTokenAuthenticators.size(); ++i) {
            if (!predicate.test(this.webhookTokenAuthenticators.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching webhookTokenAuthenticators. No match found.");
        }
        return this.setNewWebhookTokenAuthenticatorLike(index, this.buildWebhookTokenAuthenticator(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationSpecFluentImpl that = (AuthenticationSpecFluentImpl)o;
        if (this.oauthMetadata != null ? !this.oauthMetadata.equals(that.oauthMetadata) : that.oauthMetadata != null) {
            return false;
        }
        if (this.serviceAccountIssuer != null ? !this.serviceAccountIssuer.equals(that.serviceAccountIssuer) : that.serviceAccountIssuer != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.webhookTokenAuthenticator != null ? !this.webhookTokenAuthenticator.equals(that.webhookTokenAuthenticator) : that.webhookTokenAuthenticator != null) {
            return false;
        }
        if (this.webhookTokenAuthenticators != null ? !this.webhookTokenAuthenticators.equals(that.webhookTokenAuthenticators) : that.webhookTokenAuthenticators != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.oauthMetadata, this.serviceAccountIssuer, this.type, this.webhookTokenAuthenticator, this.webhookTokenAuthenticators, this.additionalProperties, super.hashCode());
    }

    public class WebhookTokenAuthenticatorsNestedImpl<N>
    extends DeprecatedWebhookTokenAuthenticatorFluentImpl<AuthenticationSpecFluent.WebhookTokenAuthenticatorsNested<N>>
    implements AuthenticationSpecFluent.WebhookTokenAuthenticatorsNested<N>,
    Nested<N> {
        DeprecatedWebhookTokenAuthenticatorBuilder builder;
        Integer index;

        WebhookTokenAuthenticatorsNestedImpl(Integer index, DeprecatedWebhookTokenAuthenticator item) {
            this.index = index;
            this.builder = new DeprecatedWebhookTokenAuthenticatorBuilder(this, item);
        }

        WebhookTokenAuthenticatorsNestedImpl() {
            this.index = -1;
            this.builder = new DeprecatedWebhookTokenAuthenticatorBuilder(this);
        }

        @Override
        public N and() {
            return (N)AuthenticationSpecFluentImpl.this.setToWebhookTokenAuthenticators(this.index, this.builder.build());
        }

        @Override
        public N endWebhookTokenAuthenticator() {
            return this.and();
        }
    }

    public class WebhookTokenAuthenticatorNestedImpl<N>
    extends WebhookTokenAuthenticatorFluentImpl<AuthenticationSpecFluent.WebhookTokenAuthenticatorNested<N>>
    implements AuthenticationSpecFluent.WebhookTokenAuthenticatorNested<N>,
    Nested<N> {
        WebhookTokenAuthenticatorBuilder builder;

        WebhookTokenAuthenticatorNestedImpl(WebhookTokenAuthenticator item) {
            this.builder = new WebhookTokenAuthenticatorBuilder(this, item);
        }

        WebhookTokenAuthenticatorNestedImpl() {
            this.builder = new WebhookTokenAuthenticatorBuilder(this);
        }

        @Override
        public N and() {
            return (N)AuthenticationSpecFluentImpl.this.withWebhookTokenAuthenticator(this.builder.build());
        }

        @Override
        public N endWebhookTokenAuthenticator() {
            return this.and();
        }
    }

    public class OauthMetadataNestedImpl<N>
    extends ConfigMapNameReferenceFluentImpl<AuthenticationSpecFluent.OauthMetadataNested<N>>
    implements AuthenticationSpecFluent.OauthMetadataNested<N>,
    Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        OauthMetadataNestedImpl(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        OauthMetadataNestedImpl() {
            this.builder = new ConfigMapNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)AuthenticationSpecFluentImpl.this.withOauthMetadata(this.builder.build());
        }

        @Override
        public N endOauthMetadata() {
            return this.and();
        }
    }
}

