/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.starter.configuration;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="mzt.log.record")
public class LogRecordProperties {
    private final String FIELD_PLACEHOLDER = "__fieldName";
    private final String SOURCE_VALUE_PLACEHOLDER = "__sourceValue";
    private final String TARGET_VALUE_PLACEHOLDER = "__targetValue";
    private final String LIST_ADD_VALUE_PLACEHOLDER = "__addValues";
    private final String LIST_DEL_VALUE_PLACEHOLDER = "__delValues";
    private String addTemplate = "\u3010__fieldName\u3011\u4ece\u3010\u7a7a\u3011\u4fee\u6539\u4e3a\u3010__targetValue\u3011";
    private String addTemplateForList = "\u3010__fieldName\u3011\u6dfb\u52a0\u4e86\u3010__addValues\u3011";
    private String deleteTemplateForList = "\u3010__fieldName\u3011\u5220\u9664\u4e86\u3010__delValues\u3011";
    private String updateTemplateForList = "\u3010__fieldName\u3011\u6dfb\u52a0\u4e86\u3010__addValues\u3011\u5220\u9664\u4e86\u3010__delValues\u3011";
    private String updateTemplate = "\u3010__fieldName\u3011\u4ece\u3010__sourceValue\u3011\u4fee\u6539\u4e3a\u3010__targetValue\u3011";
    private String deleteTemplate = "\u5220\u9664\u4e86\u3010__fieldName\u3011\uff1a\u3010__sourceValue\u3011";
    private String fieldSeparator = "\uff1b";
    private String listItemSeparator = "\uff0c";
    private String ofWord = "\u7684";
    private Boolean diffLog = false;
    private String useEqualsMethod;

    public void setAddTemplate(String template) {
        this.validatePlaceHolder(template);
        this.addTemplate = template;
    }

    public void setUpdateTemplate(String template) {
        this.validatePlaceHolder(template);
        this.updateTemplate = template;
    }

    public void setDeleteTemplate(String template) {
        this.validatePlaceHolder(template);
        this.deleteTemplate = template;
    }

    private void validatePlaceHolder(String template) {
        if (!(template.contains("__fieldName") || template.contains("__sourceValue") || template.contains("__targetValue"))) {
            throw new IllegalArgumentException("\u8bf7\u68c0\u67e5 logRecord template, \u6a21\u677f\u9700\u8981\u914d\u7f6e {{#fieldName}},{{#sourceValue}},{{#targetValue}} \u4e09\u4e2a\u53d8\u91cf\u4e2d\u7684\u4efb\u4f55\u4e00\u4e2a");
        }
    }

    public String formatAdd(String fieldName, Object targetValue) {
        return this.addTemplate.replace("__fieldName", fieldName).replace("__targetValue", String.valueOf(targetValue));
    }

    public String formatUpdate(String fieldName, Object sourceValue, Object targetValue) {
        return this.updateTemplate.replace("__fieldName", fieldName).replace("__sourceValue", String.valueOf(sourceValue)).replace("__targetValue", String.valueOf(targetValue));
    }

    public String formatDeleted(String fieldName, Object sourceValue) {
        return this.deleteTemplate.replace("__fieldName", fieldName).replace("__sourceValue", String.valueOf(sourceValue));
    }

    public String formatList(String fieldName, String addContent, String delContent) {
        if (!StringUtils.isEmpty((Object)addContent) && StringUtils.isEmpty((Object)delContent)) {
            return this.addTemplateForList.replace("__fieldName", fieldName).replace("__addValues", addContent);
        }
        if (StringUtils.isEmpty((Object)addContent) && !StringUtils.isEmpty((Object)delContent)) {
            return this.deleteTemplateForList.replace("__fieldName", fieldName).replace("__delValues", delContent);
        }
        if (!StringUtils.isEmpty((Object)addContent) && !StringUtils.isEmpty((Object)delContent)) {
            return this.updateTemplateForList.replace("__fieldName", fieldName).replace("__addValues", addContent).replace("__delValues", delContent);
        }
        return "";
    }

    public String getFIELD_PLACEHOLDER() {
        return this.FIELD_PLACEHOLDER;
    }

    public String getSOURCE_VALUE_PLACEHOLDER() {
        return this.SOURCE_VALUE_PLACEHOLDER;
    }

    public String getTARGET_VALUE_PLACEHOLDER() {
        return this.TARGET_VALUE_PLACEHOLDER;
    }

    public String getLIST_ADD_VALUE_PLACEHOLDER() {
        return this.LIST_ADD_VALUE_PLACEHOLDER;
    }

    public String getLIST_DEL_VALUE_PLACEHOLDER() {
        return this.LIST_DEL_VALUE_PLACEHOLDER;
    }

    public String getAddTemplate() {
        return this.addTemplate;
    }

    public String getAddTemplateForList() {
        return this.addTemplateForList;
    }

    public String getDeleteTemplateForList() {
        return this.deleteTemplateForList;
    }

    public String getUpdateTemplateForList() {
        return this.updateTemplateForList;
    }

    public String getUpdateTemplate() {
        return this.updateTemplate;
    }

    public String getDeleteTemplate() {
        return this.deleteTemplate;
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public String getListItemSeparator() {
        return this.listItemSeparator;
    }

    public String getOfWord() {
        return this.ofWord;
    }

    public Boolean getDiffLog() {
        return this.diffLog;
    }

    public String getUseEqualsMethod() {
        return this.useEqualsMethod;
    }

    public void setAddTemplateForList(String addTemplateForList) {
        this.addTemplateForList = addTemplateForList;
    }

    public void setDeleteTemplateForList(String deleteTemplateForList) {
        this.deleteTemplateForList = deleteTemplateForList;
    }

    public void setUpdateTemplateForList(String updateTemplateForList) {
        this.updateTemplateForList = updateTemplateForList;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public void setListItemSeparator(String listItemSeparator) {
        this.listItemSeparator = listItemSeparator;
    }

    public void setOfWord(String ofWord) {
        this.ofWord = ofWord;
    }

    public void setDiffLog(Boolean diffLog) {
        this.diffLog = diffLog;
    }

    public void setUseEqualsMethod(String useEqualsMethod) {
        this.useEqualsMethod = useEqualsMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogRecordProperties)) {
            return false;
        }
        LogRecordProperties other = (LogRecordProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$FIELD_PLACEHOLDER = this.getFIELD_PLACEHOLDER();
        String other$FIELD_PLACEHOLDER = other.getFIELD_PLACEHOLDER();
        if (this$FIELD_PLACEHOLDER == null ? other$FIELD_PLACEHOLDER != null : !this$FIELD_PLACEHOLDER.equals(other$FIELD_PLACEHOLDER)) {
            return false;
        }
        String this$SOURCE_VALUE_PLACEHOLDER = this.getSOURCE_VALUE_PLACEHOLDER();
        String other$SOURCE_VALUE_PLACEHOLDER = other.getSOURCE_VALUE_PLACEHOLDER();
        if (this$SOURCE_VALUE_PLACEHOLDER == null ? other$SOURCE_VALUE_PLACEHOLDER != null : !this$SOURCE_VALUE_PLACEHOLDER.equals(other$SOURCE_VALUE_PLACEHOLDER)) {
            return false;
        }
        String this$TARGET_VALUE_PLACEHOLDER = this.getTARGET_VALUE_PLACEHOLDER();
        String other$TARGET_VALUE_PLACEHOLDER = other.getTARGET_VALUE_PLACEHOLDER();
        if (this$TARGET_VALUE_PLACEHOLDER == null ? other$TARGET_VALUE_PLACEHOLDER != null : !this$TARGET_VALUE_PLACEHOLDER.equals(other$TARGET_VALUE_PLACEHOLDER)) {
            return false;
        }
        String this$LIST_ADD_VALUE_PLACEHOLDER = this.getLIST_ADD_VALUE_PLACEHOLDER();
        String other$LIST_ADD_VALUE_PLACEHOLDER = other.getLIST_ADD_VALUE_PLACEHOLDER();
        if (this$LIST_ADD_VALUE_PLACEHOLDER == null ? other$LIST_ADD_VALUE_PLACEHOLDER != null : !this$LIST_ADD_VALUE_PLACEHOLDER.equals(other$LIST_ADD_VALUE_PLACEHOLDER)) {
            return false;
        }
        String this$LIST_DEL_VALUE_PLACEHOLDER = this.getLIST_DEL_VALUE_PLACEHOLDER();
        String other$LIST_DEL_VALUE_PLACEHOLDER = other.getLIST_DEL_VALUE_PLACEHOLDER();
        if (this$LIST_DEL_VALUE_PLACEHOLDER == null ? other$LIST_DEL_VALUE_PLACEHOLDER != null : !this$LIST_DEL_VALUE_PLACEHOLDER.equals(other$LIST_DEL_VALUE_PLACEHOLDER)) {
            return false;
        }
        String this$addTemplate = this.getAddTemplate();
        String other$addTemplate = other.getAddTemplate();
        if (this$addTemplate == null ? other$addTemplate != null : !this$addTemplate.equals(other$addTemplate)) {
            return false;
        }
        String this$addTemplateForList = this.getAddTemplateForList();
        String other$addTemplateForList = other.getAddTemplateForList();
        if (this$addTemplateForList == null ? other$addTemplateForList != null : !this$addTemplateForList.equals(other$addTemplateForList)) {
            return false;
        }
        String this$deleteTemplateForList = this.getDeleteTemplateForList();
        String other$deleteTemplateForList = other.getDeleteTemplateForList();
        if (this$deleteTemplateForList == null ? other$deleteTemplateForList != null : !this$deleteTemplateForList.equals(other$deleteTemplateForList)) {
            return false;
        }
        String this$updateTemplateForList = this.getUpdateTemplateForList();
        String other$updateTemplateForList = other.getUpdateTemplateForList();
        if (this$updateTemplateForList == null ? other$updateTemplateForList != null : !this$updateTemplateForList.equals(other$updateTemplateForList)) {
            return false;
        }
        String this$updateTemplate = this.getUpdateTemplate();
        String other$updateTemplate = other.getUpdateTemplate();
        if (this$updateTemplate == null ? other$updateTemplate != null : !this$updateTemplate.equals(other$updateTemplate)) {
            return false;
        }
        String this$deleteTemplate = this.getDeleteTemplate();
        String other$deleteTemplate = other.getDeleteTemplate();
        if (this$deleteTemplate == null ? other$deleteTemplate != null : !this$deleteTemplate.equals(other$deleteTemplate)) {
            return false;
        }
        String this$fieldSeparator = this.getFieldSeparator();
        String other$fieldSeparator = other.getFieldSeparator();
        if (this$fieldSeparator == null ? other$fieldSeparator != null : !this$fieldSeparator.equals(other$fieldSeparator)) {
            return false;
        }
        String this$listItemSeparator = this.getListItemSeparator();
        String other$listItemSeparator = other.getListItemSeparator();
        if (this$listItemSeparator == null ? other$listItemSeparator != null : !this$listItemSeparator.equals(other$listItemSeparator)) {
            return false;
        }
        String this$ofWord = this.getOfWord();
        String other$ofWord = other.getOfWord();
        if (this$ofWord == null ? other$ofWord != null : !this$ofWord.equals(other$ofWord)) {
            return false;
        }
        Boolean this$diffLog = this.getDiffLog();
        Boolean other$diffLog = other.getDiffLog();
        if (this$diffLog == null ? other$diffLog != null : !((Object)this$diffLog).equals(other$diffLog)) {
            return false;
        }
        String this$useEqualsMethod = this.getUseEqualsMethod();
        String other$useEqualsMethod = other.getUseEqualsMethod();
        return !(this$useEqualsMethod == null ? other$useEqualsMethod != null : !this$useEqualsMethod.equals(other$useEqualsMethod));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogRecordProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $FIELD_PLACEHOLDER = this.getFIELD_PLACEHOLDER();
        result = result * 59 + ($FIELD_PLACEHOLDER == null ? 43 : $FIELD_PLACEHOLDER.hashCode());
        String $SOURCE_VALUE_PLACEHOLDER = this.getSOURCE_VALUE_PLACEHOLDER();
        result = result * 59 + ($SOURCE_VALUE_PLACEHOLDER == null ? 43 : $SOURCE_VALUE_PLACEHOLDER.hashCode());
        String $TARGET_VALUE_PLACEHOLDER = this.getTARGET_VALUE_PLACEHOLDER();
        result = result * 59 + ($TARGET_VALUE_PLACEHOLDER == null ? 43 : $TARGET_VALUE_PLACEHOLDER.hashCode());
        String $LIST_ADD_VALUE_PLACEHOLDER = this.getLIST_ADD_VALUE_PLACEHOLDER();
        result = result * 59 + ($LIST_ADD_VALUE_PLACEHOLDER == null ? 43 : $LIST_ADD_VALUE_PLACEHOLDER.hashCode());
        String $LIST_DEL_VALUE_PLACEHOLDER = this.getLIST_DEL_VALUE_PLACEHOLDER();
        result = result * 59 + ($LIST_DEL_VALUE_PLACEHOLDER == null ? 43 : $LIST_DEL_VALUE_PLACEHOLDER.hashCode());
        String $addTemplate = this.getAddTemplate();
        result = result * 59 + ($addTemplate == null ? 43 : $addTemplate.hashCode());
        String $addTemplateForList = this.getAddTemplateForList();
        result = result * 59 + ($addTemplateForList == null ? 43 : $addTemplateForList.hashCode());
        String $deleteTemplateForList = this.getDeleteTemplateForList();
        result = result * 59 + ($deleteTemplateForList == null ? 43 : $deleteTemplateForList.hashCode());
        String $updateTemplateForList = this.getUpdateTemplateForList();
        result = result * 59 + ($updateTemplateForList == null ? 43 : $updateTemplateForList.hashCode());
        String $updateTemplate = this.getUpdateTemplate();
        result = result * 59 + ($updateTemplate == null ? 43 : $updateTemplate.hashCode());
        String $deleteTemplate = this.getDeleteTemplate();
        result = result * 59 + ($deleteTemplate == null ? 43 : $deleteTemplate.hashCode());
        String $fieldSeparator = this.getFieldSeparator();
        result = result * 59 + ($fieldSeparator == null ? 43 : $fieldSeparator.hashCode());
        String $listItemSeparator = this.getListItemSeparator();
        result = result * 59 + ($listItemSeparator == null ? 43 : $listItemSeparator.hashCode());
        String $ofWord = this.getOfWord();
        result = result * 59 + ($ofWord == null ? 43 : $ofWord.hashCode());
        Boolean $diffLog = this.getDiffLog();
        result = result * 59 + ($diffLog == null ? 43 : ((Object)$diffLog).hashCode());
        String $useEqualsMethod = this.getUseEqualsMethod();
        result = result * 59 + ($useEqualsMethod == null ? 43 : $useEqualsMethod.hashCode());
        return result;
    }

    public String toString() {
        return "LogRecordProperties(FIELD_PLACEHOLDER=" + this.getFIELD_PLACEHOLDER() + ", SOURCE_VALUE_PLACEHOLDER=" + this.getSOURCE_VALUE_PLACEHOLDER() + ", TARGET_VALUE_PLACEHOLDER=" + this.getTARGET_VALUE_PLACEHOLDER() + ", LIST_ADD_VALUE_PLACEHOLDER=" + this.getLIST_ADD_VALUE_PLACEHOLDER() + ", LIST_DEL_VALUE_PLACEHOLDER=" + this.getLIST_DEL_VALUE_PLACEHOLDER() + ", addTemplate=" + this.getAddTemplate() + ", addTemplateForList=" + this.getAddTemplateForList() + ", deleteTemplateForList=" + this.getDeleteTemplateForList() + ", updateTemplateForList=" + this.getUpdateTemplateForList() + ", updateTemplate=" + this.getUpdateTemplate() + ", deleteTemplate=" + this.getDeleteTemplate() + ", fieldSeparator=" + this.getFieldSeparator() + ", listItemSeparator=" + this.getListItemSeparator() + ", ofWord=" + this.getOfWord() + ", diffLog=" + this.getDiffLog() + ", useEqualsMethod=" + this.getUseEqualsMethod() + ")";
    }
}

