/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.starter.support.aop;

import com.mzt.logapi.beans.LogRecordOps;
import com.mzt.logapi.starter.annotation.LogRecord;
import com.mzt.logapi.starter.annotation.LogRecords;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

public class LogRecordOperationSource {
    private static final Map<Method, Method> INTERFACE_METHOD_CACHE = new ConcurrentReferenceHashMap(256);

    public Collection<LogRecordOps> computeLogRecordOperations(Method method, Class<?> targetClass) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return Collections.emptyList();
        }
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, targetClass);
        specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
        Collection<LogRecordOps> logRecordOps = this.parseLogRecordAnnotations(specificMethod);
        Collection<LogRecordOps> logRecordsOps = this.parseLogRecordsAnnotations(specificMethod);
        Collection<LogRecordOps> abstractLogRecordOps = this.parseLogRecordAnnotations(LogRecordOperationSource.getInterfaceMethodIfPossible(method));
        Collection<LogRecordOps> abstractLogRecordsOps = this.parseLogRecordsAnnotations(LogRecordOperationSource.getInterfaceMethodIfPossible(method));
        HashSet<LogRecordOps> result = new HashSet<LogRecordOps>();
        result.addAll(logRecordOps);
        result.addAll(abstractLogRecordOps);
        result.addAll(logRecordsOps);
        result.addAll(abstractLogRecordsOps);
        return result;
    }

    public static Method getInterfaceMethodIfPossible(Method method) {
        if (!Modifier.isPublic(method.getModifiers()) || method.getDeclaringClass().isInterface()) {
            return method;
        }
        return INTERFACE_METHOD_CACHE.computeIfAbsent(method, key -> {
            for (Class<?> current = key.getDeclaringClass(); current != null && current != Object.class; current = current.getSuperclass()) {
                Class<?>[] ifcs;
                for (Class<?> ifc : ifcs = current.getInterfaces()) {
                    try {
                        return ifc.getMethod(key.getName(), key.getParameterTypes());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            return key;
        });
    }

    private Collection<LogRecordOps> parseLogRecordsAnnotations(AnnotatedElement ae) {
        ArrayList<LogRecordOps> res = new ArrayList<LogRecordOps>();
        Set logRecordAnnotationAnnotations = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)ae, LogRecords.class);
        if (!logRecordAnnotationAnnotations.isEmpty()) {
            logRecordAnnotationAnnotations.forEach(logRecords -> {
                LogRecord[] value;
                for (LogRecord logRecord : value = logRecords.value()) {
                    res.add(this.parseLogRecordAnnotation(ae, logRecord));
                }
            });
        }
        return res;
    }

    private Collection<LogRecordOps> parseLogRecordAnnotations(AnnotatedElement ae) {
        Set logRecordAnnotationAnnotations = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)ae, LogRecord.class);
        ArrayList<LogRecordOps> ret = new ArrayList<LogRecordOps>();
        if (!logRecordAnnotationAnnotations.isEmpty()) {
            for (LogRecord recordAnnotation : logRecordAnnotationAnnotations) {
                ret.add(this.parseLogRecordAnnotation(ae, recordAnnotation));
            }
        }
        return ret;
    }

    private LogRecordOps parseLogRecordAnnotation(AnnotatedElement ae, LogRecord recordAnnotation) {
        LogRecordOps recordOps = LogRecordOps.builder().successLogTemplate(recordAnnotation.success()).failLogTemplate(recordAnnotation.fail()).type(recordAnnotation.type()).bizNo(recordAnnotation.bizNo()).operatorId(recordAnnotation.operator()).subType(recordAnnotation.subType()).extra(recordAnnotation.extra()).condition(recordAnnotation.condition()).isSuccess(recordAnnotation.successCondition()).build();
        this.validateLogRecordOperation(ae, recordOps);
        return recordOps;
    }

    private void validateLogRecordOperation(AnnotatedElement ae, LogRecordOps recordOps) {
        if (!StringUtils.hasText((String)recordOps.getSuccessLogTemplate()) && !StringUtils.hasText((String)recordOps.getFailLogTemplate())) {
            throw new IllegalStateException("Invalid logRecord annotation configuration on '" + ae.toString() + "'. 'one of successTemplate and failLogTemplate' attribute must be set.");
        }
    }
}

