/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.internal.LettuceFactories;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.publisher.Hooks;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

class Operators {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(Operators.class);
    private static final String KEY_ON_OPERATOR_ERROR = "reactor.onOperatorError.local";
    private static final Field onOperatorErrorHook = Operators.findOnOperatorErrorHookField();
    private static final Supplier<Queue<Object>> queueSupplier = Operators.getQueueSupplier();

    Operators() {
    }

    private static Field findOnOperatorErrorHookField() {
        try {
            return AccessController.doPrivileged(() -> {
                Field field = Hooks.class.getDeclaredField("onOperatorErrorHook");
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field;
            });
        }
        catch (PrivilegedActionException e) {
            return null;
        }
    }

    private static Supplier<Queue<Object>> getQueueSupplier() {
        try {
            return AccessController.doPrivileged(() -> {
                Method unbounded = Queues.class.getMethod("unbounded", new Class[0]);
                return (Supplier)unbounded.invoke(Queues.class, new Object[0]);
            });
        }
        catch (PrivilegedActionException e) {
            return LettuceFactories::newSpScQueue;
        }
    }

    static long addCap(long a, long b) {
        long res = a + b;
        if (res < 0L) {
            return Long.MAX_VALUE;
        }
        return res;
    }

    public static <T> boolean request(AtomicLongFieldUpdater<T> updater, T instance, long toAdd) {
        if (Operators.validate(toAdd)) {
            Operators.addCap(updater, instance, toAdd);
            return true;
        }
        return false;
    }

    static <T> long addCap(AtomicLongFieldUpdater<T> updater, T instance, long toAdd) {
        long u;
        long r;
        do {
            if ((r = updater.get(instance)) != Long.MAX_VALUE) continue;
            return Long.MAX_VALUE;
        } while (!updater.compareAndSet(instance, r, u = Operators.addCap(r, toAdd)));
        return r;
    }

    static boolean validate(long n) {
        if (n <= 0L) {
            Operators.reportBadRequest(n);
            return false;
        }
        return true;
    }

    static void reportBadRequest(long n) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Negative request", (Throwable)Exceptions.nullOrNegativeRequestException((long)n));
        }
    }

    static IllegalArgumentException nullOrNegativeRequestException(long elements) {
        return new IllegalArgumentException("Spec. Rule 3.9 - Cannot request a non strictly positive number: " + elements);
    }

    static Throwable onOperatorError(@Nullable Subscription subscription, Throwable error, @Nullable Object dataSignal, Context context) {
        Exceptions.throwIfFatal((Throwable)error);
        if (subscription != null) {
            subscription.cancel();
        }
        Throwable t = Exceptions.unwrap((Throwable)error);
        BiFunction<? super Throwable, Object, ? extends Throwable> hook = (BiFunction<? super Throwable, Object, ? extends Throwable>)context.getOrDefault((Object)KEY_ON_OPERATOR_ERROR, null);
        if (hook == null && onOperatorErrorHook != null) {
            hook = Operators.getOnOperatorErrorHook();
        }
        if (hook == null) {
            if (dataSignal != null && dataSignal != t && dataSignal instanceof Throwable) {
                t = Exceptions.addSuppressed((Throwable)t, (Throwable)((Throwable)dataSignal));
            }
            return t;
        }
        return hook.apply(error, dataSignal);
    }

    static <T> Queue<T> newQueue() {
        return queueSupplier.get();
    }

    private static BiFunction<? super Throwable, Object, ? extends Throwable> getOnOperatorErrorHook() {
        try {
            return (BiFunction)onOperatorErrorHook.get(Hooks.class);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }
}

