/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.JetStreamApiException;
import io.nats.client.Message;
import io.nats.client.api.Error;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;
import java.nio.charset.StandardCharsets;

public abstract class ApiResponse<T> {
    public static final String NO_TYPE = "io.nats.jetstream.api.v1.no_type";
    protected final String json;
    private String type;
    private Error error;

    public ApiResponse(Message msg) {
        this(new String(msg.getData(), StandardCharsets.UTF_8));
    }

    public ApiResponse(String json) {
        this.json = json;
        this.error = Error.optionalInstance(json);
    }

    public ApiResponse() {
        this.json = null;
    }

    public T throwOnHasError() throws JetStreamApiException {
        if (this.hasError()) {
            throw new JetStreamApiException(this);
        }
        return (T)this;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String getType() {
        if (this.type == null) {
            this.type = JsonUtils.readString(this.json, ApiConstants.TYPE_RE, NO_TYPE);
        }
        return this.type;
    }

    public int getErrorCode() {
        return this.error == null ? -1 : this.error.getCode();
    }

    public int getApiErrorCode() {
        return this.error == null ? -1 : this.error.getApiErrorCode();
    }

    public String getDescription() {
        return this.error == null ? null : this.error.getDescription();
    }

    public String getError() {
        if (this.hasError()) {
            return this.error.toString();
        }
        return null;
    }
}

