/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.client.AbstractClientBuilder;
import io.reactivex.netty.client.ClientChannelFactory;
import io.reactivex.netty.client.ClientChannelFactoryImpl;
import io.reactivex.netty.client.ClientConnectionFactory;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.client.ConnectionPoolBuilder;
import io.reactivex.netty.client.PoolLimitDeterminationStrategy;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.client.UnpooledClientConnectionFactory;
import io.reactivex.netty.metrics.MetricEventsListener;
import io.reactivex.netty.metrics.MetricEventsListenerFactory;
import io.reactivex.netty.metrics.MetricEventsSubject;
import io.reactivex.netty.pipeline.PipelineConfigurators;
import io.reactivex.netty.protocol.http.client.CompositeHttpClient;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;

public class CompositeHttpClientBuilder<I, O>
extends AbstractClientBuilder<HttpClientRequest<I>, HttpClientResponse<O>, CompositeHttpClientBuilder<I, O>, CompositeHttpClient<I, O>> {
    private static final RxClient.ServerInfo defaultServer = new RxClient.ServerInfo();

    public CompositeHttpClientBuilder() {
        this(new Bootstrap());
    }

    public CompositeHttpClientBuilder(Bootstrap bootstrap) {
        this(bootstrap, new UnpooledClientConnectionFactory<HttpClientResponse<O>, HttpClientRequest<I>>(), new ClientChannelFactoryImpl<HttpClientResponse<O>, HttpClientRequest<I>>(bootstrap));
    }

    public CompositeHttpClientBuilder(Bootstrap bootstrap, ClientConnectionFactory<HttpClientResponse<O>, HttpClientRequest<I>, ? extends ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> connectionFactory, ClientChannelFactory<HttpClientResponse<O>, HttpClientRequest<I>> factory) {
        super(bootstrap, defaultServer.getHost(), defaultServer.getPort(), connectionFactory, factory);
        this.clientConfig = HttpClient.HttpClientConfig.Builder.newDefaultConfig();
        this.pipelineConfigurator(PipelineConfigurators.httpClientConfigurator());
    }

    public CompositeHttpClientBuilder(Bootstrap bootstrap, ConnectionPoolBuilder<HttpClientResponse<O>, HttpClientRequest<I>> poolBuilder) {
        super(bootstrap, defaultServer.getHost(), defaultServer.getPort(), poolBuilder);
        this.clientConfig = HttpClient.HttpClientConfig.Builder.newDefaultConfig();
        this.pipelineConfigurator(PipelineConfigurators.httpClientConfigurator());
    }

    @Override
    public CompositeHttpClientBuilder<I, O> withConnectionPoolLimitStrategy(PoolLimitDeterminationStrategy strategy) {
        if (strategy instanceof CloneablePoolLimitDeterminationStrategy) {
            return this.withConnectionPoolLimitStrategy((CloneablePoolLimitDeterminationStrategy)strategy);
        }
        throw new IllegalArgumentException("Only " + CloneablePoolLimitDeterminationStrategy.class.getName() + " strategy implementations are allowed.");
    }

    public CompositeHttpClientBuilder<I, O> withConnectionPoolLimitStrategy(CloneablePoolLimitDeterminationStrategy strategy) {
        super.withConnectionPoolLimitStrategy(strategy);
        return this;
    }

    @Override
    public CompositeHttpClientBuilder<I, O> withMaxConnections(int maxConnections) {
        return (CompositeHttpClientBuilder)super.withMaxConnections(maxConnections);
    }

    @Override
    protected Class<? extends SocketChannel> defaultSocketChannelClass() {
        if (RxNetty.isUsingNativeTransport()) {
            return EpollSocketChannel.class;
        }
        return super.defaultSocketChannelClass();
    }

    @Override
    protected EventLoopGroup defaultEventloop(Class<? extends Channel> socketChannel) {
        return RxNetty.getRxEventLoopProvider().globalClientEventLoop(true);
    }

    @Override
    protected CompositeHttpClient<I, O> createClient() {
        if (null == this.poolBuilder) {
            return new CompositeHttpClient(this.getOrCreateName(), this.serverInfo, this.bootstrap, this.pipelineConfigurator, this.clientConfig, this.channelFactory, this.connectionFactory, (MetricEventsSubject<ClientMetricsEvent<?>>)this.eventsSubject);
        }
        return new CompositeHttpClient(this.getOrCreateName(), this.serverInfo, this.bootstrap, this.pipelineConfigurator, this.clientConfig, this.poolBuilder, (MetricEventsSubject<ClientMetricsEvent<?>>)this.eventsSubject);
    }

    @Override
    protected String generatedNamePrefix() {
        return "HttpClient-";
    }

    @Override
    protected MetricEventsListener<? extends ClientMetricsEvent<?>> newMetricsListener(MetricEventsListenerFactory factory, CompositeHttpClient<I, O> client) {
        return factory.forHttpClient(client);
    }

    public static interface CloneablePoolLimitDeterminationStrategy
    extends PoolLimitDeterminationStrategy {
        public CloneablePoolLimitDeterminationStrategy copy();
    }
}

