/*
 * Decompiled with CFR 0.152.
 */
package io.seata.discovery.registry.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.discovery.registry.RegistryService;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class NacosRegistryServiceImpl
implements RegistryService<EventListener> {
    private static final String DEFAULT_NAMESPACE = "";
    private static final String DEFAULT_CLUSTER = "default";
    private static final String DEFAULT_GROUP = "DEFAULT_GROUP";
    private static final String DEFAULT_APPLICATION = "seata-server";
    private static final String PRO_SERVER_ADDR_KEY = "serverAddr";
    private static final String PRO_NAMESPACE_KEY = "namespace";
    private static final String REGISTRY_TYPE = "nacos";
    private static final String REGISTRY_CLUSTER = "cluster";
    private static final String PRO_APPLICATION_KEY = "application";
    private static final String PRO_GROUP_KEY = "group";
    private static final String USER_NAME = "username";
    private static final String PASSWORD = "password";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static volatile NamingService naming;
    private static final ConcurrentMap<String, List<EventListener>> LISTENER_SERVICE_MAP;
    private static final ConcurrentMap<String, List<InetSocketAddress>> CLUSTER_ADDRESS_MAP;
    private static volatile NacosRegistryServiceImpl instance;
    private static final Object LOCK_OBJ;

    private NacosRegistryServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static NacosRegistryServiceImpl getInstance() {
        if (instance != null) return instance;
        Class<NacosRegistryServiceImpl> clazz = NacosRegistryServiceImpl.class;
        synchronized (NacosRegistryServiceImpl.class) {
            if (instance != null) return instance;
            instance = new NacosRegistryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void register(InetSocketAddress address) throws Exception {
        this.validAddress(address);
        NacosRegistryServiceImpl.getNamingInstance().registerInstance(NacosRegistryServiceImpl.getServiceName(), NacosRegistryServiceImpl.getServiceGroup(), address.getAddress().getHostAddress(), address.getPort(), NacosRegistryServiceImpl.getClusterName());
    }

    @Override
    public void unregister(InetSocketAddress address) throws Exception {
        this.validAddress(address);
        NacosRegistryServiceImpl.getNamingInstance().deregisterInstance(NacosRegistryServiceImpl.getServiceName(), NacosRegistryServiceImpl.getServiceGroup(), address.getAddress().getHostAddress(), address.getPort(), NacosRegistryServiceImpl.getClusterName());
    }

    @Override
    public void subscribe(String cluster, EventListener listener) throws Exception {
        ArrayList<String> clusters = new ArrayList<String>();
        clusters.add(cluster);
        LISTENER_SERVICE_MAP.computeIfAbsent(cluster, key -> new ArrayList()).add(listener);
        NacosRegistryServiceImpl.getNamingInstance().subscribe(NacosRegistryServiceImpl.getServiceName(), NacosRegistryServiceImpl.getServiceGroup(), clusters, listener);
    }

    @Override
    public void unsubscribe(String cluster, EventListener listener) throws Exception {
        ArrayList<String> clusters = new ArrayList<String>();
        clusters.add(cluster);
        List subscribeList = (List)LISTENER_SERVICE_MAP.get(cluster);
        if (subscribeList != null) {
            List newSubscribeList = subscribeList.stream().filter(eventListener -> !eventListener.equals(listener)).collect(Collectors.toList());
            LISTENER_SERVICE_MAP.put(cluster, newSubscribeList);
        }
        NacosRegistryServiceImpl.getNamingInstance().unsubscribe(NacosRegistryServiceImpl.getServiceName(), NacosRegistryServiceImpl.getServiceGroup(), clusters, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InetSocketAddress> lookup(String key) throws Exception {
        String clusterName = this.getServiceGroup(key);
        if (clusterName == null) {
            return null;
        }
        if (!LISTENER_SERVICE_MAP.containsKey(clusterName)) {
            Object object = LOCK_OBJ;
            synchronized (object) {
                if (!LISTENER_SERVICE_MAP.containsKey(clusterName)) {
                    ArrayList<String> clusters = new ArrayList<String>();
                    clusters.add(clusterName);
                    List firstAllInstances = NacosRegistryServiceImpl.getNamingInstance().getAllInstances(NacosRegistryServiceImpl.getServiceName(), NacosRegistryServiceImpl.getServiceGroup(), clusters);
                    if (null != firstAllInstances) {
                        List newAddressList = firstAllInstances.stream().filter(instance -> instance.isEnabled() && instance.isHealthy()).map(instance -> new InetSocketAddress(instance.getIp(), instance.getPort())).collect(Collectors.toList());
                        CLUSTER_ADDRESS_MAP.put(clusterName, newAddressList);
                    }
                    this.subscribe(clusterName, event -> {
                        List instances = ((NamingEvent)event).getInstances();
                        if (null == instances && null != CLUSTER_ADDRESS_MAP.get(clusterName)) {
                            CLUSTER_ADDRESS_MAP.remove(clusterName);
                        } else if (!CollectionUtils.isEmpty((Collection)instances)) {
                            List newAddressList = instances.stream().filter(instance -> instance.isEnabled() && instance.isHealthy()).map(instance -> new InetSocketAddress(instance.getIp(), instance.getPort())).collect(Collectors.toList());
                            CLUSTER_ADDRESS_MAP.put(clusterName, newAddressList);
                        }
                    });
                }
            }
        }
        return (List)CLUSTER_ADDRESS_MAP.get(clusterName);
    }

    @Override
    public void close() throws Exception {
    }

    private void validAddress(InetSocketAddress address) {
        if (address.getHostName() == null || 0 == address.getPort()) {
            throw new IllegalArgumentException("invalid address:" + address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NamingService getNamingInstance() throws Exception {
        if (naming != null) return naming;
        Class<NacosRegistryServiceImpl> clazz = NacosRegistryServiceImpl.class;
        synchronized (NacosRegistryServiceImpl.class) {
            if (naming != null) return naming;
            naming = NacosFactory.createNamingService((Properties)NacosRegistryServiceImpl.getNamingProperties());
            // ** MonitorExit[var0] (shouldn't be in output)
            return naming;
        }
    }

    private static Properties getNamingProperties() {
        String userName;
        Properties properties = new Properties();
        if (System.getProperty(PRO_SERVER_ADDR_KEY) != null) {
            properties.setProperty(PRO_SERVER_ADDR_KEY, System.getProperty(PRO_SERVER_ADDR_KEY));
        } else {
            String address = FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosAddrFileKey());
            if (address != null) {
                properties.setProperty(PRO_SERVER_ADDR_KEY, address);
            }
        }
        if (System.getProperty(PRO_NAMESPACE_KEY) != null) {
            properties.setProperty(PRO_NAMESPACE_KEY, System.getProperty(PRO_NAMESPACE_KEY));
        } else {
            String namespace = FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosNameSpaceFileKey());
            if (namespace == null) {
                namespace = DEFAULT_NAMESPACE;
            }
            properties.setProperty(PRO_NAMESPACE_KEY, namespace);
        }
        String string = userName = StringUtils.isNotBlank(System.getProperty(USER_NAME)) ? System.getProperty(USER_NAME) : FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosUserName());
        if (StringUtils.isNotBlank(userName)) {
            String password;
            String string2 = password = StringUtils.isNotBlank(System.getProperty(PASSWORD)) ? System.getProperty(PASSWORD) : FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosPassword());
            if (StringUtils.isNotBlank(password)) {
                properties.setProperty(USER_NAME, userName);
                properties.setProperty(PASSWORD, password);
            }
        }
        return properties;
    }

    private static String getClusterName() {
        return FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosClusterFileKey(), DEFAULT_CLUSTER);
    }

    private static String getServiceName() {
        return FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosApplicationFileKey(), DEFAULT_APPLICATION);
    }

    private static String getServiceGroup() {
        return FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosApplicationGroupKey(), DEFAULT_GROUP);
    }

    private static String getNacosAddrFileKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_SERVER_ADDR_KEY);
    }

    private static String getNacosNameSpaceFileKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_NAMESPACE_KEY);
    }

    private static String getNacosClusterFileKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, REGISTRY_CLUSTER);
    }

    private static String getNacosApplicationFileKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_APPLICATION_KEY);
    }

    private static String getNacosApplicationGroupKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_GROUP_KEY);
    }

    private static String getNacosUserName() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, USER_NAME);
    }

    private static String getNacosPassword() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PASSWORD);
    }

    static {
        LISTENER_SERVICE_MAP = new ConcurrentHashMap<String, List<EventListener>>();
        CLUSTER_ADDRESS_MAP = new ConcurrentHashMap<String, List<InetSocketAddress>>();
        LOCK_OBJ = new Object();
    }
}

