/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.parser;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import de.javakaffee.kryoserializers.JdkProxySerializer;
import io.seata.rm.datasource.undo.parser.KryoSerializer;
import io.seata.rm.datasource.undo.parser.UndoLogSerializerClassRegistry;
import java.lang.reflect.InvocationHandler;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoSerializerFactory
implements KryoFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(KryoSerializerFactory.class);
    private static final KryoSerializerFactory FACTORY = new KryoSerializerFactory();
    private KryoPool pool = new KryoPool.Builder((KryoFactory)this).softReferences().build();

    private KryoSerializerFactory() {
    }

    public static KryoSerializerFactory getInstance() {
        return FACTORY;
    }

    public KryoSerializer get() {
        return new KryoSerializer(this.pool.borrow());
    }

    public void returnKryo(KryoSerializer kryoSerializer) {
        if (kryoSerializer == null) {
            throw new IllegalArgumentException("kryoSerializer is null");
        }
        this.pool.release(kryoSerializer.getKryo());
    }

    public Kryo create() {
        Kryo kryo = new Kryo();
        kryo.setRegistrationRequired(false);
        kryo.register(SerialBlob.class, (Serializer)new BlobSerializer());
        kryo.register(SerialClob.class, (Serializer)new ClobSerializer());
        kryo.register(Timestamp.class, (Serializer)new TimestampSerializer());
        kryo.register(InvocationHandler.class, (Serializer)new JdkProxySerializer());
        UndoLogSerializerClassRegistry.getRegisteredClasses().forEach((clazz, ser) -> {
            if (ser == null) {
                kryo.register(clazz);
            } else {
                kryo.register(clazz, (Serializer)ser);
            }
        });
        return kryo;
    }

    private class TimestampSerializer
    extends Serializer<Timestamp> {
        private TimestampSerializer() {
        }

        public void write(Kryo kryo, Output output, Timestamp object) {
            output.writeLong(object.getTime(), true);
            output.writeInt(object.getNanos(), true);
        }

        public Timestamp read(Kryo kryo, Input input, Class<Timestamp> type) {
            Timestamp timestamp = new Timestamp(input.readLong(true));
            timestamp.setNanos(input.readInt(true));
            return timestamp;
        }
    }

    private static class ClobSerializer
    extends Serializer<Clob> {
        private ClobSerializer() {
        }

        public void write(Kryo kryo, Output output, Clob object) {
            try {
                String s = object.getSubString(1L, (int)object.length());
                output.writeString(s);
            }
            catch (SQLException e) {
                LOGGER.error("kryo write java.sql.Clob error: {}", (Object)e.getMessage(), (Object)e);
            }
        }

        public Clob read(Kryo kryo, Input input, Class<Clob> type) {
            try {
                String s = input.readString();
                return new SerialClob(s.toCharArray());
            }
            catch (SQLException e) {
                LOGGER.error("kryo read java.sql.Clob error: {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
    }

    private static class BlobSerializer
    extends Serializer<Blob> {
        private BlobSerializer() {
        }

        public void write(Kryo kryo, Output output, Blob object) {
            try {
                byte[] bytes = object.getBytes(1L, (int)object.length());
                output.writeInt(bytes.length, true);
                output.write(bytes);
            }
            catch (SQLException e) {
                LOGGER.error("kryo write java.sql.Blob error: {}", (Object)e.getMessage(), (Object)e);
            }
        }

        public Blob read(Kryo kryo, Input input, Class<Blob> type) {
            int length = input.readInt(true);
            byte[] bytes = input.readBytes(length);
            try {
                return new SerialBlob(bytes);
            }
            catch (SQLException e) {
                LOGGER.error("kryo read java.sql.Blob error: {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
    }
}

