/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.controller;

import cn.hutool.core.io.IoUtil;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.OutputStream;
import java.util.List;
import lombok.Generated;
import net.maku.generator.common.page.PageResult;
import net.maku.generator.common.query.Query;
import net.maku.generator.common.utils.Result;
import net.maku.generator.entity.ProjectModifyEntity;
import net.maku.generator.service.ProjectModifyService;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"maku-generator/gen/project"})
public class ProjectModifyController {
    private final ProjectModifyService projectModifyService;

    @GetMapping(value={"page"})
    public Result<PageResult<ProjectModifyEntity>> page(@Valid Query query) {
        PageResult<ProjectModifyEntity> page = this.projectModifyService.page(query);
        return Result.ok(page);
    }

    @GetMapping(value={"{id}"})
    public Result<ProjectModifyEntity> get(@PathVariable(value="id") Long id) {
        ProjectModifyEntity entity = (ProjectModifyEntity)this.projectModifyService.getById(id);
        return Result.ok(entity);
    }

    @PostMapping
    public Result<String> save(@RequestBody ProjectModifyEntity entity) {
        this.projectModifyService.save(entity);
        return Result.ok();
    }

    @PutMapping
    public Result<String> update(@RequestBody @Valid ProjectModifyEntity entity) {
        this.projectModifyService.updateById(entity);
        return Result.ok();
    }

    @DeleteMapping
    public Result<String> delete(@RequestBody List<Long> idList) {
        this.projectModifyService.removeByIds(idList);
        return Result.ok();
    }

    @GetMapping(value={"download/{id}"})
    public void download(@PathVariable(value="id") Long id, HttpServletResponse response) throws Exception {
        ProjectModifyEntity project = (ProjectModifyEntity)this.projectModifyService.getById(id);
        byte[] data = this.projectModifyService.download(project);
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + project.getModifyProjectName() + ".zip\"");
        response.addHeader("Content-Length", "" + data.length);
        response.setContentType("application/octet-stream; charset=UTF-8");
        IoUtil.write((OutputStream)response.getOutputStream(), (boolean)false, (byte[])data);
    }

    @Generated
    public ProjectModifyController(ProjectModifyService projectModifyService) {
        this.projectModifyService = projectModifyService;
    }
}

