/*
 * Decompiled with CFR 0.152.
 */
package com.ofpay.rex.captcha;

import com.ofpay.rex.captcha.CaptchaConfig;
import com.ofpay.rex.captcha.FillType;
import com.ofpay.rex.captcha.FontConfig;
import com.ofpay.rex.captcha.RandomUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrawCaptcha {
    private Logger logger = LoggerFactory.getLogger(DrawCaptcha.class);
    private static final ThreadLocal<DrawCaptcha> tdc = new ThreadLocal();
    public static final String IMAGE_FORMAT = "png";
    protected static final List<FontConfig> FONTS = new ArrayList<FontConfig>(){
        private static final long serialVersionUID = 2413410573604328031L;
        {
            this.add(new FontConfig("Candice", 30, 34, "Candice.ttf"));
            this.add(new FontConfig("Duality", 28, 33, "Duality.ttf"));
            this.add(new FontConfig("Jura", 28, 32, "Jura.ttf"));
            this.add(new FontConfig("Times", 28, 34, "TimesNewRomanBold.ttf"));
            this.add(new FontConfig("VeraSans", 24, 30, "VeraSansBold.ttf"));
        }
    };
    protected Color backgroundColor = new Color(255, 255, 255);
    protected Color foregroundColor = null;
    protected Color[] foregroundColors = new Color[]{new Color(27, 78, 181), new Color(22, 163, 35), new Color(214, 36, 7)};
    protected int picWidth = 120;
    protected int picHeight = 40;
    protected int lineWidth = 1;
    protected int nYperiod = 12;
    protected int nYamplitude = 14;
    protected int nXperiod = 11;
    protected int nXamplitude = 5;
    protected CaptchaConfig captchaConfig = null;
    protected float scale = 1.0f;
    protected BufferedImage bim = null;
    protected Graphics2D g2d = null;
    protected FontRenderContext frc = null;
    protected AffineTransform rotateATF = new AffineTransform();
    protected AffineTransform translateATF = new AffineTransform();

    private DrawCaptcha(CaptchaConfig ccfg, float fScale) {
        this.logger.debug("Use CaptchaConfig={}, fScale={} create DrawCaptcha.", (Object)ccfg, (Object)Float.valueOf(fScale));
        this.initDrawCaptcha(ccfg, fScale);
    }

    public static DrawCaptcha getInstance() {
        return DrawCaptcha.getDrawCaptcha(null, 1.0f);
    }

    public static DrawCaptcha getInstance(float scale) {
        return DrawCaptcha.getDrawCaptcha(null, scale);
    }

    public static DrawCaptcha getInstance(CaptchaConfig ccfg) {
        return DrawCaptcha.getDrawCaptcha(ccfg, 1.0f);
    }

    public static DrawCaptcha getInstance(CaptchaConfig ccfg, float scale) {
        return DrawCaptcha.getDrawCaptcha(ccfg, scale);
    }

    private static DrawCaptcha getDrawCaptcha(CaptchaConfig ccfg, float fScale) {
        DrawCaptcha dc = tdc.get();
        if (dc == null) {
            dc = new DrawCaptcha(ccfg, fScale);
            tdc.set(dc);
        }
        if (fScale != dc.scale) {
            tdc.remove();
            dc = new DrawCaptcha(ccfg, fScale);
            tdc.set(dc);
        }
        return dc;
    }

    private void initDrawCaptcha(CaptchaConfig ccfg, float fScale) {
        this.captchaConfig = null == ccfg ? new CaptchaConfig() : ccfg;
        if (fScale > 0.0f) {
            this.scale = fScale;
        }
        if (null == this.bim && null == this.g2d) {
            this.bim = new BufferedImage((int)((float)this.picWidth * this.scale), (int)((float)this.picHeight * this.scale), 1);
            this.g2d = this.bim.createGraphics();
            this.frc = this.g2d.getFontRenderContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createImage(String text, OutputStream outputStream, CaptchaConfig cconfig) {
        if (StringUtils.isEmpty((String)text)) {
            this.logger.info("Input param 'text' is empty.");
            return;
        }
        CaptchaConfig ccfg = null;
        ccfg = null != cconfig ? cconfig : this.captchaConfig;
        this.logger.debug("Use {} create Image", (Object)ccfg);
        if (null == this.g2d) {
            this.logger.error("createGraphics from BufferedImage = null");
            return;
        }
        this.init(this.g2d, ccfg);
        try {
            Rectangle2D r2d;
            if (ccfg.isbAntialias()) {
                this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (null == (r2d = this.writeText(this.g2d, ccfg, text, null))) {
                this.logger.error("writeText get a null Rectangle2D");
                return;
            }
            if (ccfg.isbDrawLine()) {
                this.writeLine(this.g2d, ccfg, r2d);
            }
            if (ccfg.isbAntialias()) {
                this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            }
            if (null != outputStream) {
                this.bim.flush();
                ImageIO.write((RenderedImage)this.bim, IMAGE_FORMAT, outputStream);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                }
                catch (IOException e) {
                    this.logger.error("DC, output stream flush error:", (Throwable)e);
                }
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    this.logger.error("DC, output stream close error:", (Throwable)e);
                }
            }
        }
    }

    protected void init(Graphics2D g2d, CaptchaConfig ccfg) {
        g2d.setBackground(this.backgroundColor);
        this.foregroundColor = this.foregroundColors[RandomUtils.nextInt((int)this.foregroundColors.length)];
        g2d.setColor(this.foregroundColor);
        g2d.setStroke(new BasicStroke(this.lineWidth));
        this.translateATF.setToTranslation(0.0, 0.0);
        g2d.setTransform(this.translateATF);
        g2d.scale(this.scale, this.scale);
        g2d.setClip(null);
        g2d.clearRect(0, 0, this.picWidth, this.picHeight);
    }

    protected Rectangle2D writeText(Graphics2D g2d, CaptchaConfig ccfg, String text, FontConfig fcfg) {
        if (fcfg == null) {
            fcfg = FONTS.get(RandomUtils.nextInt((int)FONTS.size()));
        }
        int maxX = 20;
        int maxY = Math.round((float)this.picHeight * 27.0f / 40.0f);
        GeneralPath gp = new GeneralPath();
        for (int i = 0; i < StringUtils.length((String)text); ++i) {
            String letter = String.valueOf(text.charAt(i));
            Font myFont = fcfg.getRandomSize();
            TextLayout tl = new TextLayout(letter, myFont, this.frc);
            Rectangle2D r2d = tl.getBounds();
            Shape s = null;
            if (ccfg.getMaxRotation() != 0) {
                int degree = RandomUtil.rand(ccfg.getMaxRotation() * -1, ccfg.getMaxRotation());
                this.rotateATF.setToRotation(Math.toRadians(degree), r2d.getCenterX(), r2d.getCenterY());
                s = tl.getOutline(this.rotateATF);
                this.translateATF.setToTranslation((double)maxX - s.getBounds2D().getX() - r2d.getWidth() * (double)RandomUtil.rand(ccfg.getConnectPercent() / 2, ccfg.getConnectPercent()) / 100.0, maxY);
                this.translateATF.concatenate(this.rotateATF);
                s = tl.getOutline(this.translateATF);
            } else {
                this.translateATF.setToTranslation((double)maxX - r2d.getWidth() * (double)RandomUtil.rand(ccfg.getConnectPercent() / 2, ccfg.getConnectPercent()) / 100.0, maxY);
                s = tl.getOutline(this.translateATF);
            }
            gp.append(s, false);
            maxX = (int)(s.getBounds2D().getX() + s.getBounds2D().getWidth() * (double)(1.0f - (float)RandomUtils.nextInt((int)ccfg.getConnectPercent()) / 100.0f));
        }
        if (ccfg.isbWaveImage()) {
            gp = this.waveImage(gp);
        }
        return this.fillGraphics(g2d, gp, ccfg.getFillType());
    }

    private Rectangle2D fillGraphics(Graphics2D g2d, GeneralPath gp, FillType fillType) {
        Rectangle2D r2d = gp.getBounds2D();
        int transX = RandomUtil.rand(-((int)r2d.getX()), (int)((double)this.picWidth - r2d.getX() - r2d.getWidth()));
        int transY = RandomUtil.rand(-((int)r2d.getY()), (int)((double)this.picHeight - r2d.getY() - r2d.getHeight()));
        this.translateATF.setToTranslation(transX, transY);
        g2d.transform(this.translateATF);
        switch (fillType) {
            case SOLID: {
                g2d.fill(gp);
                break;
            }
            case HOLLOW: {
                g2d.draw(gp);
                break;
            }
            default: {
                this.logger.info("Error fill type {}", (Object)fillType);
            }
        }
        return r2d;
    }

    protected GeneralPath waveImage(GeneralPath vgp) {
        float xp = this.nXperiod * RandomUtil.rand(1, 3);
        float yp = this.nYperiod * RandomUtil.rand(1, 2);
        float kx = RandomUtil.rand(0, 100);
        float ky = RandomUtil.rand(0, 100);
        GeneralPath gp = new GeneralPath();
        PathIterator pi = vgp.getPathIterator(null);
        float[] coords = new float[6];
        while (!pi.isDone()) {
            int pathType = pi.currentSegment(coords);
            switch (pathType) {
                case 0: {
                    gp.moveTo((double)coords[0] + Math.sin(ky + coords[1] / yp) * (double)this.nYamplitude, (double)coords[1] + Math.sin(kx + coords[0] / xp) * (double)this.nXamplitude);
                    break;
                }
                case 1: {
                    gp.lineTo((double)coords[0] + Math.sin(ky + coords[1] / yp) * (double)this.nYamplitude, (double)coords[1] + Math.sin(kx + coords[0] / xp) * (double)this.nXamplitude);
                    break;
                }
                case 2: {
                    double quadX = Math.sin(ky + coords[3] / yp) * (double)this.nYamplitude;
                    double quadY = Math.sin(kx + coords[2] / xp) * (double)this.nXamplitude;
                    gp.quadTo((double)coords[0] + quadX, (double)coords[1] + quadY, (double)coords[2] + quadX, (double)coords[3] + quadY);
                    break;
                }
                case 3: {
                    double cubicX = Math.sin(ky + coords[5] / yp) * (double)this.nYamplitude;
                    double cubicY = Math.sin(kx + coords[4] / xp) * (double)this.nXamplitude;
                    gp.curveTo((double)coords[0] + cubicX, (double)coords[1] + cubicY, (double)coords[2] + cubicX, (double)coords[3] + cubicY, (double)coords[4] + cubicX, (double)coords[5] + cubicY);
                    break;
                }
                case 4: {
                    gp.closePath();
                    break;
                }
                default: {
                    this.logger.info("Unsupported kind of path type {}.", (Object)pathType);
                }
            }
            pi.next();
        }
        return gp;
    }

    protected void writeLine(Graphics2D g2d, CaptchaConfig ccfg, Rectangle2D r2d) {
        int x1 = (int)r2d.getX();
        int x2 = (int)(r2d.getX() + r2d.getWidth());
        int y1 = RandomUtil.rand((int)r2d.getY(), (int)(r2d.getY() + r2d.getHeight()));
        int y2 = RandomUtil.rand((int)r2d.getY(), (int)(r2d.getY() + r2d.getHeight()));
        g2d.draw(new Line2D.Float(x1, y1, x2, y2));
    }

    public CaptchaConfig getCaptchaConfig() {
        if (null == this.captchaConfig) {
            this.captchaConfig = new CaptchaConfig();
        }
        return this.captchaConfig;
    }
}

