/*
 * Decompiled with CFR 0.152.
 */
package com.ofpay.rex.captcha;

import com.ofpay.rex.captcha.RandomUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.lang.StringUtils;

public class FileUtil {
    public static boolean file_exists(String filename) {
        try {
            return new File(filename).exists();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String fgets(RandomAccessFile raf) {
        try {
            if (raf.getFilePointer() == 0L) {
                return raf.readLine();
            }
            char chr = (char)raf.read();
            System.out.println(chr);
            if (chr != '\r' && chr != '\n') {
                raf.seek(raf.getFilePointer() - 2L);
                return FileUtil.fgets(raf);
            }
            return raf.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long filesize(File file) {
        return file.length();
    }

    public static RandomAccessFile fopen(File file, String model) {
        if (model == null) {
            model = "r";
        }
        try {
            return new RandomAccessFile(file, model);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean fseek(RandomAccessFile raf, long sk) {
        try {
            raf.seek(sk);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void fclose(RandomAccessFile raf) {
        try {
            raf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        File f = new File("src/main/resources/en.php");
        RandomAccessFile raf = FileUtil.fopen(f, "r");
        int length = StringUtils.length((String)FileUtil.fgets(raf));
        System.out.println("length=" + length);
        int size = (int)FileUtil.filesize(f);
        System.out.println("size=" + size);
        int line = RandomUtil.rand(1, size / length - 2);
        System.out.println("line=" + line);
        boolean seek = FileUtil.fseek(raf, length * line);
        System.out.println("seek=" + seek);
        String text = FileUtil.fgets(raf);
        System.out.println("text=" + text.trim());
        FileUtil.fclose(raf);
    }
}

