/*
 * Decompiled with CFR 0.152.
 */
package com.ofpay.rex.captcha;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontConfig {
    protected static final String FONT_RESOURCE_PATH = "/fonts/";
    private Logger logger = LoggerFactory.getLogger(FontConfig.class);
    private String name;
    private int minSize;
    private int maxSize;
    private String fontFile;
    private Font font;
    private Font[] fonts = null;

    public FontConfig(String name, int minSize, int maxSize, String fontFile) {
        this.name = name;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.fontFile = fontFile;
        try {
            this.font = Font.createFont(0, this.getClass().getResourceAsStream(FONT_RESOURCE_PATH + fontFile));
        }
        catch (FontFormatException e) {
            this.logger.error("FontFormatException", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("IOException", (Throwable)e);
        }
        this.fonts = new Font[maxSize - minSize + 1];
        for (int i = 0; i < this.fonts.length; ++i) {
            this.fonts[i] = this.font.deriveFont(0, minSize + i);
        }
    }

    public Font getRandomSize() {
        return this.fonts[RandomUtils.nextInt((int)this.fonts.length)];
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String getFontFile() {
        return this.fontFile;
    }

    public String getName() {
        return this.name;
    }

    public Font getFont() {
        return this.font;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CfgFont [name=");
        builder.append(this.name);
        builder.append(", minSize=");
        builder.append(this.minSize);
        builder.append(", maxSize=");
        builder.append(this.maxSize);
        builder.append(", fontFile=");
        builder.append(this.fontFile);
        builder.append("]");
        return builder.toString();
    }
}

