/*
 * Decompiled with CFR 0.152.
 */
package com.ofpay.rex.control;

import com.ofpay.rex.control.Base64;
import com.ofpay.rex.control.SafeControlVO;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAPrivateKeySpec;
import javax.crypto.Cipher;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeControlHelper {
    private static ThreadLocal<Cipher> ciphers = new ThreadLocal();
    private static final String ALGORITHM = "RSA";
    private static final String CHARCODE = "ISO8859-1";
    private static final String PRIVATE_KEY = "SP_KEY";
    private static final String ENCODING = "ISO8859-1";
    private static Logger logger = LoggerFactory.getLogger(SafeControlHelper.class);
    private static RSAPrivateKey privateKey;

    public static boolean isX64Browser(HttpServletRequest req) {
        String userAgent = req.getHeader("User-Agent");
        return StringUtils.isNotBlank((String)userAgent) && userAgent.indexOf("x64") != -1;
    }

    public static SafeControlVO decodeSafeInput(String souce) {
        SafeControlVO safeControlVO = null;
        try {
            byte[] pureString;
            String[] strArray;
            String enString = Base64.decode(souce, "ISO8859-1");
            Cipher cipher = ciphers.get();
            if (cipher == null) {
                cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", (Provider)new BouncyCastleProvider());
                cipher.init(2, privateKey);
                ciphers.set(cipher);
            }
            if ((strArray = new String(pureString = cipher.doFinal(enString.getBytes("ISO8859-1")), "ISO8859-1").trim().split(",")).length >= 3) {
                safeControlVO = new SafeControlVO();
                safeControlVO.setPassword(URLDecoder.decode(strArray[0], "ISO8859-1"));
                safeControlVO.setCupid(strArray[1]);
                safeControlVO.setMac(strArray[2]);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("decode fail : {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.error("decode fail : {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return safeControlVO;
    }

    static {
        String privateKeyPath = System.getProperty(PRIVATE_KEY);
        logger.info("****************  pKey path {}  *****************", (Object)privateKeyPath);
        if (null == privateKeyPath || "".equals(privateKeyPath)) {
            logger.error("pKey path is null");
        } else {
            try {
                logger.info("**************** begin read pKey file  *****************");
                FileInputStream is = new FileInputStream(privateKeyPath);
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String readLine = null;
                StringBuilder sb = new StringBuilder();
                while ((readLine = br.readLine()) != null) {
                    if (readLine.charAt(0) == '-') continue;
                    sb.append(readLine);
                }
                logger.info("**************** end read pKey file  *****************");
                String buffer = Base64.decode(sb.toString(), "ISO8859-1");
                RSAPrivateKeyStructure asn1PrivKey = new RSAPrivateKeyStructure((ASN1Sequence)ASN1Sequence.fromByteArray((byte[])buffer.getBytes("ISO8859-1")));
                RSAPrivateKeySpec rsaPrivKeySpec = new RSAPrivateKeySpec(asn1PrivKey.getModulus(), asn1PrivKey.getPrivateExponent());
                KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
                privateKey = (RSAPrivateKey)keyFactory.generatePrivate(rsaPrivKeySpec);
            }
            catch (FileNotFoundException fe) {
                logger.error("pKey path \"{}\" not exist\uff01\uff01\uff01", (Object)privateKeyPath);
                fe.printStackTrace();
            }
            catch (Exception e) {
                logger.error("pKey load error: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

