/*
 * Decompiled with CFR 0.152.
 */
package com.ofpay.rex.security;

import java.io.IOException;
import java.util.Date;
import java.util.Stack;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class RequestRateThrottleFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(RequestRateThrottleFilter.class);
    private int hits = 5;
    private int period = 10;
    private static final String HITS = "hits";
    private static final String PERIOD = "period";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HttpSession session = request.getSession(true);
        String string = session.getId().intern();
        synchronized (string) {
            Stack<Date> times = (Stack<Date>)session.getAttribute("times");
            if (times == null) {
                times = new Stack<Date>();
                times.push(new Date(0L));
                session.setAttribute("times", times);
            }
            times.push(new Date());
            if (times.size() >= this.hits) {
                times.removeElementAt(0);
            }
            Date newest = (Date)times.get(times.size() - 1);
            Date oldest = (Date)times.get(0);
            long elapsed = newest.getTime() - oldest.getTime();
            if (elapsed < (long)(this.period * 1000)) {
                response.setContentType("text/html;charset=UTF-8");
                response.getWriter().println("\u8bf7\u6c42\u9891\u7387\u8fc7\u9ad8");
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void setHits(int hits) {
        this.hits = hits;
    }

    public void setPeriod(int period) {
        this.period = period;
    }
}

