/*
 * Decompiled with CFR 0.152.
 */
package com.ofpay.rex.security;

import com.ofpay.rex.security.validation.ValidationException;
import com.ofpay.rex.security.validation.ValidationPattern;
import com.ofpay.rex.util.HTMLEscapeUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(XssHttpServletRequestWrapper.class);
    private int paramNameSize = 200;
    private int paramValueSize = 2000;
    private String[] excludeFields;

    public XssHttpServletRequestWrapper(HttpServletRequest servletRequest, String[] excludeFields) {
        super(servletRequest);
        this.excludeFields = excludeFields;
    }

    public XssHttpServletRequestWrapper(HttpServletRequest servletRequest, String[] excludeFields, Integer pns, Integer pvs) {
        super(servletRequest);
        this.excludeFields = excludeFields;
        if (null != pns) {
            this.paramNameSize = pns;
        }
        if (null != pvs) {
            this.paramValueSize = pvs;
        }
    }

    public String getContextPath() {
        String path = super.getContextPath();
        if (path == null || "".equals(path.trim())) {
            return "";
        }
        String clean = "";
        try {
            clean = ValidationPattern.getValidInput("HTTP context path: " + path, path, "HTTPContextPath", 150, false);
        }
        catch (ValidationException e) {
            logger.warn("Skipping bad ContextPath", (Throwable)e);
        }
        return clean;
    }

    public Cookie[] getCookies() {
        Cookie[] cookies = super.getCookies();
        if (cookies == null) {
            return new Cookie[0];
        }
        ArrayList<Cookie> newCookies = new ArrayList<Cookie>();
        for (Cookie c : cookies) {
            try {
                String name = ValidationPattern.getValidInput("Cookie name: " + c.getName(), c.getName(), "HTTPCookieName", 150, true);
                String value = ValidationPattern.getValidInput("Cookie value: " + c.getValue(), c.getValue(), "HTTPCookieValue", 1000, true);
                int maxAge = c.getMaxAge();
                String domain = c.getDomain();
                String path = c.getPath();
                Cookie n = new Cookie(name, value);
                n.setMaxAge(maxAge);
                if (domain != null) {
                    n.setDomain(ValidationPattern.getValidInput("Cookie domain: " + domain, domain, "HTTPHeaderValue", 200, false));
                }
                if (path != null) {
                    n.setPath(ValidationPattern.getValidInput("Cookie path: " + path, path, "HTTPHeaderValue", 200, false));
                }
                newCookies.add(n);
            }
            catch (ValidationException e) {
                logger.warn("Skipping bad cookie: {}={}", new Object[]{c.getName(), c.getValue(), e});
            }
        }
        return newCookies.toArray(new Cookie[newCookies.size()]);
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        String clean = "";
        try {
            clean = ValidationPattern.getValidInput("HTTP header value: " + value, value, "HTTPHeaderValue", 150, true);
        }
        catch (ValidationException e) {
            logger.warn("Skipping bad Header", (Throwable)e);
        }
        return clean;
    }

    public Enumeration getHeaderNames() {
        Vector<String> v = new Vector<String>();
        Enumeration en = super.getHeaderNames();
        while (en.hasMoreElements()) {
            try {
                String name = (String)en.nextElement();
                String clean = ValidationPattern.getValidInput("HTTP header name: " + name, name, "HTTPHeaderName", 150, true);
                v.add(clean);
            }
            catch (ValidationException e) {
                logger.warn("Skipping bad HeaderNames.i", (Throwable)e);
            }
        }
        return v.elements();
    }

    public Enumeration getHeaders(String name) {
        Vector<String> v = new Vector<String>();
        Enumeration en = super.getHeaders(name);
        while (en.hasMoreElements()) {
            try {
                String value = (String)en.nextElement();
                String clean = ValidationPattern.getValidInput("HTTP header value (" + name + "): " + value, value, "HTTPHeaderValue", 2000, true);
                v.add(HTMLEscapeUtil.escape(clean));
            }
            catch (ValidationException e) {
                logger.warn("Skipping bad Headers.i", (Throwable)e);
            }
        }
        return v.elements();
    }

    public String getParameter(String name) {
        String orig = super.getParameter(name);
        String clean = null;
        try {
            clean = ValidationPattern.getValidInput("HTTP parameter name: " + name, orig, "HTTPParameterValue", this.paramValueSize, true);
            clean = ValidationPattern.stripXSS(clean);
        }
        catch (ValidationException e) {
            logger.warn("Skipping bad parameter", (Throwable)e);
        }
        return clean;
    }

    public Map getParameterMap() {
        Map map = super.getParameterMap();
        HashMap<String, String[]> cleanMap = new HashMap<String, String[]>();
        for (Map.Entry o : map.entrySet()) {
            try {
                Map.Entry e = o;
                String name = (String)e.getKey();
                String cleanName = ValidationPattern.getValidInput("HTTP parameter name: " + name, name, "HTTPParameterName", this.paramNameSize, true);
                String[] value = (String[])e.getValue();
                String[] cleanValues = new String[value.length];
                for (int j = 0; j < value.length; ++j) {
                    String cleanValue = ValidationPattern.getValidInput("HTTP parameter value: " + value[j], value[j], "HTTPParameterValue", this.paramValueSize, true);
                    cleanValues[j] = ValidationPattern.stripXSS(cleanValue);
                }
                cleanMap.put(cleanName, cleanValues);
            }
            catch (ValidationException e) {
                logger.warn("Skipping bad ParameterMap.i", (Throwable)e);
            }
        }
        return cleanMap;
    }

    public Enumeration getParameterNames() {
        Vector<String> v = new Vector<String>();
        Enumeration en = super.getParameterNames();
        while (en.hasMoreElements()) {
            try {
                String name = (String)en.nextElement();
                String clean = ValidationPattern.getValidInput("HTTP parameter name: " + name, name, "HTTPParameterName", this.paramNameSize, true);
                v.add(clean);
            }
            catch (ValidationException e) {
                logger.warn("Skipping bad ParameterNames.i", (Throwable)e);
            }
        }
        return v.elements();
    }

    public String[] getParameterValues(String name) {
        if (ArrayUtils.contains((Object[])this.excludeFields, (Object)name)) {
            return super.getParameterValues(name);
        }
        String[] values = super.getParameterValues(name);
        if (values == null) {
            return null;
        }
        ArrayList<String> newValues = new ArrayList<String>();
        for (String value : values) {
            try {
                String cleanValue = ValidationPattern.getValidInput("HTTP parameter value: " + value, value, "HTTPParameterValue", this.paramValueSize, true);
                newValues.add(ValidationPattern.stripXSS(cleanValue));
            }
            catch (ValidationException e) {
                logger.warn("Skipping bad ParameterValues.i", (Throwable)e);
            }
        }
        return newValues.toArray(new String[newValues.size()]);
    }

    public String getPathInfo() {
        String path = super.getPathInfo();
        if (path == null) {
            return null;
        }
        String clean = "";
        try {
            clean = ValidationPattern.getValidInput("HTTP path: " + path, path, "HTTPPath", 150, true);
        }
        catch (ValidationException e) {
            logger.warn("Skipping bad PathInfo", (Throwable)e);
        }
        return clean;
    }

    public String getQueryString() {
        String query = super.getQueryString();
        String clean = "";
        try {
            clean = ValidationPattern.getValidInput("HTTP query string: " + query, query, "HTTPQueryString", 2000, true);
        }
        catch (ValidationException e) {
            logger.warn("Skipping bad QueryString", (Throwable)e);
        }
        return clean;
    }

    public String getRequestedSessionId() {
        String id = super.getRequestedSessionId();
        String clean = "";
        try {
            clean = ValidationPattern.getValidInput("Requested cookie: " + id, id, "HTTPJSESSIONID", 128, false);
        }
        catch (ValidationException e) {
            logger.warn("Skipping bad RequestedSessionId", (Throwable)e);
        }
        return clean;
    }

    public String getRequestURI() {
        String uri = super.getRequestURI();
        String clean = "";
        try {
            clean = ValidationPattern.getValidInput("HTTP URI: " + uri, uri, "HTTPURI", 2000, false);
        }
        catch (ValidationException e) {
            logger.warn("Skipping bad RequestURI", (Throwable)e);
        }
        return clean;
    }

    public StringBuffer getRequestURL() {
        String url = super.getRequestURL().toString();
        String clean = "";
        try {
            clean = ValidationPattern.getValidInput("HTTP URL: " + url, url, "HTTPURL", 2000, false);
        }
        catch (ValidationException e) {
            logger.warn("Skipping bad RequestURL", (Throwable)e);
        }
        return new StringBuffer(clean);
    }

    public String getScheme() {
        String scheme = super.getScheme();
        String clean = "";
        try {
            clean = ValidationPattern.getValidInput("HTTP scheme: " + scheme, scheme, "HTTPScheme", 10, false);
        }
        catch (ValidationException e) {
            logger.warn("Skipping bad Scheme", (Throwable)e);
        }
        return clean;
    }

    public String getServerName() {
        String name = super.getServerName();
        String clean = "";
        try {
            clean = ValidationPattern.getValidInput("HTTP server name: " + name, name, "HTTPServerName", 100, false);
        }
        catch (ValidationException e) {
            logger.warn("Skipping bad ServerName", (Throwable)e);
        }
        return clean;
    }

    public int getServerPort() {
        int port = super.getServerPort();
        if (port < 0 || port > 65535) {
            logger.warn("HTTP server port out of range: " + port);
            port = 0;
        }
        return port;
    }

    public String getServletPath() {
        String path = super.getServletPath();
        String clean = "";
        try {
            clean = ValidationPattern.getValidInput("HTTP servlet path: " + path, path, "HTTPServletPath", 200, false);
        }
        catch (ValidationException e) {
            logger.warn("Skipping bad ServletPath", (Throwable)e);
        }
        return clean;
    }
}

