/*
 * Decompiled with CFR 0.152.
 */
package com.ofpay.rex.security.rate;

import com.ofpay.rex.security.rate.SessionRateControl;
import com.ofpay.rex.util.IPUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(RateFilter.class);
    private static final String HITS = "hits";
    private static final String PERIOD = "period";
    private static final String URI = "uri";
    private static final String TIMES = "times";
    private long hits = 50L;
    private long period = 100L;
    private int errCode = 403;
    private String errMsg = "Request rate too high";
    private Map<Integer, Long> hitsMap = new HashMap<Integer, Long>();
    private Map<Integer, Long> periodMap = new HashMap<Integer, Long>();
    private List<Pattern> uriList = new ArrayList<Pattern>();

    public static String getIp(HttpServletRequest request) {
        return IPUtil.getIp(request);
    }

    public void init(FilterConfig filterConfig) {
        int i;
        if (filterConfig.getInitParameter(URI) != null) {
            String uriStr = filterConfig.getInitParameter(URI);
            String[] uriArr = uriStr.split(",");
            for (i = 0; i < uriArr.length; ++i) {
                if ("".equals(uriArr[i].trim())) continue;
                this.uriList.add(Pattern.compile(uriArr[i].trim()));
            }
        }
        if (this.uriList.size() > 0) {
            if (filterConfig.getInitParameter(HITS) != null) {
                String hitsStr = filterConfig.getInitParameter(HITS);
                String[] hitsArr = hitsStr.split(",");
                for (i = 0; i < this.uriList.size(); ++i) {
                    if (hitsArr.length > i) {
                        this.hitsMap.put(i, Long.parseLong(hitsArr[i].trim()));
                        continue;
                    }
                    this.hitsMap.put(i, Long.parseLong(hitsArr[hitsArr.length - 1].trim()));
                }
            }
            if (filterConfig.getInitParameter(PERIOD) != null) {
                String periodStr = filterConfig.getInitParameter(PERIOD);
                String[] periodArr = periodStr.split(",");
                for (i = 0; i < this.uriList.size(); ++i) {
                    if (periodArr.length > i) {
                        this.periodMap.put(i, Long.parseLong(periodArr[i].trim()));
                        continue;
                    }
                    this.periodMap.put(i, Long.parseLong(periodArr[periodArr.length - 1].trim()));
                }
            }
            if (filterConfig.getInitParameter("errCode") != null) {
                this.errCode = Integer.valueOf(filterConfig.getInitParameter("errCode"));
            }
            if (filterConfig.getInitParameter("errMsg") != null) {
                this.errMsg = filterConfig.getInitParameter("errMsg");
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(true);
        String requestURI = httpRequest.getRequestURI();
        boolean hasMatch = false;
        Integer index = 0;
        for (int i = 0; i < this.uriList.size(); ++i) {
            Pattern pattern = this.uriList.get(i);
            Matcher matcher = pattern.matcher(requestURI);
            if (!matcher.find()) continue;
            logger.info("pattern match:" + pattern.toString());
            hasMatch = true;
            index = i;
            break;
        }
        if (hasMatch && SessionRateControl.checkRate(session, index.toString(), this.hitsMap.get(index).intValue(), this.periodMap.get(index).intValue())) {
            logger.error("ip:" + RateFilter.getIp(httpRequest) + " \u8bf7\u6c42\u5730\u5740:" + requestURI + "  " + this.periodMap.get(index) + "\u79d2\u5185\uff0c\u8d85\u8fc7" + this.hitsMap.get(index) + "\u6b21\u8bf7\u6c42\u88ab\u62e6\u622a!");
            ((HttpServletResponse)response).sendError(this.errCode, this.errMsg);
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

