/*
 * Decompiled with CFR 0.152.
 */
package com.ofpay.rex.security.rate;

import com.ofpay.rex.control.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import redis.clients.jedis.Jedis;

public class RedisRateControl {
    private static final String TIMES = "times";
    private static final String script = "local newest = ARGV[1];local period = ARGV[2];local hit = ARGV[3];local len = redis.call('LPUSH',KEYS[1],newest);redis.call('EXPIRE',KEYS[1],period);if len >= tonumber(hit) then  local oldest = redis.call('LINDEX',KEYS[1],-1); redis.call('LTRIM',KEYS[1],0,hit-2); local elapsed = newest - oldest; if elapsed < period*1000 then   return 1; end;end;return 0;";
    private static Logger logger = LoggerFactory.getLogger(RedisRateControl.class);
    private static String sha;

    public static boolean checkRate(RedisTemplate redisTemplate, String userKey, String urlKey, int hit, int period) {
        String[] args = new String[]{TIMES + userKey + "_" + Base64.encode(urlKey), String.valueOf(System.currentTimeMillis()), String.valueOf(period), String.valueOf(hit)};
        Long ret = null;
        try {
            if (sha == null) {
                sha = (String)RedisRateControl.scriptLoad(redisTemplate, script);
            }
            try {
                ret = (Long)RedisRateControl.evalsha(redisTemplate, sha, 1, args);
            }
            catch (Exception e) {
                sha = (String)RedisRateControl.scriptLoad(redisTemplate, script);
                ret = (Long)RedisRateControl.evalsha(redisTemplate, sha, 1, args);
            }
        }
        catch (Exception e) {
            logger.error("Redis rate control error:", (Throwable)e);
        }
        return ret != null && ret == 1L;
    }

    private static <T> T scriptLoad(RedisTemplate redisTemplate, final String script) {
        return (T)redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                return ((Jedis)connection.getNativeConnection()).scriptLoad(script);
            }
        });
    }

    private static <T> T evalsha(RedisTemplate redisTemplate, final String sha, final int keycount, final String ... args) {
        return (T)redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                return ((Jedis)connection.getNativeConnection()).evalsha(sha, keycount, args);
            }
        });
    }
}

