/*
 * Decompiled with CFR 0.152.
 */
package com.ofpay.rex.security.validation;

import com.ofpay.rex.security.validation.ValidationException;
import com.ofpay.rex.security.validation.ValidationRule;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationPattern {
    private static final Logger logger = LoggerFactory.getLogger(ValidationPattern.class);
    private static final String RESOURCE_FILE = "XSS.properties";
    private static Properties properties = new Properties();
    private static final Map<String, Pattern> patternCache;

    private ValidationPattern() {
    }

    public static Pattern getValidationPattern(String key) {
        String value = properties.getProperty("Validator." + key);
        Pattern p = patternCache.get(value);
        if (p != null) {
            return p;
        }
        if (value == null || value.equals("")) {
            return null;
        }
        try {
            Pattern q = Pattern.compile(value);
            patternCache.put(value, q);
            return q;
        }
        catch (PatternSyntaxException e) {
            logger.warn("SecurityConfiguration for " + key + " not a valid regex in XSS.properties. Returning null");
            return null;
        }
    }

    public static String getValidInput(String context, String input, String type, int maxLength, boolean allowNull) throws ValidationException {
        ValidationRule vr = new ValidationRule(type);
        Pattern p = ValidationPattern.getValidationPattern(type);
        if (p == null) {
            throw new IllegalArgumentException("The selected type [" + type + "] was not set via the validation configuration");
        }
        vr.addWhitelistPattern(p);
        vr.setMaximumLength(maxLength);
        vr.setAllowNull(allowNull);
        String ret = vr.getValid(context, input);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stripXSS(String value) {
        try {
            if (StringUtils.isBlank((String)value)) {
                String string = value;
                return string;
            }
            value = value.replaceAll("\u0000", "");
            value = ValidationPattern.htmlEncode(value);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return value;
        }
    }

    public static String htmlEncode(String source) {
        String html = "";
        if (source == null) {
            return html;
        }
        StringBuffer buffer = new StringBuffer();
        block7: for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            switch (c) {
                case '<': {
                    buffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    continue block7;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        html = buffer.toString();
        return html;
    }

    static {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = classLoader.getResourceAsStream(RESOURCE_FILE);
        try {
            properties.load(is);
        }
        catch (IOException e) {
            logger.error("load XSS.properties error", (Throwable)e);
        }
        patternCache = new HashMap<String, Pattern>();
    }
}

