/*
 * Decompiled with CFR 0.152.
 */
package com.ofpay.rex.security.validation;

import com.ofpay.rex.security.validation.ValidationException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ValidationRule {
    protected List<Pattern> whitelistPatterns = new ArrayList<Pattern>();
    protected List<Pattern> blacklistPatterns = new ArrayList<Pattern>();
    private boolean allowNull = false;
    private int minLength = 0;
    private int maxLength = Integer.MAX_VALUE;
    private String typeName = null;

    public ValidationRule(String typeName) {
        this.setTypeName(typeName);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public final void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public void setMinimumLength(int length) {
        this.minLength = length;
    }

    public void setMaximumLength(int length) {
        this.maxLength = length;
    }

    public void addWhitelistPattern(Pattern p) {
        if (p == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        this.whitelistPatterns.add(p);
    }

    public void addBlacklistPattern(Pattern p) {
        if (p == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        this.blacklistPatterns.add(p);
    }

    String checkEmpty(String context, String input) throws ValidationException {
        if (input != null) {
            return input;
        }
        if (this.allowNull) {
            return null;
        }
        throw new ValidationException(context + ": Input required.");
    }

    String checkLength(String context, String input) throws ValidationException {
        if (input.length() < this.minLength) {
            throw new ValidationException(context + ": Invalid input. The minimum length of " + this.minLength + " characters was not met.");
        }
        if (input.length() > this.maxLength) {
            throw new ValidationException(context + ": Invalid input. The maximum length of " + this.maxLength + " characters was exceeded.");
        }
        return input;
    }

    String checkWhitelist(String context, String input) throws ValidationException {
        for (Pattern p : this.whitelistPatterns) {
            if (p.matcher(input).matches()) continue;
            throw new ValidationException(context + ": Invalid input. Please conform to regex " + p.pattern() + (this.maxLength == Integer.MAX_VALUE ? "" : " with a maximum length of " + this.maxLength));
        }
        return input;
    }

    String checkBlacklist(String context, String input) throws ValidationException {
        for (Pattern p : this.blacklistPatterns) {
            if (!p.matcher(input).matches()) continue;
            throw new ValidationException(context + ": Invalid input. Dangerous input matching " + p.pattern() + " detected.");
        }
        return input;
    }

    public String getValid(String context, String input) throws ValidationException {
        if (this.checkEmpty(context, input) == null) {
            return null;
        }
        this.checkLength(context, input);
        return input;
    }
}

