/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.datasource;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;

public class ApplicationConnectionHolder {
    protected static Log log = LogProxy.get(ApplicationConnectionHolder.class);
    private static final Map<DataSource, Map<String, Connection>> connections = new HashMap<DataSource, Map<String, Connection>>();

    public static Connection get(DataSource ds, String name) {
        Map<String, Connection> map = connections.get(ds);
        if (null != map) {
            Connection connection = map.get(name);
            try {
                if (null != connection) {
                    log.info("[\u83b7\u53d6\u8de8\u7ebf\u7a0b\u4e8b\u52a1\u8fde\u63a5][name:{}]", (Object)name);
                    if (connection.isClosed()) {
                        map.remove(name);
                        connection = null;
                        log.info("[\u8de8\u7ebf\u7a0b\u4e8b\u52a1\u8fde\u63a5\u5f02\u5e38\u5173\u95ed]");
                    }
                }
                return connection;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void set(DataSource ds, String name, Connection con) {
        Map<String, Connection> map = connections.get(ds);
        if (null == map) {
            map = new HashMap<String, Connection>();
            connections.put(ds, map);
        }
        map.put(name, con);
    }

    public static void remove(DataSource ds, String name) {
        Map<String, Connection> map = connections.get(ds);
        if (null != map) {
            map.remove(name);
        }
    }

    public static boolean contains(DataSource ds, Connection connection) {
        Map<String, Connection> map = connections.get(ds);
        return null != map && map.containsValue(connection);
    }
}

