/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.runtime;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;

public interface RuntimeHolder {
    public static final Log log = LogProxy.get(RuntimeHolder.class);
    public static final Map<String, DataRuntime> runtimes = new Hashtable<String, DataRuntime>();

    public DataRuntime temporary(Object var1, String var2, DriverAdapter var3) throws Exception;

    public static boolean destroy(String datasource) throws Exception {
        DataRuntime runtime = RuntimeHolder.runtime(datasource);
        if (null != runtime) {
            return runtime.destroy();
        }
        return false;
    }

    public static Map<String, DataRuntime> runtimes(String origin) {
        Hashtable<String, DataRuntime> map = new Hashtable<String, DataRuntime>();
        for (String key : runtimes.keySet()) {
            DataRuntime runtime = runtimes.get(key);
            if (!origin.equals(runtime.origin())) continue;
            map.put(key, runtime);
        }
        return map;
    }

    public static DataRuntime runtime() {
        return RuntimeHolder.runtime(null);
    }

    public static DataRuntime runtime(String datasource) {
        DataRuntime runtime = null;
        if (null == datasource) {
            datasource = "default";
        }
        if (null == (runtime = runtimes.get(datasource))) {
            throw new RuntimeException("\u672a\u6ce8\u518c\u6570\u636e\u6e90:" + datasource);
        }
        return runtime;
    }

    public static boolean contains(String key) {
        if (null == key) {
            return false;
        }
        return runtimes.containsKey(key);
    }

    public static List<String> keys() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(runtimes.keySet());
        return list;
    }
}

