/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.entity;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class UrlEncodedFormEntity
extends StringEntity {
    public static UrlEncodedFormEntity create(Iterable<? extends NameValuePair> parameters, String charset) {
        try {
            return new UrlEncodedFormEntity(parameters, charset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    public static UrlEncodedFormEntity create(Iterable<? extends NameValuePair> parameters) {
        try {
            return new UrlEncodedFormEntity(parameters, null);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    public UrlEncodedFormEntity(List<? extends NameValuePair> parameters, String charset) throws UnsupportedEncodingException {
        super(URLEncodedUtils.format(parameters, charset != null ? charset : "ISO-8859-1"), ContentType.create((String)"application/x-www-form-urlencoded", (String)charset));
    }

    public UrlEncodedFormEntity(Iterable<? extends NameValuePair> parameters, String charset) throws UnsupportedEncodingException {
        super(URLEncodedUtils.format(parameters, charset != null ? charset : "ISO-8859-1"), ContentType.create((String)"application/x-www-form-urlencoded", (String)charset));
    }

    public UrlEncodedFormEntity(List<? extends NameValuePair> parameters) throws UnsupportedEncodingException {
        this(parameters, (String)null);
    }

    public UrlEncodedFormEntity(Iterable<? extends NameValuePair> parameters) throws UnsupportedEncodingException {
        this(parameters, null);
    }
}

